/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.entityresolution.model.transform;

import com.amazonaws.services.entityresolution.model.InputSource;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class InputSourceJsonUnmarshaller
implements Unmarshaller<InputSource, JsonUnmarshallerContext> {
    private static InputSourceJsonUnmarshaller instance;

    public InputSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        InputSource inputSource = new InputSource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("applyNormalization", targetDepth)) {
                    context.nextToken();
                    inputSource.setApplyNormalization((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("inputSourceARN", targetDepth)) {
                    context.nextToken();
                    inputSource.setInputSourceARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("schemaName", targetDepth)) {
                    context.nextToken();
                    inputSource.setSchemaName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return inputSource;
    }

    public static InputSourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InputSourceJsonUnmarshaller();
        }
        return instance;
    }
}

