/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.entityresolution.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/UpdateMatchingWorkflow"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateMatchingWorkflowResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A description of the workflow.
     * </p>
     */
    private String description;
    /**
     * <p>
     * An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
     * </p>
     */
    private IncrementalRunConfig incrementalRunConfig;
    /**
     * <p>
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     * <code>SchemaName</code>.
     * </p>
     */
    private java.util.List<InputSource> inputSourceConfig;
    /**
     * <p>
     * A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>,
     * <code>ApplyNormalization</code>, and <code>Output</code>.
     * </p>
     */
    private java.util.List<OutputSource> outputSourceConfig;
    /**
     * <p>
     * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>
     * </p>
     */
    private ResolutionTechniques resolutionTechniques;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role. AWS Entity Resolution assumes this role to create resources on
     * your behalf as part of workflow execution.
     * </p>
     */
    private String roleArn;
    /**
     * <p>
     * The name of the workflow.
     * </p>
     */
    private String workflowName;

    /**
     * <p>
     * A description of the workflow.
     * </p>
     * 
     * @param description
     *        A description of the workflow.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * A description of the workflow.
     * </p>
     * 
     * @return A description of the workflow.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * A description of the workflow.
     * </p>
     * 
     * @param description
     *        A description of the workflow.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateMatchingWorkflowResult withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
     * </p>
     * 
     * @param incrementalRunConfig
     *        An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
     */

    public void setIncrementalRunConfig(IncrementalRunConfig incrementalRunConfig) {
        this.incrementalRunConfig = incrementalRunConfig;
    }

    /**
     * <p>
     * An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
     * </p>
     * 
     * @return An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
     */

    public IncrementalRunConfig getIncrementalRunConfig() {
        return this.incrementalRunConfig;
    }

    /**
     * <p>
     * An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
     * </p>
     * 
     * @param incrementalRunConfig
     *        An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateMatchingWorkflowResult withIncrementalRunConfig(IncrementalRunConfig incrementalRunConfig) {
        setIncrementalRunConfig(incrementalRunConfig);
        return this;
    }

    /**
     * <p>
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     * <code>SchemaName</code>.
     * </p>
     * 
     * @return A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     *         <code>SchemaName</code>.
     */

    public java.util.List<InputSource> getInputSourceConfig() {
        return inputSourceConfig;
    }

    /**
     * <p>
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     * <code>SchemaName</code>.
     * </p>
     * 
     * @param inputSourceConfig
     *        A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     *        <code>SchemaName</code>.
     */

    public void setInputSourceConfig(java.util.Collection<InputSource> inputSourceConfig) {
        if (inputSourceConfig == null) {
            this.inputSourceConfig = null;
            return;
        }

        this.inputSourceConfig = new java.util.ArrayList<InputSource>(inputSourceConfig);
    }

    /**
     * <p>
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     * <code>SchemaName</code>.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setInputSourceConfig(java.util.Collection)} or {@link #withInputSourceConfig(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param inputSourceConfig
     *        A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     *        <code>SchemaName</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateMatchingWorkflowResult withInputSourceConfig(InputSource... inputSourceConfig) {
        if (this.inputSourceConfig == null) {
            setInputSourceConfig(new java.util.ArrayList<InputSource>(inputSourceConfig.length));
        }
        for (InputSource ele : inputSourceConfig) {
            this.inputSourceConfig.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     * <code>SchemaName</code>.
     * </p>
     * 
     * @param inputSourceConfig
     *        A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and
     *        <code>SchemaName</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateMatchingWorkflowResult withInputSourceConfig(java.util.Collection<InputSource> inputSourceConfig) {
        setInputSourceConfig(inputSourceConfig);
        return this;
    }

    /**
     * <p>
     * A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>,
     * <code>ApplyNormalization</code>, and <code>Output</code>.
     * </p>
     * 
     * @return A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>,
     *         <code>ApplyNormalization</code>, and <code>Output</code>.
     */

    public java.util.List<OutputSource> getOutputSourceConfig() {
        return outputSourceConfig;
    }

    /**
     * <p>
     * A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>,
     * <code>ApplyNormalization</code>, and <code>Output</code>.
     * </p>
     * 
     * @param outputSourceConfig
     *        A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>,
     *        <code>ApplyNormalization</code>, and <code>Output</code>.
     */

    public void setOutputSourceConfig(java.util.Collection<OutputSource> outputSourceConfig) {
        if (outputSourceConfig == null) {
            this.outputSourceConfig = null;
            return;
        }

        this.outputSourceConfig = new java.util.ArrayList<OutputSource>(outputSourceConfig);
    }

    /**
     * <p>
     * A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>,
     * <code>ApplyNormalization</code>, and <code>Output</code>.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setOutputSourceConfig(java.util.Collection)} or {@link #withOutputSourceConfig(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param outputSourceConfig
     *        A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>,
     *        <code>ApplyNormalization</code>, and <code>Output</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateMatchingWorkflowResult withOutputSourceConfig(OutputSource... outputSourceConfig) {
        if (this.outputSourceConfig == null) {
            setOutputSourceConfig(new java.util.ArrayList<OutputSource>(outputSourceConfig.length));
        }
        for (OutputSource ele : outputSourceConfig) {
            this.outputSourceConfig.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>,
     * <code>ApplyNormalization</code>, and <code>Output</code>.
     * </p>
     * 
     * @param outputSourceConfig
     *        A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>,
     *        <code>ApplyNormalization</code>, and <code>Output</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateMatchingWorkflowResult withOutputSourceConfig(java.util.Collection<OutputSource> outputSourceConfig) {
        setOutputSourceConfig(outputSourceConfig);
        return this;
    }

    /**
     * <p>
     * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>
     * </p>
     * 
     * @param resolutionTechniques
     *        An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>
     */

    public void setResolutionTechniques(ResolutionTechniques resolutionTechniques) {
        this.resolutionTechniques = resolutionTechniques;
    }

    /**
     * <p>
     * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>
     * </p>
     * 
     * @return An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>
     */

    public ResolutionTechniques getResolutionTechniques() {
        return this.resolutionTechniques;
    }

    /**
     * <p>
     * An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>
     * </p>
     * 
     * @param resolutionTechniques
     *        An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateMatchingWorkflowResult withResolutionTechniques(ResolutionTechniques resolutionTechniques) {
        setResolutionTechniques(resolutionTechniques);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role. AWS Entity Resolution assumes this role to create resources on
     * your behalf as part of workflow execution.
     * </p>
     * 
     * @param roleArn
     *        The Amazon Resource Name (ARN) of the IAM role. AWS Entity Resolution assumes this role to create
     *        resources on your behalf as part of workflow execution.
     */

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role. AWS Entity Resolution assumes this role to create resources on
     * your behalf as part of workflow execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role. AWS Entity Resolution assumes this role to create
     *         resources on your behalf as part of workflow execution.
     */

    public String getRoleArn() {
        return this.roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role. AWS Entity Resolution assumes this role to create resources on
     * your behalf as part of workflow execution.
     * </p>
     * 
     * @param roleArn
     *        The Amazon Resource Name (ARN) of the IAM role. AWS Entity Resolution assumes this role to create
     *        resources on your behalf as part of workflow execution.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateMatchingWorkflowResult withRoleArn(String roleArn) {
        setRoleArn(roleArn);
        return this;
    }

    /**
     * <p>
     * The name of the workflow.
     * </p>
     * 
     * @param workflowName
     *        The name of the workflow.
     */

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    /**
     * <p>
     * The name of the workflow.
     * </p>
     * 
     * @return The name of the workflow.
     */

    public String getWorkflowName() {
        return this.workflowName;
    }

    /**
     * <p>
     * The name of the workflow.
     * </p>
     * 
     * @param workflowName
     *        The name of the workflow.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateMatchingWorkflowResult withWorkflowName(String workflowName) {
        setWorkflowName(workflowName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getIncrementalRunConfig() != null)
            sb.append("IncrementalRunConfig: ").append(getIncrementalRunConfig()).append(",");
        if (getInputSourceConfig() != null)
            sb.append("InputSourceConfig: ").append(getInputSourceConfig()).append(",");
        if (getOutputSourceConfig() != null)
            sb.append("OutputSourceConfig: ").append(getOutputSourceConfig()).append(",");
        if (getResolutionTechniques() != null)
            sb.append("ResolutionTechniques: ").append(getResolutionTechniques()).append(",");
        if (getRoleArn() != null)
            sb.append("RoleArn: ").append(getRoleArn()).append(",");
        if (getWorkflowName() != null)
            sb.append("WorkflowName: ").append(getWorkflowName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateMatchingWorkflowResult == false)
            return false;
        UpdateMatchingWorkflowResult other = (UpdateMatchingWorkflowResult) obj;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getIncrementalRunConfig() == null ^ this.getIncrementalRunConfig() == null)
            return false;
        if (other.getIncrementalRunConfig() != null && other.getIncrementalRunConfig().equals(this.getIncrementalRunConfig()) == false)
            return false;
        if (other.getInputSourceConfig() == null ^ this.getInputSourceConfig() == null)
            return false;
        if (other.getInputSourceConfig() != null && other.getInputSourceConfig().equals(this.getInputSourceConfig()) == false)
            return false;
        if (other.getOutputSourceConfig() == null ^ this.getOutputSourceConfig() == null)
            return false;
        if (other.getOutputSourceConfig() != null && other.getOutputSourceConfig().equals(this.getOutputSourceConfig()) == false)
            return false;
        if (other.getResolutionTechniques() == null ^ this.getResolutionTechniques() == null)
            return false;
        if (other.getResolutionTechniques() != null && other.getResolutionTechniques().equals(this.getResolutionTechniques()) == false)
            return false;
        if (other.getRoleArn() == null ^ this.getRoleArn() == null)
            return false;
        if (other.getRoleArn() != null && other.getRoleArn().equals(this.getRoleArn()) == false)
            return false;
        if (other.getWorkflowName() == null ^ this.getWorkflowName() == null)
            return false;
        if (other.getWorkflowName() != null && other.getWorkflowName().equals(this.getWorkflowName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getIncrementalRunConfig() == null) ? 0 : getIncrementalRunConfig().hashCode());
        hashCode = prime * hashCode + ((getInputSourceConfig() == null) ? 0 : getInputSourceConfig().hashCode());
        hashCode = prime * hashCode + ((getOutputSourceConfig() == null) ? 0 : getOutputSourceConfig().hashCode());
        hashCode = prime * hashCode + ((getResolutionTechniques() == null) ? 0 : getResolutionTechniques().hashCode());
        hashCode = prime * hashCode + ((getRoleArn() == null) ? 0 : getRoleArn().hashCode());
        hashCode = prime * hashCode + ((getWorkflowName() == null) ? 0 : getWorkflowName().hashCode());
        return hashCode;
    }

    @Override
    public UpdateMatchingWorkflowResult clone() {
        try {
            return (UpdateMatchingWorkflowResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
