/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.Application;
import com.amazonaws.services.elasticmapreduce.model.ClusterStatus;
import com.amazonaws.services.elasticmapreduce.model.Ec2InstanceAttributes;
import com.amazonaws.services.elasticmapreduce.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Cluster
implements Serializable {
    private String id;
    private String name;
    private ClusterStatus status;
    private Ec2InstanceAttributes ec2InstanceAttributes;
    private String logUri;
    private String requestedAmiVersion;
    private String runningAmiVersion;
    private Boolean autoTerminate;
    private Boolean terminationProtected;
    private Boolean visibleToAllUsers;
    private ListWithAutoConstructFlag<Application> applications;
    private ListWithAutoConstructFlag<Tag> tags;
    private String serviceRole;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Cluster withId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Cluster withName(String name) {
        this.name = name;
        return this;
    }

    public ClusterStatus getStatus() {
        return this.status;
    }

    public void setStatus(ClusterStatus status) {
        this.status = status;
    }

    public Cluster withStatus(ClusterStatus status) {
        this.status = status;
        return this;
    }

    public Ec2InstanceAttributes getEc2InstanceAttributes() {
        return this.ec2InstanceAttributes;
    }

    public void setEc2InstanceAttributes(Ec2InstanceAttributes ec2InstanceAttributes) {
        this.ec2InstanceAttributes = ec2InstanceAttributes;
    }

    public Cluster withEc2InstanceAttributes(Ec2InstanceAttributes ec2InstanceAttributes) {
        this.ec2InstanceAttributes = ec2InstanceAttributes;
        return this;
    }

    public String getLogUri() {
        return this.logUri;
    }

    public void setLogUri(String logUri) {
        this.logUri = logUri;
    }

    public Cluster withLogUri(String logUri) {
        this.logUri = logUri;
        return this;
    }

    public String getRequestedAmiVersion() {
        return this.requestedAmiVersion;
    }

    public void setRequestedAmiVersion(String requestedAmiVersion) {
        this.requestedAmiVersion = requestedAmiVersion;
    }

    public Cluster withRequestedAmiVersion(String requestedAmiVersion) {
        this.requestedAmiVersion = requestedAmiVersion;
        return this;
    }

    public String getRunningAmiVersion() {
        return this.runningAmiVersion;
    }

    public void setRunningAmiVersion(String runningAmiVersion) {
        this.runningAmiVersion = runningAmiVersion;
    }

    public Cluster withRunningAmiVersion(String runningAmiVersion) {
        this.runningAmiVersion = runningAmiVersion;
        return this;
    }

    public Boolean isAutoTerminate() {
        return this.autoTerminate;
    }

    public void setAutoTerminate(Boolean autoTerminate) {
        this.autoTerminate = autoTerminate;
    }

    public Cluster withAutoTerminate(Boolean autoTerminate) {
        this.autoTerminate = autoTerminate;
        return this;
    }

    public Boolean getAutoTerminate() {
        return this.autoTerminate;
    }

    public Boolean isTerminationProtected() {
        return this.terminationProtected;
    }

    public void setTerminationProtected(Boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
    }

    public Cluster withTerminationProtected(Boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
        return this;
    }

    public Boolean getTerminationProtected() {
        return this.terminationProtected;
    }

    public Boolean isVisibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public void setVisibleToAllUsers(Boolean visibleToAllUsers) {
        this.visibleToAllUsers = visibleToAllUsers;
    }

    public Cluster withVisibleToAllUsers(Boolean visibleToAllUsers) {
        this.visibleToAllUsers = visibleToAllUsers;
        return this;
    }

    public Boolean getVisibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public List<Application> getApplications() {
        if (this.applications == null) {
            this.applications = new ListWithAutoConstructFlag();
            this.applications.setAutoConstruct(true);
        }
        return this.applications;
    }

    public void setApplications(Collection<Application> applications) {
        if (applications == null) {
            this.applications = null;
            return;
        }
        ListWithAutoConstructFlag applicationsCopy = new ListWithAutoConstructFlag(applications.size());
        applicationsCopy.addAll(applications);
        this.applications = applicationsCopy;
    }

    public Cluster withApplications(Application ... applications) {
        if (this.getApplications() == null) {
            this.setApplications(new ArrayList<Application>(applications.length));
        }
        for (Application value : applications) {
            this.getApplications().add(value);
        }
        return this;
    }

    public Cluster withApplications(Collection<Application> applications) {
        if (applications == null) {
            this.applications = null;
        } else {
            ListWithAutoConstructFlag applicationsCopy = new ListWithAutoConstructFlag(applications.size());
            applicationsCopy.addAll(applications);
            this.applications = applicationsCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public Cluster withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public Cluster withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String getServiceRole() {
        return this.serviceRole;
    }

    public void setServiceRole(String serviceRole) {
        this.serviceRole = serviceRole;
    }

    public Cluster withServiceRole(String serviceRole) {
        this.serviceRole = serviceRole;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: " + this.getId() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getEc2InstanceAttributes() != null) {
            sb.append("Ec2InstanceAttributes: " + this.getEc2InstanceAttributes() + ",");
        }
        if (this.getLogUri() != null) {
            sb.append("LogUri: " + this.getLogUri() + ",");
        }
        if (this.getRequestedAmiVersion() != null) {
            sb.append("RequestedAmiVersion: " + this.getRequestedAmiVersion() + ",");
        }
        if (this.getRunningAmiVersion() != null) {
            sb.append("RunningAmiVersion: " + this.getRunningAmiVersion() + ",");
        }
        if (this.isAutoTerminate() != null) {
            sb.append("AutoTerminate: " + this.isAutoTerminate() + ",");
        }
        if (this.isTerminationProtected() != null) {
            sb.append("TerminationProtected: " + this.isTerminationProtected() + ",");
        }
        if (this.isVisibleToAllUsers() != null) {
            sb.append("VisibleToAllUsers: " + this.isVisibleToAllUsers() + ",");
        }
        if (this.getApplications() != null) {
            sb.append("Applications: " + this.getApplications() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getServiceRole() != null) {
            sb.append("ServiceRole: " + this.getServiceRole());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getEc2InstanceAttributes() == null ? 0 : this.getEc2InstanceAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getLogUri() == null ? 0 : this.getLogUri().hashCode());
        hashCode = 31 * hashCode + (this.getRequestedAmiVersion() == null ? 0 : this.getRequestedAmiVersion().hashCode());
        hashCode = 31 * hashCode + (this.getRunningAmiVersion() == null ? 0 : this.getRunningAmiVersion().hashCode());
        hashCode = 31 * hashCode + (this.isAutoTerminate() == null ? 0 : this.isAutoTerminate().hashCode());
        hashCode = 31 * hashCode + (this.isTerminationProtected() == null ? 0 : this.isTerminationProtected().hashCode());
        hashCode = 31 * hashCode + (this.isVisibleToAllUsers() == null ? 0 : this.isVisibleToAllUsers().hashCode());
        hashCode = 31 * hashCode + (this.getApplications() == null ? 0 : this.getApplications().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRole() == null ? 0 : this.getServiceRole().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getEc2InstanceAttributes() == null ^ this.getEc2InstanceAttributes() == null) {
            return false;
        }
        if (other.getEc2InstanceAttributes() != null && !other.getEc2InstanceAttributes().equals(this.getEc2InstanceAttributes())) {
            return false;
        }
        if (other.getLogUri() == null ^ this.getLogUri() == null) {
            return false;
        }
        if (other.getLogUri() != null && !other.getLogUri().equals(this.getLogUri())) {
            return false;
        }
        if (other.getRequestedAmiVersion() == null ^ this.getRequestedAmiVersion() == null) {
            return false;
        }
        if (other.getRequestedAmiVersion() != null && !other.getRequestedAmiVersion().equals(this.getRequestedAmiVersion())) {
            return false;
        }
        if (other.getRunningAmiVersion() == null ^ this.getRunningAmiVersion() == null) {
            return false;
        }
        if (other.getRunningAmiVersion() != null && !other.getRunningAmiVersion().equals(this.getRunningAmiVersion())) {
            return false;
        }
        if (other.isAutoTerminate() == null ^ this.isAutoTerminate() == null) {
            return false;
        }
        if (other.isAutoTerminate() != null && !other.isAutoTerminate().equals(this.isAutoTerminate())) {
            return false;
        }
        if (other.isTerminationProtected() == null ^ this.isTerminationProtected() == null) {
            return false;
        }
        if (other.isTerminationProtected() != null && !other.isTerminationProtected().equals(this.isTerminationProtected())) {
            return false;
        }
        if (other.isVisibleToAllUsers() == null ^ this.isVisibleToAllUsers() == null) {
            return false;
        }
        if (other.isVisibleToAllUsers() != null && !other.isVisibleToAllUsers().equals(this.isVisibleToAllUsers())) {
            return false;
        }
        if (other.getApplications() == null ^ this.getApplications() == null) {
            return false;
        }
        if (other.getApplications() != null && !other.getApplications().equals(this.getApplications())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getServiceRole() == null ^ this.getServiceRole() == null) {
            return false;
        }
        return other.getServiceRole() == null || other.getServiceRole().equals(this.getServiceRole());
    }
}

