/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.StepState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListStepsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String clusterId;
    private ListWithAutoConstructFlag<String> stepStates;
    private ListWithAutoConstructFlag<String> stepIds;
    private String marker;

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public ListStepsRequest withClusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    public List<String> getStepStates() {
        if (this.stepStates == null) {
            this.stepStates = new ListWithAutoConstructFlag();
            this.stepStates.setAutoConstruct(true);
        }
        return this.stepStates;
    }

    public void setStepStates(Collection<String> stepStates) {
        if (stepStates == null) {
            this.stepStates = null;
            return;
        }
        ListWithAutoConstructFlag stepStatesCopy = new ListWithAutoConstructFlag(stepStates.size());
        stepStatesCopy.addAll(stepStates);
        this.stepStates = stepStatesCopy;
    }

    public ListStepsRequest withStepStates(String ... stepStates) {
        if (this.getStepStates() == null) {
            this.setStepStates(new ArrayList<String>(stepStates.length));
        }
        for (String value : stepStates) {
            this.getStepStates().add(value);
        }
        return this;
    }

    public ListStepsRequest withStepStates(Collection<String> stepStates) {
        if (stepStates == null) {
            this.stepStates = null;
        } else {
            ListWithAutoConstructFlag stepStatesCopy = new ListWithAutoConstructFlag(stepStates.size());
            stepStatesCopy.addAll(stepStates);
            this.stepStates = stepStatesCopy;
        }
        return this;
    }

    public ListStepsRequest withStepStates(StepState ... stepStates) {
        ArrayList<String> stepStatesCopy = new ArrayList<String>(stepStates.length);
        for (StepState member : stepStates) {
            stepStatesCopy.add(member.toString());
        }
        if (this.getStepStates() == null) {
            this.setStepStates(stepStatesCopy);
        } else {
            this.getStepStates().addAll(stepStatesCopy);
        }
        return this;
    }

    public List<String> getStepIds() {
        if (this.stepIds == null) {
            this.stepIds = new ListWithAutoConstructFlag();
            this.stepIds.setAutoConstruct(true);
        }
        return this.stepIds;
    }

    public void setStepIds(Collection<String> stepIds) {
        if (stepIds == null) {
            this.stepIds = null;
            return;
        }
        ListWithAutoConstructFlag stepIdsCopy = new ListWithAutoConstructFlag(stepIds.size());
        stepIdsCopy.addAll(stepIds);
        this.stepIds = stepIdsCopy;
    }

    public ListStepsRequest withStepIds(String ... stepIds) {
        if (this.getStepIds() == null) {
            this.setStepIds(new ArrayList<String>(stepIds.length));
        }
        for (String value : stepIds) {
            this.getStepIds().add(value);
        }
        return this;
    }

    public ListStepsRequest withStepIds(Collection<String> stepIds) {
        if (stepIds == null) {
            this.stepIds = null;
        } else {
            ListWithAutoConstructFlag stepIdsCopy = new ListWithAutoConstructFlag(stepIds.size());
            stepIdsCopy.addAll(stepIds);
            this.stepIds = stepIdsCopy;
        }
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListStepsRequest withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterId() != null) {
            sb.append("ClusterId: " + this.getClusterId() + ",");
        }
        if (this.getStepStates() != null) {
            sb.append("StepStates: " + this.getStepStates() + ",");
        }
        if (this.getStepIds() != null) {
            sb.append("StepIds: " + this.getStepIds() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterId() == null ? 0 : this.getClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getStepStates() == null ? 0 : this.getStepStates().hashCode());
        hashCode = 31 * hashCode + (this.getStepIds() == null ? 0 : this.getStepIds().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStepsRequest)) {
            return false;
        }
        ListStepsRequest other = (ListStepsRequest)obj;
        if (other.getClusterId() == null ^ this.getClusterId() == null) {
            return false;
        }
        if (other.getClusterId() != null && !other.getClusterId().equals(this.getClusterId())) {
            return false;
        }
        if (other.getStepStates() == null ^ this.getStepStates() == null) {
            return false;
        }
        if (other.getStepStates() != null && !other.getStepStates().equals(this.getStepStates())) {
            return false;
        }
        if (other.getStepIds() == null ^ this.getStepIds() == null) {
            return false;
        }
        if (other.getStepIds() != null && !other.getStepIds().equals(this.getStepIds())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }
}

