/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.Command;

public class CommandJsonMarshaller {
    private static CommandJsonMarshaller instance;

    public void marshall(Command command, StructuredJsonGenerator jsonGenerator) {
        if (command == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList argsList;
            jsonGenerator.writeStartObject();
            if (command.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(command.getName());
            }
            if (command.getScriptPath() != null) {
                jsonGenerator.writeFieldName("ScriptPath").writeValue(command.getScriptPath());
            }
            if (!(argsList = (SdkInternalList)command.getArgs()).isEmpty() || !argsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Args");
                jsonGenerator.writeStartArray();
                for (String argsListValue : argsList) {
                    if (argsListValue == null) continue;
                    jsonGenerator.writeValue(argsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CommandJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CommandJsonMarshaller();
        }
        return instance;
    }
}

