/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.Application;
import com.amazonaws.services.elasticmapreduce.model.Cluster;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.Tag;
import com.amazonaws.services.elasticmapreduce.model.transform.ApplicationJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ClusterStatusJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ConfigurationJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.Ec2InstanceAttributesJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.TagJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class ClusterJsonMarshaller {
    private static ClusterJsonMarshaller instance;

    public void marshall(Cluster cluster, StructuredJsonGenerator jsonGenerator) {
        if (cluster == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList configurationsList;
            SdkInternalList tagsList;
            SdkInternalList applicationsList;
            jsonGenerator.writeStartObject();
            if (cluster.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(cluster.getId());
            }
            if (cluster.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(cluster.getName());
            }
            if (cluster.getStatus() != null) {
                jsonGenerator.writeFieldName("Status");
                ClusterStatusJsonMarshaller.getInstance().marshall(cluster.getStatus(), jsonGenerator);
            }
            if (cluster.getEc2InstanceAttributes() != null) {
                jsonGenerator.writeFieldName("Ec2InstanceAttributes");
                Ec2InstanceAttributesJsonMarshaller.getInstance().marshall(cluster.getEc2InstanceAttributes(), jsonGenerator);
            }
            if (cluster.getLogUri() != null) {
                jsonGenerator.writeFieldName("LogUri").writeValue(cluster.getLogUri());
            }
            if (cluster.getRequestedAmiVersion() != null) {
                jsonGenerator.writeFieldName("RequestedAmiVersion").writeValue(cluster.getRequestedAmiVersion());
            }
            if (cluster.getRunningAmiVersion() != null) {
                jsonGenerator.writeFieldName("RunningAmiVersion").writeValue(cluster.getRunningAmiVersion());
            }
            if (cluster.getReleaseLabel() != null) {
                jsonGenerator.writeFieldName("ReleaseLabel").writeValue(cluster.getReleaseLabel());
            }
            if (cluster.getAutoTerminate() != null) {
                jsonGenerator.writeFieldName("AutoTerminate").writeValue(cluster.getAutoTerminate().booleanValue());
            }
            if (cluster.getTerminationProtected() != null) {
                jsonGenerator.writeFieldName("TerminationProtected").writeValue(cluster.getTerminationProtected().booleanValue());
            }
            if (cluster.getVisibleToAllUsers() != null) {
                jsonGenerator.writeFieldName("VisibleToAllUsers").writeValue(cluster.getVisibleToAllUsers().booleanValue());
            }
            if (!(applicationsList = (SdkInternalList)cluster.getApplications()).isEmpty() || !applicationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Applications");
                jsonGenerator.writeStartArray();
                for (Application applicationsListValue : applicationsList) {
                    if (applicationsListValue == null) continue;
                    ApplicationJsonMarshaller.getInstance().marshall(applicationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(tagsList = (SdkInternalList)cluster.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Tags");
                jsonGenerator.writeStartArray();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (cluster.getServiceRole() != null) {
                jsonGenerator.writeFieldName("ServiceRole").writeValue(cluster.getServiceRole());
            }
            if (cluster.getNormalizedInstanceHours() != null) {
                jsonGenerator.writeFieldName("NormalizedInstanceHours").writeValue(cluster.getNormalizedInstanceHours().intValue());
            }
            if (cluster.getMasterPublicDnsName() != null) {
                jsonGenerator.writeFieldName("MasterPublicDnsName").writeValue(cluster.getMasterPublicDnsName());
            }
            if (!(configurationsList = (SdkInternalList)cluster.getConfigurations()).isEmpty() || !configurationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Configurations");
                jsonGenerator.writeStartArray();
                for (Configuration configurationsListValue : configurationsList) {
                    if (configurationsListValue == null) continue;
                    ConfigurationJsonMarshaller.getInstance().marshall(configurationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ClusterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ClusterJsonMarshaller();
        }
        return instance;
    }
}

