/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticmapreduce.model.KeyValue;
import com.amazonaws.util.json.SdkJsonGenerator;

public class KeyValueJsonMarshaller {
    private static KeyValueJsonMarshaller instance;

    public void marshall(KeyValue keyValue, SdkJsonGenerator jsonGenerator) {
        if (keyValue == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (keyValue.getKey() != null) {
                jsonGenerator.writeFieldName("Key").writeValue(keyValue.getKey());
            }
            if (keyValue.getValue() != null) {
                jsonGenerator.writeFieldName("Value").writeValue(keyValue.getValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static KeyValueJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new KeyValueJsonMarshaller();
        }
        return instance;
    }
}

