/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticmapreduce.model.ClusterStatus;
import com.amazonaws.services.elasticmapreduce.model.transform.ClusterStateChangeReasonJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ClusterTimelineJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class ClusterStatusJsonMarshaller {
    private static ClusterStatusJsonMarshaller instance;

    public void marshall(ClusterStatus clusterStatus, SdkJsonGenerator jsonGenerator) {
        if (clusterStatus == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (clusterStatus.getState() != null) {
                jsonGenerator.writeFieldName("State").writeValue(clusterStatus.getState());
            }
            if (clusterStatus.getStateChangeReason() != null) {
                jsonGenerator.writeFieldName("StateChangeReason");
                ClusterStateChangeReasonJsonMarshaller.getInstance().marshall(clusterStatus.getStateChangeReason(), jsonGenerator);
            }
            if (clusterStatus.getTimeline() != null) {
                jsonGenerator.writeFieldName("Timeline");
                ClusterTimelineJsonMarshaller.getInstance().marshall(clusterStatus.getTimeline(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ClusterStatusJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ClusterStatusJsonMarshaller();
        }
        return instance;
    }
}

