/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.EbsVolume;
import com.amazonaws.services.elasticmapreduce.model.Instance;
import com.amazonaws.services.elasticmapreduce.model.transform.EbsVolumeJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceStatusJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class InstanceJsonMarshaller {
    private static InstanceJsonMarshaller instance;

    public void marshall(Instance instance, JSONWriter jsonWriter) {
        if (instance == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList ebsVolumesList;
            jsonWriter.object();
            if (instance.getId() != null) {
                jsonWriter.key("Id").value((Object)instance.getId());
            }
            if (instance.getEc2InstanceId() != null) {
                jsonWriter.key("Ec2InstanceId").value((Object)instance.getEc2InstanceId());
            }
            if (instance.getPublicDnsName() != null) {
                jsonWriter.key("PublicDnsName").value((Object)instance.getPublicDnsName());
            }
            if (instance.getPublicIpAddress() != null) {
                jsonWriter.key("PublicIpAddress").value((Object)instance.getPublicIpAddress());
            }
            if (instance.getPrivateDnsName() != null) {
                jsonWriter.key("PrivateDnsName").value((Object)instance.getPrivateDnsName());
            }
            if (instance.getPrivateIpAddress() != null) {
                jsonWriter.key("PrivateIpAddress").value((Object)instance.getPrivateIpAddress());
            }
            if (instance.getStatus() != null) {
                jsonWriter.key("Status");
                InstanceStatusJsonMarshaller.getInstance().marshall(instance.getStatus(), jsonWriter);
            }
            if (instance.getInstanceGroupId() != null) {
                jsonWriter.key("InstanceGroupId").value((Object)instance.getInstanceGroupId());
            }
            if (!(ebsVolumesList = (SdkInternalList)instance.getEbsVolumes()).isEmpty() || !ebsVolumesList.isAutoConstruct()) {
                jsonWriter.key("EbsVolumes");
                jsonWriter.array();
                for (EbsVolume ebsVolumesListValue : ebsVolumesList) {
                    if (ebsVolumesListValue == null) continue;
                    EbsVolumeJsonMarshaller.getInstance().marshall(ebsVolumesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceJsonMarshaller();
        }
        return instance;
    }
}

