/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.transform.NotificationsJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.PipelineOutputConfigJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdatePipelineRequestMarshaller
implements Marshaller<Request<UpdatePipelineRequest>, UpdatePipelineRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<UpdatePipelineRequest> marshall(UpdatePipelineRequest updatePipelineRequest) {
        if (updatePipelineRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updatePipelineRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/2012-09-25/pipelines/{Id}";
        uriResourcePath = uriResourcePath.replace("{Id}", updatePipelineRequest.getId() != null ? StringUtils.fromString((String)updatePipelineRequest.getId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (updatePipelineRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(updatePipelineRequest.getName());
            }
            if (updatePipelineRequest.getInputBucket() != null) {
                jsonGenerator.writeFieldName("InputBucket").writeValue(updatePipelineRequest.getInputBucket());
            }
            if (updatePipelineRequest.getRole() != null) {
                jsonGenerator.writeFieldName("Role").writeValue(updatePipelineRequest.getRole());
            }
            if (updatePipelineRequest.getAwsKmsKeyArn() != null) {
                jsonGenerator.writeFieldName("AwsKmsKeyArn").writeValue(updatePipelineRequest.getAwsKmsKeyArn());
            }
            if (updatePipelineRequest.getNotifications() != null) {
                jsonGenerator.writeFieldName("Notifications");
                NotificationsJsonMarshaller.getInstance().marshall(updatePipelineRequest.getNotifications(), jsonGenerator);
            }
            if (updatePipelineRequest.getContentConfig() != null) {
                jsonGenerator.writeFieldName("ContentConfig");
                PipelineOutputConfigJsonMarshaller.getInstance().marshall(updatePipelineRequest.getContentConfig(), jsonGenerator);
            }
            if (updatePipelineRequest.getThumbnailConfig() != null) {
                jsonGenerator.writeFieldName("ThumbnailConfig");
                PipelineOutputConfigJsonMarshaller.getInstance().marshall(updatePipelineRequest.getThumbnailConfig(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

