/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elastictranscoder.model.Playlist;
import com.amazonaws.services.elastictranscoder.model.transform.HlsContentProtectionJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.PlayReadyDrmJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class PlaylistJsonMarshaller {
    private static PlaylistJsonMarshaller instance;

    public void marshall(Playlist playlist, SdkJsonGenerator jsonGenerator) {
        if (playlist == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList outputKeysList;
            jsonGenerator.writeStartObject();
            if (playlist.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(playlist.getName());
            }
            if (playlist.getFormat() != null) {
                jsonGenerator.writeFieldName("Format").writeValue(playlist.getFormat());
            }
            if (!(outputKeysList = (SdkInternalList)playlist.getOutputKeys()).isEmpty() || !outputKeysList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("OutputKeys");
                jsonGenerator.writeStartArray();
                for (String outputKeysListValue : outputKeysList) {
                    if (outputKeysListValue == null) continue;
                    jsonGenerator.writeValue(outputKeysListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (playlist.getHlsContentProtection() != null) {
                jsonGenerator.writeFieldName("HlsContentProtection");
                HlsContentProtectionJsonMarshaller.getInstance().marshall(playlist.getHlsContentProtection(), jsonGenerator);
            }
            if (playlist.getPlayReadyDrm() != null) {
                jsonGenerator.writeFieldName("PlayReadyDrm");
                PlayReadyDrmJsonMarshaller.getInstance().marshall(playlist.getPlayReadyDrm(), jsonGenerator);
            }
            if (playlist.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(playlist.getStatus());
            }
            if (playlist.getStatusDetail() != null) {
                jsonGenerator.writeFieldName("StatusDetail").writeValue(playlist.getStatusDetail());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PlaylistJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PlaylistJsonMarshaller();
        }
        return instance;
    }
}

