/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest;
import com.amazonaws.services.elasticsearch.model.transform.EBSOptionsJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.ElasticsearchClusterConfigJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.SnapshotOptionsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class UpdateElasticsearchDomainConfigRequestMarshaller
implements Marshaller<Request<UpdateElasticsearchDomainConfigRequest>, UpdateElasticsearchDomainConfigRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<UpdateElasticsearchDomainConfigRequest> marshall(UpdateElasticsearchDomainConfigRequest updateElasticsearchDomainConfigRequest) {
        if (updateElasticsearchDomainConfigRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateElasticsearchDomainConfigRequest, "AWSElasticsearch");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-01-01/es/domain/{DomainName}/config";
        uriResourcePath = uriResourcePath.replace("{DomainName}", updateElasticsearchDomainConfigRequest.getDomainName() != null ? StringUtils.fromString((String)updateElasticsearchDomainConfigRequest.getDomainName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> advancedOptionsMap;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (updateElasticsearchDomainConfigRequest.getElasticsearchClusterConfig() != null) {
                jsonGenerator.writeFieldName("ElasticsearchClusterConfig");
                ElasticsearchClusterConfigJsonMarshaller.getInstance().marshall(updateElasticsearchDomainConfigRequest.getElasticsearchClusterConfig(), jsonGenerator);
            }
            if (updateElasticsearchDomainConfigRequest.getEBSOptions() != null) {
                jsonGenerator.writeFieldName("EBSOptions");
                EBSOptionsJsonMarshaller.getInstance().marshall(updateElasticsearchDomainConfigRequest.getEBSOptions(), jsonGenerator);
            }
            if (updateElasticsearchDomainConfigRequest.getSnapshotOptions() != null) {
                jsonGenerator.writeFieldName("SnapshotOptions");
                SnapshotOptionsJsonMarshaller.getInstance().marshall(updateElasticsearchDomainConfigRequest.getSnapshotOptions(), jsonGenerator);
            }
            if ((advancedOptionsMap = updateElasticsearchDomainConfigRequest.getAdvancedOptions()) != null) {
                jsonGenerator.writeFieldName("AdvancedOptions");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> advancedOptionsMapValue : advancedOptionsMap.entrySet()) {
                    if (advancedOptionsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(advancedOptionsMapValue.getKey());
                    jsonGenerator.writeValue(advancedOptionsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (updateElasticsearchDomainConfigRequest.getAccessPolicies() != null) {
                jsonGenerator.writeFieldName("AccessPolicies").writeValue(updateElasticsearchDomainConfigRequest.getAccessPolicies());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

