/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.Action;
import com.amazonaws.services.elasticloadbalancingv2.model.Certificate;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateListenerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateListenerRequestMarshaller
implements Marshaller<Request<CreateListenerRequest>, CreateListenerRequest> {
    public Request<CreateListenerRequest> marshall(CreateListenerRequest createListenerRequest) {
        List<Action> defaultActionsList;
        List<Certificate> certificatesList;
        if (createListenerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createListenerRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateListener");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createListenerRequest.getLoadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString((String)createListenerRequest.getLoadBalancerArn()));
        }
        if (createListenerRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)createListenerRequest.getProtocol()));
        }
        if (createListenerRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createListenerRequest.getPort()));
        }
        if (createListenerRequest.getSslPolicy() != null) {
            request.addParameter("SslPolicy", StringUtils.fromString((String)createListenerRequest.getSslPolicy()));
        }
        if ((certificatesList = createListenerRequest.getCertificates()) != null) {
            if (certificatesList.isEmpty()) {
                request.addParameter("Certificates", "");
            } else {
                int certificatesListIndex = 1;
                for (Certificate certificatesListValue : certificatesList) {
                    if (certificatesListValue.getCertificateArn() != null) {
                        request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringUtils.fromString((String)certificatesListValue.getCertificateArn()));
                    }
                    ++certificatesListIndex;
                }
            }
        }
        if ((defaultActionsList = createListenerRequest.getDefaultActions()) != null) {
            if (defaultActionsList.isEmpty()) {
                request.addParameter("DefaultActions", "");
            } else {
                int defaultActionsListIndex = 1;
                for (Action defaultActionsListValue : defaultActionsList) {
                    if (defaultActionsListValue.getType() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".Type", StringUtils.fromString((String)defaultActionsListValue.getType()));
                    }
                    if (defaultActionsListValue.getTargetGroupArn() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".TargetGroupArn", StringUtils.fromString((String)defaultActionsListValue.getTargetGroupArn()));
                    }
                    ++defaultActionsListIndex;
                }
            }
        }
        return request;
    }
}

