/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.Action;
import com.amazonaws.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.Certificate;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateListenerRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.FixedResponseActionConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.RedirectActionConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;
import java.util.Map;

public class CreateListenerRequestMarshaller
implements Marshaller<Request<CreateListenerRequest>, CreateListenerRequest> {
    public Request<CreateListenerRequest> marshall(CreateListenerRequest createListenerRequest) {
        if (createListenerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createListenerRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateListener");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createListenerRequest.getLoadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString((String)createListenerRequest.getLoadBalancerArn()));
        }
        if (createListenerRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)createListenerRequest.getProtocol()));
        }
        if (createListenerRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createListenerRequest.getPort()));
        }
        if (createListenerRequest.getSslPolicy() != null) {
            request.addParameter("SslPolicy", StringUtils.fromString((String)createListenerRequest.getSslPolicy()));
        }
        if (createListenerRequest.getCertificates() != null) {
            List<Certificate> certificatesList = createListenerRequest.getCertificates();
            if (certificatesList.isEmpty()) {
                request.addParameter("Certificates", "");
            } else {
                int certificatesListIndex = 1;
                for (Certificate certificatesListValue : certificatesList) {
                    if (certificatesListValue.getCertificateArn() != null) {
                        request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringUtils.fromString((String)certificatesListValue.getCertificateArn()));
                    }
                    if (certificatesListValue.getIsDefault() != null) {
                        request.addParameter("Certificates.member." + certificatesListIndex + ".IsDefault", StringUtils.fromBoolean((Boolean)certificatesListValue.getIsDefault()));
                    }
                    ++certificatesListIndex;
                }
            }
        }
        if (createListenerRequest.getDefaultActions() != null) {
            List<Action> defaultActionsList = createListenerRequest.getDefaultActions();
            if (defaultActionsList.isEmpty()) {
                request.addParameter("DefaultActions", "");
            } else {
                int defaultActionsListIndex = 1;
                for (Action defaultActionsListValue : defaultActionsList) {
                    FixedResponseActionConfig fixedResponseConfig;
                    RedirectActionConfig redirectConfig;
                    AuthenticateCognitoActionConfig authenticateCognitoConfig;
                    AuthenticateOidcActionConfig authenticateOidcConfig;
                    if (defaultActionsListValue.getType() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".Type", StringUtils.fromString((String)defaultActionsListValue.getType()));
                    }
                    if (defaultActionsListValue.getTargetGroupArn() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".TargetGroupArn", StringUtils.fromString((String)defaultActionsListValue.getTargetGroupArn()));
                    }
                    if ((authenticateOidcConfig = defaultActionsListValue.getAuthenticateOidcConfig()) != null) {
                        Map<String, String> authenticationRequestExtraParams;
                        if (authenticateOidcConfig.getIssuer() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.Issuer", StringUtils.fromString((String)authenticateOidcConfig.getIssuer()));
                        }
                        if (authenticateOidcConfig.getAuthorizationEndpoint() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.AuthorizationEndpoint", StringUtils.fromString((String)authenticateOidcConfig.getAuthorizationEndpoint()));
                        }
                        if (authenticateOidcConfig.getTokenEndpoint() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.TokenEndpoint", StringUtils.fromString((String)authenticateOidcConfig.getTokenEndpoint()));
                        }
                        if (authenticateOidcConfig.getUserInfoEndpoint() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.UserInfoEndpoint", StringUtils.fromString((String)authenticateOidcConfig.getUserInfoEndpoint()));
                        }
                        if (authenticateOidcConfig.getClientId() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.ClientId", StringUtils.fromString((String)authenticateOidcConfig.getClientId()));
                        }
                        if (authenticateOidcConfig.getClientSecret() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.ClientSecret", StringUtils.fromString((String)authenticateOidcConfig.getClientSecret()));
                        }
                        if (authenticateOidcConfig.getSessionCookieName() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.SessionCookieName", StringUtils.fromString((String)authenticateOidcConfig.getSessionCookieName()));
                        }
                        if (authenticateOidcConfig.getScope() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.Scope", StringUtils.fromString((String)authenticateOidcConfig.getScope()));
                        }
                        if (authenticateOidcConfig.getSessionTimeout() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.SessionTimeout", StringUtils.fromLong((Long)authenticateOidcConfig.getSessionTimeout()));
                        }
                        if ((authenticationRequestExtraParams = authenticateOidcConfig.getAuthenticationRequestExtraParams()) != null) {
                            int authenticationRequestExtraParamsListIndex = 1;
                            for (Map.Entry<String, String> entry : authenticationRequestExtraParams.entrySet()) {
                                if (entry.getKey() != null) {
                                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".key", StringUtils.fromString((String)entry.getKey()));
                                }
                                if (entry.getValue() != null) {
                                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".value", StringUtils.fromString((String)entry.getValue()));
                                }
                                ++authenticationRequestExtraParamsListIndex;
                            }
                        }
                        if (authenticateOidcConfig.getOnUnauthenticatedRequest() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.OnUnauthenticatedRequest", StringUtils.fromString((String)authenticateOidcConfig.getOnUnauthenticatedRequest()));
                        }
                    }
                    if ((authenticateCognitoConfig = defaultActionsListValue.getAuthenticateCognitoConfig()) != null) {
                        Map<String, String> authenticationRequestExtraParams;
                        if (authenticateCognitoConfig.getUserPoolArn() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.UserPoolArn", StringUtils.fromString((String)authenticateCognitoConfig.getUserPoolArn()));
                        }
                        if (authenticateCognitoConfig.getUserPoolClientId() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.UserPoolClientId", StringUtils.fromString((String)authenticateCognitoConfig.getUserPoolClientId()));
                        }
                        if (authenticateCognitoConfig.getUserPoolDomain() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.UserPoolDomain", StringUtils.fromString((String)authenticateCognitoConfig.getUserPoolDomain()));
                        }
                        if (authenticateCognitoConfig.getSessionCookieName() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.SessionCookieName", StringUtils.fromString((String)authenticateCognitoConfig.getSessionCookieName()));
                        }
                        if (authenticateCognitoConfig.getScope() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.Scope", StringUtils.fromString((String)authenticateCognitoConfig.getScope()));
                        }
                        if (authenticateCognitoConfig.getSessionTimeout() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.SessionTimeout", StringUtils.fromLong((Long)authenticateCognitoConfig.getSessionTimeout()));
                        }
                        if ((authenticationRequestExtraParams = authenticateCognitoConfig.getAuthenticationRequestExtraParams()) != null) {
                            int authenticationRequestExtraParamsListIndex = 1;
                            for (Map.Entry<String, String> entry : authenticationRequestExtraParams.entrySet()) {
                                if (entry.getKey() != null) {
                                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".key", StringUtils.fromString((String)entry.getKey()));
                                }
                                if (entry.getValue() != null) {
                                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".value", StringUtils.fromString((String)entry.getValue()));
                                }
                                ++authenticationRequestExtraParamsListIndex;
                            }
                        }
                        if (authenticateCognitoConfig.getOnUnauthenticatedRequest() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.OnUnauthenticatedRequest", StringUtils.fromString((String)authenticateCognitoConfig.getOnUnauthenticatedRequest()));
                        }
                    }
                    if (defaultActionsListValue.getOrder() != null) {
                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".Order", StringUtils.fromInteger((Integer)defaultActionsListValue.getOrder()));
                    }
                    if ((redirectConfig = defaultActionsListValue.getRedirectConfig()) != null) {
                        if (redirectConfig.getProtocol() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Protocol", StringUtils.fromString((String)redirectConfig.getProtocol()));
                        }
                        if (redirectConfig.getPort() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Port", StringUtils.fromString((String)redirectConfig.getPort()));
                        }
                        if (redirectConfig.getHost() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Host", StringUtils.fromString((String)redirectConfig.getHost()));
                        }
                        if (redirectConfig.getPath() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Path", StringUtils.fromString((String)redirectConfig.getPath()));
                        }
                        if (redirectConfig.getQuery() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Query", StringUtils.fromString((String)redirectConfig.getQuery()));
                        }
                        if (redirectConfig.getStatusCode() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.StatusCode", StringUtils.fromString((String)redirectConfig.getStatusCode()));
                        }
                    }
                    if ((fixedResponseConfig = defaultActionsListValue.getFixedResponseConfig()) != null) {
                        if (fixedResponseConfig.getMessageBody() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".FixedResponseConfig.MessageBody", StringUtils.fromString((String)fixedResponseConfig.getMessageBody()));
                        }
                        if (fixedResponseConfig.getStatusCode() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".FixedResponseConfig.StatusCode", StringUtils.fromString((String)fixedResponseConfig.getStatusCode()));
                        }
                        if (fixedResponseConfig.getContentType() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".FixedResponseConfig.ContentType", StringUtils.fromString((String)fixedResponseConfig.getContentType()));
                        }
                    }
                    ++defaultActionsListIndex;
                }
            }
        }
        return request;
    }
}

