/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.services.elasticloadbalancing.model.AdditionalAttribute;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class AdditionalAttributeStaxUnmarshaller
implements Unmarshaller<AdditionalAttribute, StaxUnmarshallerContext> {
    private static AdditionalAttributeStaxUnmarshaller instance;

    public AdditionalAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        AdditionalAttribute additionalAttribute = new AdditionalAttribute();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return additionalAttribute;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Key", targetDepth)) {
                    additionalAttribute.setKey(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Value", targetDepth)) continue;
                additionalAttribute.setValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return additionalAttribute;
    }

    public static AdditionalAttributeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AdditionalAttributeStaxUnmarshaller();
        }
        return instance;
    }
}

