
/**
 * Synchronous and asynchronous client classes for accessing AmazonElasticLoadBalancing.
 *
 * Elastic Load Balancing <p>
 * Elastic Load Balancing automatically distributes incoming web traffic
 * across multiple Amazon EC2 instances.
 * </p>
 * <p>
 * All Elastic Load Balancing actions and commands are <i>idempotent</i>
 * , which means that they complete no more than one time. If you repeat
 * a request or a command, the action succeeds with a 200 OK response
 * code.
 * </p>
 * <p>
 * For detailed information about the features of Elastic Load Balancing,
 * see
 * <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/UserScenarios.html"> Managing Load Balancers </a>
 * in the <i>Elastic Load Balancing Developer Guide</i> .
 * </p>
 */
 package com.amazonaws.services.elasticloadbalancing;
        