/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.CustomAmi;
import com.amazonaws.services.elasticbeanstalk.model.PlatformDescription;
import com.amazonaws.services.elasticbeanstalk.model.PlatformFramework;
import com.amazonaws.services.elasticbeanstalk.model.PlatformProgrammingLanguage;
import com.amazonaws.services.elasticbeanstalk.model.transform.CustomAmiStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.PlatformFrameworkStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.PlatformProgrammingLanguageStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class PlatformDescriptionStaxUnmarshaller
implements Unmarshaller<PlatformDescription, StaxUnmarshallerContext> {
    private static PlatformDescriptionStaxUnmarshaller instance;

    public PlatformDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        PlatformDescription platformDescription = new PlatformDescription();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return platformDescription;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("PlatformArn", targetDepth)) {
                    platformDescription.setPlatformArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformOwner", targetDepth)) {
                    platformDescription.setPlatformOwner(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformName", targetDepth)) {
                    platformDescription.setPlatformName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformVersion", targetDepth)) {
                    platformDescription.setPlatformVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SolutionStackName", targetDepth)) {
                    platformDescription.setSolutionStackName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformStatus", targetDepth)) {
                    platformDescription.setPlatformStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DateCreated", targetDepth)) {
                    platformDescription.setDateCreated(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("DateUpdated", targetDepth)) {
                    platformDescription.setDateUpdated(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformCategory", targetDepth)) {
                    platformDescription.setPlatformCategory(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    platformDescription.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Maintainer", targetDepth)) {
                    platformDescription.setMaintainer(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OperatingSystemName", targetDepth)) {
                    platformDescription.setOperatingSystemName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OperatingSystemVersion", targetDepth)) {
                    platformDescription.setOperatingSystemVersion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ProgrammingLanguages", targetDepth)) {
                    platformDescription.withProgrammingLanguages(new ArrayList<PlatformProgrammingLanguage>());
                    continue;
                }
                if (context.testExpression("ProgrammingLanguages/member", targetDepth)) {
                    platformDescription.withProgrammingLanguages(PlatformProgrammingLanguageStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Frameworks", targetDepth)) {
                    platformDescription.withFrameworks(new ArrayList<PlatformFramework>());
                    continue;
                }
                if (context.testExpression("Frameworks/member", targetDepth)) {
                    platformDescription.withFrameworks(PlatformFrameworkStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CustomAmiList", targetDepth)) {
                    platformDescription.withCustomAmiList(new ArrayList<CustomAmi>());
                    continue;
                }
                if (context.testExpression("CustomAmiList/member", targetDepth)) {
                    platformDescription.withCustomAmiList(CustomAmiStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedTierList", targetDepth)) {
                    platformDescription.withSupportedTierList(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("SupportedTierList/member", targetDepth)) {
                    platformDescription.withSupportedTierList(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedAddonList", targetDepth)) {
                    platformDescription.withSupportedAddonList(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("SupportedAddonList/member", targetDepth)) continue;
                platformDescription.withSupportedAddonList(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return platformDescription;
    }

    public static PlatformDescriptionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PlatformDescriptionStaxUnmarshaller();
        }
        return instance;
    }
}

