/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.AuthenticationMode;
import com.amazonaws.services.elasticache.model.ModifyUserRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyUserRequestMarshaller
implements Marshaller<Request<ModifyUserRequest>, ModifyUserRequest> {
    public Request<ModifyUserRequest> marshall(ModifyUserRequest modifyUserRequest) {
        AuthenticationMode authenticationMode;
        if (modifyUserRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyUserRequest, "AmazonElastiCache");
        request.addParameter("Action", "ModifyUser");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyUserRequest.getUserId() != null) {
            request.addParameter("UserId", StringUtils.fromString((String)modifyUserRequest.getUserId()));
        }
        if (modifyUserRequest.getAccessString() != null) {
            request.addParameter("AccessString", StringUtils.fromString((String)modifyUserRequest.getAccessString()));
        }
        if (modifyUserRequest.getAppendAccessString() != null) {
            request.addParameter("AppendAccessString", StringUtils.fromString((String)modifyUserRequest.getAppendAccessString()));
        }
        if (!modifyUserRequest.getPasswords().isEmpty() || !((SdkInternalList)modifyUserRequest.getPasswords()).isAutoConstruct()) {
            SdkInternalList passwordsList = (SdkInternalList)modifyUserRequest.getPasswords();
            int passwordsListIndex = 1;
            for (String passwordsListValue : passwordsList) {
                if (passwordsListValue != null) {
                    request.addParameter("Passwords.member." + passwordsListIndex, StringUtils.fromString((String)passwordsListValue));
                }
                ++passwordsListIndex;
            }
        }
        if (modifyUserRequest.getNoPasswordRequired() != null) {
            request.addParameter("NoPasswordRequired", StringUtils.fromBoolean((Boolean)modifyUserRequest.getNoPasswordRequired()));
        }
        if ((authenticationMode = modifyUserRequest.getAuthenticationMode()) != null) {
            if (authenticationMode.getType() != null) {
                request.addParameter("AuthenticationMode.Type", StringUtils.fromString((String)authenticationMode.getType()));
            }
            if (!authenticationMode.getPasswords().isEmpty() || !((SdkInternalList)authenticationMode.getPasswords()).isAutoConstruct()) {
                SdkInternalList passwordsList = (SdkInternalList)authenticationMode.getPasswords();
                int passwordsListIndex = 1;
                for (String passwordsListValue : passwordsList) {
                    if (passwordsListValue != null) {
                        request.addParameter("AuthenticationMode.Passwords.member." + passwordsListIndex, StringUtils.fromString((String)passwordsListValue));
                    }
                    ++passwordsListIndex;
                }
            }
        }
        return request;
    }
}

