/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest;
import com.amazonaws.services.elasticache.model.NodeGroupConfiguration;
import com.amazonaws.services.elasticache.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateReplicationGroupRequestMarshaller
implements Marshaller<Request<CreateReplicationGroupRequest>, CreateReplicationGroupRequest> {
    public Request<CreateReplicationGroupRequest> marshall(CreateReplicationGroupRequest createReplicationGroupRequest) {
        if (createReplicationGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReplicationGroupRequest, "AmazonElastiCache");
        request.addParameter("Action", "CreateReplicationGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createReplicationGroupRequest.getReplicationGroupId() != null) {
            request.addParameter("ReplicationGroupId", StringUtils.fromString((String)createReplicationGroupRequest.getReplicationGroupId()));
        }
        if (createReplicationGroupRequest.getReplicationGroupDescription() != null) {
            request.addParameter("ReplicationGroupDescription", StringUtils.fromString((String)createReplicationGroupRequest.getReplicationGroupDescription()));
        }
        if (createReplicationGroupRequest.getGlobalReplicationGroupId() != null) {
            request.addParameter("GlobalReplicationGroupId", StringUtils.fromString((String)createReplicationGroupRequest.getGlobalReplicationGroupId()));
        }
        if (createReplicationGroupRequest.getPrimaryClusterId() != null) {
            request.addParameter("PrimaryClusterId", StringUtils.fromString((String)createReplicationGroupRequest.getPrimaryClusterId()));
        }
        if (createReplicationGroupRequest.getAutomaticFailoverEnabled() != null) {
            request.addParameter("AutomaticFailoverEnabled", StringUtils.fromBoolean((Boolean)createReplicationGroupRequest.getAutomaticFailoverEnabled()));
        }
        if (createReplicationGroupRequest.getNumCacheClusters() != null) {
            request.addParameter("NumCacheClusters", StringUtils.fromInteger((Integer)createReplicationGroupRequest.getNumCacheClusters()));
        }
        if (!createReplicationGroupRequest.getPreferredCacheClusterAZs().isEmpty() || !((SdkInternalList)createReplicationGroupRequest.getPreferredCacheClusterAZs()).isAutoConstruct()) {
            SdkInternalList preferredCacheClusterAZsList = (SdkInternalList)createReplicationGroupRequest.getPreferredCacheClusterAZs();
            int preferredCacheClusterAZsListIndex = 1;
            for (String preferredCacheClusterAZsListValue : preferredCacheClusterAZsList) {
                if (preferredCacheClusterAZsListValue != null) {
                    request.addParameter("PreferredCacheClusterAZs.AvailabilityZone." + preferredCacheClusterAZsListIndex, StringUtils.fromString((String)preferredCacheClusterAZsListValue));
                }
                ++preferredCacheClusterAZsListIndex;
            }
        }
        if (createReplicationGroupRequest.getNumNodeGroups() != null) {
            request.addParameter("NumNodeGroups", StringUtils.fromInteger((Integer)createReplicationGroupRequest.getNumNodeGroups()));
        }
        if (createReplicationGroupRequest.getReplicasPerNodeGroup() != null) {
            request.addParameter("ReplicasPerNodeGroup", StringUtils.fromInteger((Integer)createReplicationGroupRequest.getReplicasPerNodeGroup()));
        }
        if (!createReplicationGroupRequest.getNodeGroupConfiguration().isEmpty() || !((SdkInternalList)createReplicationGroupRequest.getNodeGroupConfiguration()).isAutoConstruct()) {
            SdkInternalList nodeGroupConfigurationList = (SdkInternalList)createReplicationGroupRequest.getNodeGroupConfiguration();
            int nodeGroupConfigurationListIndex = 1;
            for (NodeGroupConfiguration nodeGroupConfigurationListValue : nodeGroupConfigurationList) {
                if (nodeGroupConfigurationListValue.getNodeGroupId() != null) {
                    request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".NodeGroupId", StringUtils.fromString((String)nodeGroupConfigurationListValue.getNodeGroupId()));
                }
                if (nodeGroupConfigurationListValue.getSlots() != null) {
                    request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".Slots", StringUtils.fromString((String)nodeGroupConfigurationListValue.getSlots()));
                }
                if (nodeGroupConfigurationListValue.getReplicaCount() != null) {
                    request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".ReplicaCount", StringUtils.fromInteger((Integer)nodeGroupConfigurationListValue.getReplicaCount()));
                }
                if (nodeGroupConfigurationListValue.getPrimaryAvailabilityZone() != null) {
                    request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".PrimaryAvailabilityZone", StringUtils.fromString((String)nodeGroupConfigurationListValue.getPrimaryAvailabilityZone()));
                }
                if (!nodeGroupConfigurationListValue.getReplicaAvailabilityZones().isEmpty() || !((SdkInternalList)nodeGroupConfigurationListValue.getReplicaAvailabilityZones()).isAutoConstruct()) {
                    SdkInternalList replicaAvailabilityZonesList = (SdkInternalList)nodeGroupConfigurationListValue.getReplicaAvailabilityZones();
                    int replicaAvailabilityZonesListIndex = 1;
                    for (String replicaAvailabilityZonesListValue : replicaAvailabilityZonesList) {
                        if (replicaAvailabilityZonesListValue != null) {
                            request.addParameter("NodeGroupConfiguration.NodeGroupConfiguration." + nodeGroupConfigurationListIndex + ".ReplicaAvailabilityZones.AvailabilityZone." + replicaAvailabilityZonesListIndex, StringUtils.fromString((String)replicaAvailabilityZonesListValue));
                        }
                        ++replicaAvailabilityZonesListIndex;
                    }
                }
                ++nodeGroupConfigurationListIndex;
            }
        }
        if (createReplicationGroupRequest.getCacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringUtils.fromString((String)createReplicationGroupRequest.getCacheNodeType()));
        }
        if (createReplicationGroupRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)createReplicationGroupRequest.getEngine()));
        }
        if (createReplicationGroupRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)createReplicationGroupRequest.getEngineVersion()));
        }
        if (createReplicationGroupRequest.getCacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)createReplicationGroupRequest.getCacheParameterGroupName()));
        }
        if (createReplicationGroupRequest.getCacheSubnetGroupName() != null) {
            request.addParameter("CacheSubnetGroupName", StringUtils.fromString((String)createReplicationGroupRequest.getCacheSubnetGroupName()));
        }
        if (!createReplicationGroupRequest.getCacheSecurityGroupNames().isEmpty() || !((SdkInternalList)createReplicationGroupRequest.getCacheSecurityGroupNames()).isAutoConstruct()) {
            SdkInternalList cacheSecurityGroupNamesList = (SdkInternalList)createReplicationGroupRequest.getCacheSecurityGroupNames();
            int cacheSecurityGroupNamesListIndex = 1;
            for (String cacheSecurityGroupNamesListValue : cacheSecurityGroupNamesList) {
                if (cacheSecurityGroupNamesListValue != null) {
                    request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + cacheSecurityGroupNamesListIndex, StringUtils.fromString((String)cacheSecurityGroupNamesListValue));
                }
                ++cacheSecurityGroupNamesListIndex;
            }
        }
        if (!createReplicationGroupRequest.getSecurityGroupIds().isEmpty() || !((SdkInternalList)createReplicationGroupRequest.getSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList securityGroupIdsList = (SdkInternalList)createReplicationGroupRequest.getSecurityGroupIds();
            int securityGroupIdsListIndex = 1;
            for (String securityGroupIdsListValue : securityGroupIdsList) {
                if (securityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupIds.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)securityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (!createReplicationGroupRequest.getTags().isEmpty() || !((SdkInternalList)createReplicationGroupRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createReplicationGroupRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        if (!createReplicationGroupRequest.getSnapshotArns().isEmpty() || !((SdkInternalList)createReplicationGroupRequest.getSnapshotArns()).isAutoConstruct()) {
            SdkInternalList snapshotArnsList = (SdkInternalList)createReplicationGroupRequest.getSnapshotArns();
            int snapshotArnsListIndex = 1;
            for (String snapshotArnsListValue : snapshotArnsList) {
                if (snapshotArnsListValue != null) {
                    request.addParameter("SnapshotArns.SnapshotArn." + snapshotArnsListIndex, StringUtils.fromString((String)snapshotArnsListValue));
                }
                ++snapshotArnsListIndex;
            }
        }
        if (createReplicationGroupRequest.getSnapshotName() != null) {
            request.addParameter("SnapshotName", StringUtils.fromString((String)createReplicationGroupRequest.getSnapshotName()));
        }
        if (createReplicationGroupRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)createReplicationGroupRequest.getPreferredMaintenanceWindow()));
        }
        if (createReplicationGroupRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createReplicationGroupRequest.getPort()));
        }
        if (createReplicationGroupRequest.getNotificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringUtils.fromString((String)createReplicationGroupRequest.getNotificationTopicArn()));
        }
        if (createReplicationGroupRequest.getAutoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)createReplicationGroupRequest.getAutoMinorVersionUpgrade()));
        }
        if (createReplicationGroupRequest.getSnapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringUtils.fromInteger((Integer)createReplicationGroupRequest.getSnapshotRetentionLimit()));
        }
        if (createReplicationGroupRequest.getSnapshotWindow() != null) {
            request.addParameter("SnapshotWindow", StringUtils.fromString((String)createReplicationGroupRequest.getSnapshotWindow()));
        }
        if (createReplicationGroupRequest.getAuthToken() != null) {
            request.addParameter("AuthToken", StringUtils.fromString((String)createReplicationGroupRequest.getAuthToken()));
        }
        if (createReplicationGroupRequest.getTransitEncryptionEnabled() != null) {
            request.addParameter("TransitEncryptionEnabled", StringUtils.fromBoolean((Boolean)createReplicationGroupRequest.getTransitEncryptionEnabled()));
        }
        if (createReplicationGroupRequest.getAtRestEncryptionEnabled() != null) {
            request.addParameter("AtRestEncryptionEnabled", StringUtils.fromBoolean((Boolean)createReplicationGroupRequest.getAtRestEncryptionEnabled()));
        }
        if (createReplicationGroupRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createReplicationGroupRequest.getKmsKeyId()));
        }
        return request;
    }
}

