/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.eks.model.InsightSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListInsightsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<InsightSummary> insights;
    private String nextToken;

    public List<InsightSummary> getInsights() {
        return this.insights;
    }

    public void setInsights(Collection<InsightSummary> insights) {
        if (insights == null) {
            this.insights = null;
            return;
        }
        this.insights = new ArrayList<InsightSummary>(insights);
    }

    public ListInsightsResult withInsights(InsightSummary ... insights) {
        if (this.insights == null) {
            this.setInsights(new ArrayList<InsightSummary>(insights.length));
        }
        for (InsightSummary ele : insights) {
            this.insights.add(ele);
        }
        return this;
    }

    public ListInsightsResult withInsights(Collection<InsightSummary> insights) {
        this.setInsights(insights);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListInsightsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInsights() != null) {
            sb.append("Insights: ").append(this.getInsights()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInsightsResult)) {
            return false;
        }
        ListInsightsResult other = (ListInsightsResult)obj;
        if (other.getInsights() == null ^ this.getInsights() == null) {
            return false;
        }
        if (other.getInsights() != null && !other.getInsights().equals(this.getInsights())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInsights() == null ? 0 : this.getInsights().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListInsightsResult clone() {
        try {
            return (ListInsightsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

