/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.Category;
import com.amazonaws.services.eks.model.InsightStatusValue;
import com.amazonaws.services.eks.model.transform.InsightsFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InsightsFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> categories;
    private List<String> kubernetesVersions;
    private List<String> statuses;

    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(Collection<String> categories) {
        if (categories == null) {
            this.categories = null;
            return;
        }
        this.categories = new ArrayList<String>(categories);
    }

    public InsightsFilter withCategories(String ... categories) {
        if (this.categories == null) {
            this.setCategories(new ArrayList<String>(categories.length));
        }
        for (String ele : categories) {
            this.categories.add(ele);
        }
        return this;
    }

    public InsightsFilter withCategories(Collection<String> categories) {
        this.setCategories(categories);
        return this;
    }

    public InsightsFilter withCategories(Category ... categories) {
        ArrayList<String> categoriesCopy = new ArrayList<String>(categories.length);
        for (Category value : categories) {
            categoriesCopy.add(value.toString());
        }
        if (this.getCategories() == null) {
            this.setCategories(categoriesCopy);
        } else {
            this.getCategories().addAll(categoriesCopy);
        }
        return this;
    }

    public List<String> getKubernetesVersions() {
        return this.kubernetesVersions;
    }

    public void setKubernetesVersions(Collection<String> kubernetesVersions) {
        if (kubernetesVersions == null) {
            this.kubernetesVersions = null;
            return;
        }
        this.kubernetesVersions = new ArrayList<String>(kubernetesVersions);
    }

    public InsightsFilter withKubernetesVersions(String ... kubernetesVersions) {
        if (this.kubernetesVersions == null) {
            this.setKubernetesVersions(new ArrayList<String>(kubernetesVersions.length));
        }
        for (String ele : kubernetesVersions) {
            this.kubernetesVersions.add(ele);
        }
        return this;
    }

    public InsightsFilter withKubernetesVersions(Collection<String> kubernetesVersions) {
        this.setKubernetesVersions(kubernetesVersions);
        return this;
    }

    public List<String> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(Collection<String> statuses) {
        if (statuses == null) {
            this.statuses = null;
            return;
        }
        this.statuses = new ArrayList<String>(statuses);
    }

    public InsightsFilter withStatuses(String ... statuses) {
        if (this.statuses == null) {
            this.setStatuses(new ArrayList<String>(statuses.length));
        }
        for (String ele : statuses) {
            this.statuses.add(ele);
        }
        return this;
    }

    public InsightsFilter withStatuses(Collection<String> statuses) {
        this.setStatuses(statuses);
        return this;
    }

    public InsightsFilter withStatuses(InsightStatusValue ... statuses) {
        ArrayList<String> statusesCopy = new ArrayList<String>(statuses.length);
        for (InsightStatusValue value : statuses) {
            statusesCopy.add(value.toString());
        }
        if (this.getStatuses() == null) {
            this.setStatuses(statusesCopy);
        } else {
            this.getStatuses().addAll(statusesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCategories() != null) {
            sb.append("Categories: ").append(this.getCategories()).append(",");
        }
        if (this.getKubernetesVersions() != null) {
            sb.append("KubernetesVersions: ").append(this.getKubernetesVersions()).append(",");
        }
        if (this.getStatuses() != null) {
            sb.append("Statuses: ").append(this.getStatuses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightsFilter)) {
            return false;
        }
        InsightsFilter other = (InsightsFilter)obj;
        if (other.getCategories() == null ^ this.getCategories() == null) {
            return false;
        }
        if (other.getCategories() != null && !other.getCategories().equals(this.getCategories())) {
            return false;
        }
        if (other.getKubernetesVersions() == null ^ this.getKubernetesVersions() == null) {
            return false;
        }
        if (other.getKubernetesVersions() != null && !other.getKubernetesVersions().equals(this.getKubernetesVersions())) {
            return false;
        }
        if (other.getStatuses() == null ^ this.getStatuses() == null) {
            return false;
        }
        return other.getStatuses() == null || other.getStatuses().equals(this.getStatuses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCategories() == null ? 0 : this.getCategories().hashCode());
        hashCode = 31 * hashCode + (this.getKubernetesVersions() == null ? 0 : this.getKubernetesVersions().hashCode());
        hashCode = 31 * hashCode + (this.getStatuses() == null ? 0 : this.getStatuses().hashCode());
        return hashCode;
    }

    public InsightsFilter clone() {
        try {
            return (InsightsFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InsightsFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

