/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.eks.model.LaunchTemplateSpecification;

@SdkInternalApi
public class LaunchTemplateSpecificationMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final LaunchTemplateSpecificationMarshaller instance = new LaunchTemplateSpecificationMarshaller();

    public static LaunchTemplateSpecificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(LaunchTemplateSpecification launchTemplateSpecification, ProtocolMarshaller protocolMarshaller) {
        if (launchTemplateSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)launchTemplateSpecification.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)launchTemplateSpecification.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)launchTemplateSpecification.getId(), ID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

