/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DescribeFileSystemsRequestMarshaller
implements Marshaller<Request<DescribeFileSystemsRequest>, DescribeFileSystemsRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    public Request<DescribeFileSystemsRequest> marshall(DescribeFileSystemsRequest describeFileSystemsRequest) {
        String value;
        String name;
        if (describeFileSystemsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeFileSystemsRequest, "AmazonElasticFileSystem");
        String target = "MagnolioAPIService_v20150201.DescribeFileSystems";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("MaxItems")) {
            name = DYNAMIC_QUERY_PARAMS.get("MaxItems");
            String string = value = describeFileSystemsRequest.getMaxItems() == null ? null : StringUtils.fromInteger((Integer)describeFileSystemsRequest.getMaxItems());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{MaxItems}", describeFileSystemsRequest.getMaxItems() == null ? "" : StringUtils.fromInteger((Integer)describeFileSystemsRequest.getMaxItems()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Marker")) {
            name = DYNAMIC_QUERY_PARAMS.get("Marker");
            String string = value = describeFileSystemsRequest.getMarker() == null ? null : StringUtils.fromString((String)describeFileSystemsRequest.getMarker());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Marker}", describeFileSystemsRequest.getMarker() == null ? "" : StringUtils.fromString((String)describeFileSystemsRequest.getMarker()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("CreationToken")) {
            name = DYNAMIC_QUERY_PARAMS.get("CreationToken");
            String string = value = describeFileSystemsRequest.getCreationToken() == null ? null : StringUtils.fromString((String)describeFileSystemsRequest.getCreationToken());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{CreationToken}", describeFileSystemsRequest.getCreationToken() == null ? "" : StringUtils.fromString((String)describeFileSystemsRequest.getCreationToken()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("FileSystemId")) {
            name = DYNAMIC_QUERY_PARAMS.get("FileSystemId");
            String string = value = describeFileSystemsRequest.getFileSystemId() == null ? null : StringUtils.fromString((String)describeFileSystemsRequest.getFileSystemId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{FileSystemId}", describeFileSystemsRequest.getFileSystemId() == null ? "" : StringUtils.fromString((String)describeFileSystemsRequest.getFileSystemId()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }

    static {
        String path = "/2015-02-01/file-systems?MaxItems={MaxItems}&Marker={Marker}&CreationToken={CreationToken}&FileSystemId={FileSystemId}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

