/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticfilesystem.model.FileSystemSize;

public class FileSystemSizeJsonMarshaller {
    private static FileSystemSizeJsonMarshaller instance;

    public void marshall(FileSystemSize fileSystemSize, StructuredJsonGenerator jsonGenerator) {
        if (fileSystemSize == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (fileSystemSize.getValue() != null) {
                jsonGenerator.writeFieldName("Value").writeValue(fileSystemSize.getValue().longValue());
            }
            if (fileSystemSize.getTimestamp() != null) {
                jsonGenerator.writeFieldName("Timestamp").writeValue(fileSystemSize.getTimestamp());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FileSystemSizeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FileSystemSizeJsonMarshaller();
        }
        return instance;
    }
}

