/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.ContainerOverride;
import com.amazonaws.services.ecs.model.StartTaskRequest;
import com.amazonaws.services.ecs.model.TaskOverride;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class StartTaskRequestMarshaller
implements Marshaller<Request<StartTaskRequest>, StartTaskRequest> {
    public Request<StartTaskRequest> marshall(StartTaskRequest startTaskRequest) {
        if (startTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startTaskRequest, "AmazonECS");
        String target = "AmazonEC2ContainerServiceV20141113.StartTask";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag containerInstancesList;
            TaskOverride overrides;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (startTaskRequest.getCluster() != null) {
                jsonWriter.key("cluster").value((Object)startTaskRequest.getCluster());
            }
            if (startTaskRequest.getTaskDefinition() != null) {
                jsonWriter.key("taskDefinition").value((Object)startTaskRequest.getTaskDefinition());
            }
            if ((overrides = startTaskRequest.getOverrides()) != null) {
                jsonWriter.key("overrides");
                jsonWriter.object();
                ListWithAutoConstructFlag containerOverridesList = (ListWithAutoConstructFlag)overrides.getContainerOverrides();
                if (!(containerOverridesList == null || containerOverridesList.isAutoConstruct() && containerOverridesList.isEmpty())) {
                    jsonWriter.key("containerOverrides");
                    jsonWriter.array();
                    for (ContainerOverride containerOverridesListValue : containerOverridesList) {
                        ListWithAutoConstructFlag commandList;
                        if (containerOverridesListValue == null) continue;
                        jsonWriter.object();
                        if (containerOverridesListValue.getName() != null) {
                            jsonWriter.key("name").value((Object)containerOverridesListValue.getName());
                        }
                        if (!((commandList = (ListWithAutoConstructFlag)containerOverridesListValue.getCommand()) == null || commandList.isAutoConstruct() && commandList.isEmpty())) {
                            jsonWriter.key("command");
                            jsonWriter.array();
                            for (String commandListValue : commandList) {
                                if (commandListValue == null) continue;
                                jsonWriter.value((Object)commandListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if (!((containerInstancesList = (ListWithAutoConstructFlag)startTaskRequest.getContainerInstances()) == null || containerInstancesList.isAutoConstruct() && containerInstancesList.isEmpty())) {
                jsonWriter.key("containerInstances");
                jsonWriter.array();
                for (String containerInstancesListValue : containerInstancesList) {
                    if (containerInstancesListValue == null) continue;
                    jsonWriter.value((Object)containerInstancesListValue);
                }
                jsonWriter.endArray();
            }
            if (startTaskRequest.getStartedBy() != null) {
                jsonWriter.key("startedBy").value((Object)startTaskRequest.getStartedBy());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

