/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.NetworkBinding;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SubmitContainerStateChangeRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String cluster;
    private String task;
    private String containerName;
    private String status;
    private Integer exitCode;
    private String reason;
    private ListWithAutoConstructFlag<NetworkBinding> networkBindings;

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public SubmitContainerStateChangeRequest withCluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public SubmitContainerStateChangeRequest withTask(String task) {
        this.task = task;
        return this;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public SubmitContainerStateChangeRequest withContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public SubmitContainerStateChangeRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public SubmitContainerStateChangeRequest withExitCode(Integer exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public SubmitContainerStateChangeRequest withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public List<NetworkBinding> getNetworkBindings() {
        if (this.networkBindings == null) {
            this.networkBindings = new ListWithAutoConstructFlag();
            this.networkBindings.setAutoConstruct(true);
        }
        return this.networkBindings;
    }

    public void setNetworkBindings(Collection<NetworkBinding> networkBindings) {
        if (networkBindings == null) {
            this.networkBindings = null;
            return;
        }
        ListWithAutoConstructFlag networkBindingsCopy = new ListWithAutoConstructFlag(networkBindings.size());
        networkBindingsCopy.addAll(networkBindings);
        this.networkBindings = networkBindingsCopy;
    }

    public SubmitContainerStateChangeRequest withNetworkBindings(NetworkBinding ... networkBindings) {
        if (this.getNetworkBindings() == null) {
            this.setNetworkBindings(new ArrayList<NetworkBinding>(networkBindings.length));
        }
        for (NetworkBinding value : networkBindings) {
            this.getNetworkBindings().add(value);
        }
        return this;
    }

    public SubmitContainerStateChangeRequest withNetworkBindings(Collection<NetworkBinding> networkBindings) {
        if (networkBindings == null) {
            this.networkBindings = null;
        } else {
            ListWithAutoConstructFlag networkBindingsCopy = new ListWithAutoConstructFlag(networkBindings.size());
            networkBindingsCopy.addAll(networkBindings);
            this.networkBindings = networkBindingsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: " + this.getCluster() + ",");
        }
        if (this.getTask() != null) {
            sb.append("Task: " + this.getTask() + ",");
        }
        if (this.getContainerName() != null) {
            sb.append("ContainerName: " + this.getContainerName() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getExitCode() != null) {
            sb.append("ExitCode: " + this.getExitCode() + ",");
        }
        if (this.getReason() != null) {
            sb.append("Reason: " + this.getReason() + ",");
        }
        if (this.getNetworkBindings() != null) {
            sb.append("NetworkBindings: " + this.getNetworkBindings());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getTask() == null ? 0 : this.getTask().hashCode());
        hashCode = 31 * hashCode + (this.getContainerName() == null ? 0 : this.getContainerName().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getExitCode() == null ? 0 : this.getExitCode().hashCode());
        hashCode = 31 * hashCode + (this.getReason() == null ? 0 : this.getReason().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkBindings() == null ? 0 : this.getNetworkBindings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitContainerStateChangeRequest)) {
            return false;
        }
        SubmitContainerStateChangeRequest other = (SubmitContainerStateChangeRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getTask() == null ^ this.getTask() == null) {
            return false;
        }
        if (other.getTask() != null && !other.getTask().equals(this.getTask())) {
            return false;
        }
        if (other.getContainerName() == null ^ this.getContainerName() == null) {
            return false;
        }
        if (other.getContainerName() != null && !other.getContainerName().equals(this.getContainerName())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getExitCode() == null ^ this.getExitCode() == null) {
            return false;
        }
        if (other.getExitCode() != null && !other.getExitCode().equals(this.getExitCode())) {
            return false;
        }
        if (other.getReason() == null ^ this.getReason() == null) {
            return false;
        }
        if (other.getReason() != null && !other.getReason().equals(this.getReason())) {
            return false;
        }
        if (other.getNetworkBindings() == null ^ this.getNetworkBindings() == null) {
            return false;
        }
        return other.getNetworkBindings() == null || other.getNetworkBindings().equals(this.getNetworkBindings());
    }
}

