/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Resource
implements Serializable {
    private String name;
    private String type;
    private Double doubleValue;
    private Long longValue;
    private Integer integerValue;
    private ListWithAutoConstructFlag<String> stringSetValue;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Resource withName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Resource withType(String type) {
        this.type = type;
        return this;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public Resource withDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
        return this;
    }

    public Long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    public Resource withLongValue(Long longValue) {
        this.longValue = longValue;
        return this;
    }

    public Integer getIntegerValue() {
        return this.integerValue;
    }

    public void setIntegerValue(Integer integerValue) {
        this.integerValue = integerValue;
    }

    public Resource withIntegerValue(Integer integerValue) {
        this.integerValue = integerValue;
        return this;
    }

    public List<String> getStringSetValue() {
        if (this.stringSetValue == null) {
            this.stringSetValue = new ListWithAutoConstructFlag();
            this.stringSetValue.setAutoConstruct(true);
        }
        return this.stringSetValue;
    }

    public void setStringSetValue(Collection<String> stringSetValue) {
        if (stringSetValue == null) {
            this.stringSetValue = null;
            return;
        }
        ListWithAutoConstructFlag stringSetValueCopy = new ListWithAutoConstructFlag(stringSetValue.size());
        stringSetValueCopy.addAll(stringSetValue);
        this.stringSetValue = stringSetValueCopy;
    }

    public Resource withStringSetValue(String ... stringSetValue) {
        if (this.getStringSetValue() == null) {
            this.setStringSetValue(new ArrayList<String>(stringSetValue.length));
        }
        for (String value : stringSetValue) {
            this.getStringSetValue().add(value);
        }
        return this;
    }

    public Resource withStringSetValue(Collection<String> stringSetValue) {
        if (stringSetValue == null) {
            this.stringSetValue = null;
        } else {
            ListWithAutoConstructFlag stringSetValueCopy = new ListWithAutoConstructFlag(stringSetValue.size());
            stringSetValueCopy.addAll(stringSetValue);
            this.stringSetValue = stringSetValueCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getType() != null) {
            sb.append("Type: " + this.getType() + ",");
        }
        if (this.getDoubleValue() != null) {
            sb.append("DoubleValue: " + this.getDoubleValue() + ",");
        }
        if (this.getLongValue() != null) {
            sb.append("LongValue: " + this.getLongValue() + ",");
        }
        if (this.getIntegerValue() != null) {
            sb.append("IntegerValue: " + this.getIntegerValue() + ",");
        }
        if (this.getStringSetValue() != null) {
            sb.append("StringSetValue: " + this.getStringSetValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getDoubleValue() == null ? 0 : this.getDoubleValue().hashCode());
        hashCode = 31 * hashCode + (this.getLongValue() == null ? 0 : this.getLongValue().hashCode());
        hashCode = 31 * hashCode + (this.getIntegerValue() == null ? 0 : this.getIntegerValue().hashCode());
        hashCode = 31 * hashCode + (this.getStringSetValue() == null ? 0 : this.getStringSetValue().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getDoubleValue() == null ^ this.getDoubleValue() == null) {
            return false;
        }
        if (other.getDoubleValue() != null && !other.getDoubleValue().equals(this.getDoubleValue())) {
            return false;
        }
        if (other.getLongValue() == null ^ this.getLongValue() == null) {
            return false;
        }
        if (other.getLongValue() != null && !other.getLongValue().equals(this.getLongValue())) {
            return false;
        }
        if (other.getIntegerValue() == null ^ this.getIntegerValue() == null) {
            return false;
        }
        if (other.getIntegerValue() != null && !other.getIntegerValue().equals(this.getIntegerValue())) {
            return false;
        }
        if (other.getStringSetValue() == null ^ this.getStringSetValue() == null) {
            return false;
        }
        return other.getStringSetValue() == null || other.getStringSetValue().equals(this.getStringSetValue());
    }
}

