/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeClustersRequest
extends AmazonWebServiceRequest
implements Serializable {
    private ListWithAutoConstructFlag<String> clusters;

    public List<String> getClusters() {
        if (this.clusters == null) {
            this.clusters = new ListWithAutoConstructFlag();
            this.clusters.setAutoConstruct(true);
        }
        return this.clusters;
    }

    public void setClusters(Collection<String> clusters) {
        if (clusters == null) {
            this.clusters = null;
            return;
        }
        ListWithAutoConstructFlag clustersCopy = new ListWithAutoConstructFlag(clusters.size());
        clustersCopy.addAll(clusters);
        this.clusters = clustersCopy;
    }

    public DescribeClustersRequest withClusters(String ... clusters) {
        if (this.getClusters() == null) {
            this.setClusters(new ArrayList<String>(clusters.length));
        }
        for (String value : clusters) {
            this.getClusters().add(value);
        }
        return this;
    }

    public DescribeClustersRequest withClusters(Collection<String> clusters) {
        if (clusters == null) {
            this.clusters = null;
        } else {
            ListWithAutoConstructFlag clustersCopy = new ListWithAutoConstructFlag(clusters.size());
            clustersCopy.addAll(clusters);
            this.clusters = clustersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusters() != null) {
            sb.append("Clusters: " + this.getClusters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusters() == null ? 0 : this.getClusters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClustersRequest)) {
            return false;
        }
        DescribeClustersRequest other = (DescribeClustersRequest)obj;
        if (other.getClusters() == null ^ this.getClusters() == null) {
            return false;
        }
        return other.getClusters() == null || other.getClusters().equals(this.getClusters());
    }
}

