/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ecs.AmazonECSAsync;
import com.amazonaws.services.ecs.AmazonECSAsyncClientBuilder;
import com.amazonaws.services.ecs.AmazonECSClient;
import com.amazonaws.services.ecs.model.CreateClusterRequest;
import com.amazonaws.services.ecs.model.CreateClusterResult;
import com.amazonaws.services.ecs.model.CreateServiceRequest;
import com.amazonaws.services.ecs.model.CreateServiceResult;
import com.amazonaws.services.ecs.model.DeleteAccountSettingRequest;
import com.amazonaws.services.ecs.model.DeleteAccountSettingResult;
import com.amazonaws.services.ecs.model.DeleteAttributesRequest;
import com.amazonaws.services.ecs.model.DeleteAttributesResult;
import com.amazonaws.services.ecs.model.DeleteClusterRequest;
import com.amazonaws.services.ecs.model.DeleteClusterResult;
import com.amazonaws.services.ecs.model.DeleteServiceRequest;
import com.amazonaws.services.ecs.model.DeleteServiceResult;
import com.amazonaws.services.ecs.model.DeregisterContainerInstanceRequest;
import com.amazonaws.services.ecs.model.DeregisterContainerInstanceResult;
import com.amazonaws.services.ecs.model.DeregisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.DeregisterTaskDefinitionResult;
import com.amazonaws.services.ecs.model.DescribeClustersRequest;
import com.amazonaws.services.ecs.model.DescribeClustersResult;
import com.amazonaws.services.ecs.model.DescribeContainerInstancesRequest;
import com.amazonaws.services.ecs.model.DescribeContainerInstancesResult;
import com.amazonaws.services.ecs.model.DescribeServicesRequest;
import com.amazonaws.services.ecs.model.DescribeServicesResult;
import com.amazonaws.services.ecs.model.DescribeTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.DescribeTaskDefinitionResult;
import com.amazonaws.services.ecs.model.DescribeTasksRequest;
import com.amazonaws.services.ecs.model.DescribeTasksResult;
import com.amazonaws.services.ecs.model.DiscoverPollEndpointRequest;
import com.amazonaws.services.ecs.model.DiscoverPollEndpointResult;
import com.amazonaws.services.ecs.model.ListAccountSettingsRequest;
import com.amazonaws.services.ecs.model.ListAccountSettingsResult;
import com.amazonaws.services.ecs.model.ListAttributesRequest;
import com.amazonaws.services.ecs.model.ListAttributesResult;
import com.amazonaws.services.ecs.model.ListClustersRequest;
import com.amazonaws.services.ecs.model.ListClustersResult;
import com.amazonaws.services.ecs.model.ListContainerInstancesRequest;
import com.amazonaws.services.ecs.model.ListContainerInstancesResult;
import com.amazonaws.services.ecs.model.ListServicesRequest;
import com.amazonaws.services.ecs.model.ListServicesResult;
import com.amazonaws.services.ecs.model.ListTagsForResourceRequest;
import com.amazonaws.services.ecs.model.ListTagsForResourceResult;
import com.amazonaws.services.ecs.model.ListTaskDefinitionFamiliesRequest;
import com.amazonaws.services.ecs.model.ListTaskDefinitionFamiliesResult;
import com.amazonaws.services.ecs.model.ListTaskDefinitionsRequest;
import com.amazonaws.services.ecs.model.ListTaskDefinitionsResult;
import com.amazonaws.services.ecs.model.ListTasksRequest;
import com.amazonaws.services.ecs.model.ListTasksResult;
import com.amazonaws.services.ecs.model.PutAccountSettingDefaultRequest;
import com.amazonaws.services.ecs.model.PutAccountSettingDefaultResult;
import com.amazonaws.services.ecs.model.PutAccountSettingRequest;
import com.amazonaws.services.ecs.model.PutAccountSettingResult;
import com.amazonaws.services.ecs.model.PutAttributesRequest;
import com.amazonaws.services.ecs.model.PutAttributesResult;
import com.amazonaws.services.ecs.model.RegisterContainerInstanceRequest;
import com.amazonaws.services.ecs.model.RegisterContainerInstanceResult;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionResult;
import com.amazonaws.services.ecs.model.RunTaskRequest;
import com.amazonaws.services.ecs.model.RunTaskResult;
import com.amazonaws.services.ecs.model.StartTaskRequest;
import com.amazonaws.services.ecs.model.StartTaskResult;
import com.amazonaws.services.ecs.model.StopTaskRequest;
import com.amazonaws.services.ecs.model.StopTaskResult;
import com.amazonaws.services.ecs.model.SubmitContainerStateChangeRequest;
import com.amazonaws.services.ecs.model.SubmitContainerStateChangeResult;
import com.amazonaws.services.ecs.model.SubmitTaskStateChangeRequest;
import com.amazonaws.services.ecs.model.SubmitTaskStateChangeResult;
import com.amazonaws.services.ecs.model.TagResourceRequest;
import com.amazonaws.services.ecs.model.TagResourceResult;
import com.amazonaws.services.ecs.model.UntagResourceRequest;
import com.amazonaws.services.ecs.model.UntagResourceResult;
import com.amazonaws.services.ecs.model.UpdateContainerAgentRequest;
import com.amazonaws.services.ecs.model.UpdateContainerAgentResult;
import com.amazonaws.services.ecs.model.UpdateContainerInstancesStateRequest;
import com.amazonaws.services.ecs.model.UpdateContainerInstancesStateResult;
import com.amazonaws.services.ecs.model.UpdateServiceRequest;
import com.amazonaws.services.ecs.model.UpdateServiceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonECSAsyncClient
extends AmazonECSClient
implements AmazonECSAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonECSAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonECSAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonECSAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonECSAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonECSAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonECSAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonECSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonECSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonECSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonECSAsyncClientBuilder asyncBuilder() {
        return AmazonECSAsyncClientBuilder.standard();
    }

    AmazonECSAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterAsync(request, null);
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request, final AsyncHandler<CreateClusterRequest, CreateClusterResult> asyncHandler) {
        final CreateClusterRequest finalRequest = (CreateClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateClusterResult>(){

            @Override
            public CreateClusterResult call() throws Exception {
                CreateClusterResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeCreateCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync() {
        return this.createClusterAsync(new CreateClusterRequest());
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(AsyncHandler<CreateClusterRequest, CreateClusterResult> asyncHandler) {
        return this.createClusterAsync(new CreateClusterRequest(), asyncHandler);
    }

    @Override
    public Future<CreateServiceResult> createServiceAsync(CreateServiceRequest request) {
        return this.createServiceAsync(request, null);
    }

    @Override
    public Future<CreateServiceResult> createServiceAsync(CreateServiceRequest request, final AsyncHandler<CreateServiceRequest, CreateServiceResult> asyncHandler) {
        final CreateServiceRequest finalRequest = (CreateServiceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateServiceResult>(){

            @Override
            public CreateServiceResult call() throws Exception {
                CreateServiceResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeCreateService(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAccountSettingResult> deleteAccountSettingAsync(DeleteAccountSettingRequest request) {
        return this.deleteAccountSettingAsync(request, null);
    }

    @Override
    public Future<DeleteAccountSettingResult> deleteAccountSettingAsync(DeleteAccountSettingRequest request, final AsyncHandler<DeleteAccountSettingRequest, DeleteAccountSettingResult> asyncHandler) {
        final DeleteAccountSettingRequest finalRequest = (DeleteAccountSettingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAccountSettingResult>(){

            @Override
            public DeleteAccountSettingResult call() throws Exception {
                DeleteAccountSettingResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeDeleteAccountSetting(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAttributesResult> deleteAttributesAsync(DeleteAttributesRequest request) {
        return this.deleteAttributesAsync(request, null);
    }

    @Override
    public Future<DeleteAttributesResult> deleteAttributesAsync(DeleteAttributesRequest request, final AsyncHandler<DeleteAttributesRequest, DeleteAttributesResult> asyncHandler) {
        final DeleteAttributesRequest finalRequest = (DeleteAttributesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAttributesResult>(){

            @Override
            public DeleteAttributesResult call() throws Exception {
                DeleteAttributesResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeDeleteAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterAsync(request, null);
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request, final AsyncHandler<DeleteClusterRequest, DeleteClusterResult> asyncHandler) {
        final DeleteClusterRequest finalRequest = (DeleteClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteClusterResult>(){

            @Override
            public DeleteClusterResult call() throws Exception {
                DeleteClusterResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeDeleteCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteServiceResult> deleteServiceAsync(DeleteServiceRequest request) {
        return this.deleteServiceAsync(request, null);
    }

    @Override
    public Future<DeleteServiceResult> deleteServiceAsync(DeleteServiceRequest request, final AsyncHandler<DeleteServiceRequest, DeleteServiceResult> asyncHandler) {
        final DeleteServiceRequest finalRequest = (DeleteServiceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteServiceResult>(){

            @Override
            public DeleteServiceResult call() throws Exception {
                DeleteServiceResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeDeleteService(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterContainerInstanceResult> deregisterContainerInstanceAsync(DeregisterContainerInstanceRequest request) {
        return this.deregisterContainerInstanceAsync(request, null);
    }

    @Override
    public Future<DeregisterContainerInstanceResult> deregisterContainerInstanceAsync(DeregisterContainerInstanceRequest request, final AsyncHandler<DeregisterContainerInstanceRequest, DeregisterContainerInstanceResult> asyncHandler) {
        final DeregisterContainerInstanceRequest finalRequest = (DeregisterContainerInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeregisterContainerInstanceResult>(){

            @Override
            public DeregisterContainerInstanceResult call() throws Exception {
                DeregisterContainerInstanceResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeDeregisterContainerInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterTaskDefinitionResult> deregisterTaskDefinitionAsync(DeregisterTaskDefinitionRequest request) {
        return this.deregisterTaskDefinitionAsync(request, null);
    }

    @Override
    public Future<DeregisterTaskDefinitionResult> deregisterTaskDefinitionAsync(DeregisterTaskDefinitionRequest request, final AsyncHandler<DeregisterTaskDefinitionRequest, DeregisterTaskDefinitionResult> asyncHandler) {
        final DeregisterTaskDefinitionRequest finalRequest = (DeregisterTaskDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeregisterTaskDefinitionResult>(){

            @Override
            public DeregisterTaskDefinitionResult call() throws Exception {
                DeregisterTaskDefinitionResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeDeregisterTaskDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(DescribeClustersRequest request) {
        return this.describeClustersAsync(request, null);
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(DescribeClustersRequest request, final AsyncHandler<DescribeClustersRequest, DescribeClustersResult> asyncHandler) {
        final DescribeClustersRequest finalRequest = (DescribeClustersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeClustersResult>(){

            @Override
            public DescribeClustersResult call() throws Exception {
                DescribeClustersResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeDescribeClusters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync() {
        return this.describeClustersAsync(new DescribeClustersRequest());
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(AsyncHandler<DescribeClustersRequest, DescribeClustersResult> asyncHandler) {
        return this.describeClustersAsync(new DescribeClustersRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeContainerInstancesResult> describeContainerInstancesAsync(DescribeContainerInstancesRequest request) {
        return this.describeContainerInstancesAsync(request, null);
    }

    @Override
    public Future<DescribeContainerInstancesResult> describeContainerInstancesAsync(DescribeContainerInstancesRequest request, final AsyncHandler<DescribeContainerInstancesRequest, DescribeContainerInstancesResult> asyncHandler) {
        final DescribeContainerInstancesRequest finalRequest = (DescribeContainerInstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeContainerInstancesResult>(){

            @Override
            public DescribeContainerInstancesResult call() throws Exception {
                DescribeContainerInstancesResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeDescribeContainerInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeServicesResult> describeServicesAsync(DescribeServicesRequest request) {
        return this.describeServicesAsync(request, null);
    }

    @Override
    public Future<DescribeServicesResult> describeServicesAsync(DescribeServicesRequest request, final AsyncHandler<DescribeServicesRequest, DescribeServicesResult> asyncHandler) {
        final DescribeServicesRequest finalRequest = (DescribeServicesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeServicesResult>(){

            @Override
            public DescribeServicesResult call() throws Exception {
                DescribeServicesResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeDescribeServices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTaskDefinitionResult> describeTaskDefinitionAsync(DescribeTaskDefinitionRequest request) {
        return this.describeTaskDefinitionAsync(request, null);
    }

    @Override
    public Future<DescribeTaskDefinitionResult> describeTaskDefinitionAsync(DescribeTaskDefinitionRequest request, final AsyncHandler<DescribeTaskDefinitionRequest, DescribeTaskDefinitionResult> asyncHandler) {
        final DescribeTaskDefinitionRequest finalRequest = (DescribeTaskDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTaskDefinitionResult>(){

            @Override
            public DescribeTaskDefinitionResult call() throws Exception {
                DescribeTaskDefinitionResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeDescribeTaskDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTasksResult> describeTasksAsync(DescribeTasksRequest request) {
        return this.describeTasksAsync(request, null);
    }

    @Override
    public Future<DescribeTasksResult> describeTasksAsync(DescribeTasksRequest request, final AsyncHandler<DescribeTasksRequest, DescribeTasksResult> asyncHandler) {
        final DescribeTasksRequest finalRequest = (DescribeTasksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTasksResult>(){

            @Override
            public DescribeTasksResult call() throws Exception {
                DescribeTasksResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeDescribeTasks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DiscoverPollEndpointResult> discoverPollEndpointAsync(DiscoverPollEndpointRequest request) {
        return this.discoverPollEndpointAsync(request, null);
    }

    @Override
    public Future<DiscoverPollEndpointResult> discoverPollEndpointAsync(DiscoverPollEndpointRequest request, final AsyncHandler<DiscoverPollEndpointRequest, DiscoverPollEndpointResult> asyncHandler) {
        final DiscoverPollEndpointRequest finalRequest = (DiscoverPollEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DiscoverPollEndpointResult>(){

            @Override
            public DiscoverPollEndpointResult call() throws Exception {
                DiscoverPollEndpointResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeDiscoverPollEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DiscoverPollEndpointResult> discoverPollEndpointAsync() {
        return this.discoverPollEndpointAsync(new DiscoverPollEndpointRequest());
    }

    @Override
    public Future<DiscoverPollEndpointResult> discoverPollEndpointAsync(AsyncHandler<DiscoverPollEndpointRequest, DiscoverPollEndpointResult> asyncHandler) {
        return this.discoverPollEndpointAsync(new DiscoverPollEndpointRequest(), asyncHandler);
    }

    @Override
    public Future<ListAccountSettingsResult> listAccountSettingsAsync(ListAccountSettingsRequest request) {
        return this.listAccountSettingsAsync(request, null);
    }

    @Override
    public Future<ListAccountSettingsResult> listAccountSettingsAsync(ListAccountSettingsRequest request, final AsyncHandler<ListAccountSettingsRequest, ListAccountSettingsResult> asyncHandler) {
        final ListAccountSettingsRequest finalRequest = (ListAccountSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAccountSettingsResult>(){

            @Override
            public ListAccountSettingsResult call() throws Exception {
                ListAccountSettingsResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeListAccountSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAttributesResult> listAttributesAsync(ListAttributesRequest request) {
        return this.listAttributesAsync(request, null);
    }

    @Override
    public Future<ListAttributesResult> listAttributesAsync(ListAttributesRequest request, final AsyncHandler<ListAttributesRequest, ListAttributesResult> asyncHandler) {
        final ListAttributesRequest finalRequest = (ListAttributesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAttributesResult>(){

            @Override
            public ListAttributesResult call() throws Exception {
                ListAttributesResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeListAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(ListClustersRequest request) {
        return this.listClustersAsync(request, null);
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(ListClustersRequest request, final AsyncHandler<ListClustersRequest, ListClustersResult> asyncHandler) {
        final ListClustersRequest finalRequest = (ListClustersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListClustersResult>(){

            @Override
            public ListClustersResult call() throws Exception {
                ListClustersResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeListClusters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListClustersResult> listClustersAsync() {
        return this.listClustersAsync(new ListClustersRequest());
    }

    @Override
    public Future<ListClustersResult> listClustersAsync(AsyncHandler<ListClustersRequest, ListClustersResult> asyncHandler) {
        return this.listClustersAsync(new ListClustersRequest(), asyncHandler);
    }

    @Override
    public Future<ListContainerInstancesResult> listContainerInstancesAsync(ListContainerInstancesRequest request) {
        return this.listContainerInstancesAsync(request, null);
    }

    @Override
    public Future<ListContainerInstancesResult> listContainerInstancesAsync(ListContainerInstancesRequest request, final AsyncHandler<ListContainerInstancesRequest, ListContainerInstancesResult> asyncHandler) {
        final ListContainerInstancesRequest finalRequest = (ListContainerInstancesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListContainerInstancesResult>(){

            @Override
            public ListContainerInstancesResult call() throws Exception {
                ListContainerInstancesResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeListContainerInstances(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListContainerInstancesResult> listContainerInstancesAsync() {
        return this.listContainerInstancesAsync(new ListContainerInstancesRequest());
    }

    @Override
    public Future<ListContainerInstancesResult> listContainerInstancesAsync(AsyncHandler<ListContainerInstancesRequest, ListContainerInstancesResult> asyncHandler) {
        return this.listContainerInstancesAsync(new ListContainerInstancesRequest(), asyncHandler);
    }

    @Override
    public Future<ListServicesResult> listServicesAsync(ListServicesRequest request) {
        return this.listServicesAsync(request, null);
    }

    @Override
    public Future<ListServicesResult> listServicesAsync(ListServicesRequest request, final AsyncHandler<ListServicesRequest, ListServicesResult> asyncHandler) {
        final ListServicesRequest finalRequest = (ListServicesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListServicesResult>(){

            @Override
            public ListServicesResult call() throws Exception {
                ListServicesResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeListServices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListServicesResult> listServicesAsync() {
        return this.listServicesAsync(new ListServicesRequest());
    }

    @Override
    public Future<ListServicesResult> listServicesAsync(AsyncHandler<ListServicesRequest, ListServicesResult> asyncHandler) {
        return this.listServicesAsync(new ListServicesRequest(), asyncHandler);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTaskDefinitionFamiliesResult> listTaskDefinitionFamiliesAsync(ListTaskDefinitionFamiliesRequest request) {
        return this.listTaskDefinitionFamiliesAsync(request, null);
    }

    @Override
    public Future<ListTaskDefinitionFamiliesResult> listTaskDefinitionFamiliesAsync(ListTaskDefinitionFamiliesRequest request, final AsyncHandler<ListTaskDefinitionFamiliesRequest, ListTaskDefinitionFamiliesResult> asyncHandler) {
        final ListTaskDefinitionFamiliesRequest finalRequest = (ListTaskDefinitionFamiliesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTaskDefinitionFamiliesResult>(){

            @Override
            public ListTaskDefinitionFamiliesResult call() throws Exception {
                ListTaskDefinitionFamiliesResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeListTaskDefinitionFamilies(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTaskDefinitionFamiliesResult> listTaskDefinitionFamiliesAsync() {
        return this.listTaskDefinitionFamiliesAsync(new ListTaskDefinitionFamiliesRequest());
    }

    @Override
    public Future<ListTaskDefinitionFamiliesResult> listTaskDefinitionFamiliesAsync(AsyncHandler<ListTaskDefinitionFamiliesRequest, ListTaskDefinitionFamiliesResult> asyncHandler) {
        return this.listTaskDefinitionFamiliesAsync(new ListTaskDefinitionFamiliesRequest(), asyncHandler);
    }

    @Override
    public Future<ListTaskDefinitionsResult> listTaskDefinitionsAsync(ListTaskDefinitionsRequest request) {
        return this.listTaskDefinitionsAsync(request, null);
    }

    @Override
    public Future<ListTaskDefinitionsResult> listTaskDefinitionsAsync(ListTaskDefinitionsRequest request, final AsyncHandler<ListTaskDefinitionsRequest, ListTaskDefinitionsResult> asyncHandler) {
        final ListTaskDefinitionsRequest finalRequest = (ListTaskDefinitionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTaskDefinitionsResult>(){

            @Override
            public ListTaskDefinitionsResult call() throws Exception {
                ListTaskDefinitionsResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeListTaskDefinitions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTaskDefinitionsResult> listTaskDefinitionsAsync() {
        return this.listTaskDefinitionsAsync(new ListTaskDefinitionsRequest());
    }

    @Override
    public Future<ListTaskDefinitionsResult> listTaskDefinitionsAsync(AsyncHandler<ListTaskDefinitionsRequest, ListTaskDefinitionsResult> asyncHandler) {
        return this.listTaskDefinitionsAsync(new ListTaskDefinitionsRequest(), asyncHandler);
    }

    @Override
    public Future<ListTasksResult> listTasksAsync(ListTasksRequest request) {
        return this.listTasksAsync(request, null);
    }

    @Override
    public Future<ListTasksResult> listTasksAsync(ListTasksRequest request, final AsyncHandler<ListTasksRequest, ListTasksResult> asyncHandler) {
        final ListTasksRequest finalRequest = (ListTasksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTasksResult>(){

            @Override
            public ListTasksResult call() throws Exception {
                ListTasksResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeListTasks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTasksResult> listTasksAsync() {
        return this.listTasksAsync(new ListTasksRequest());
    }

    @Override
    public Future<ListTasksResult> listTasksAsync(AsyncHandler<ListTasksRequest, ListTasksResult> asyncHandler) {
        return this.listTasksAsync(new ListTasksRequest(), asyncHandler);
    }

    @Override
    public Future<PutAccountSettingResult> putAccountSettingAsync(PutAccountSettingRequest request) {
        return this.putAccountSettingAsync(request, null);
    }

    @Override
    public Future<PutAccountSettingResult> putAccountSettingAsync(PutAccountSettingRequest request, final AsyncHandler<PutAccountSettingRequest, PutAccountSettingResult> asyncHandler) {
        final PutAccountSettingRequest finalRequest = (PutAccountSettingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutAccountSettingResult>(){

            @Override
            public PutAccountSettingResult call() throws Exception {
                PutAccountSettingResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executePutAccountSetting(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutAccountSettingDefaultResult> putAccountSettingDefaultAsync(PutAccountSettingDefaultRequest request) {
        return this.putAccountSettingDefaultAsync(request, null);
    }

    @Override
    public Future<PutAccountSettingDefaultResult> putAccountSettingDefaultAsync(PutAccountSettingDefaultRequest request, final AsyncHandler<PutAccountSettingDefaultRequest, PutAccountSettingDefaultResult> asyncHandler) {
        final PutAccountSettingDefaultRequest finalRequest = (PutAccountSettingDefaultRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutAccountSettingDefaultResult>(){

            @Override
            public PutAccountSettingDefaultResult call() throws Exception {
                PutAccountSettingDefaultResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executePutAccountSettingDefault(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutAttributesResult> putAttributesAsync(PutAttributesRequest request) {
        return this.putAttributesAsync(request, null);
    }

    @Override
    public Future<PutAttributesResult> putAttributesAsync(PutAttributesRequest request, final AsyncHandler<PutAttributesRequest, PutAttributesResult> asyncHandler) {
        final PutAttributesRequest finalRequest = (PutAttributesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutAttributesResult>(){

            @Override
            public PutAttributesResult call() throws Exception {
                PutAttributesResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executePutAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterContainerInstanceResult> registerContainerInstanceAsync(RegisterContainerInstanceRequest request) {
        return this.registerContainerInstanceAsync(request, null);
    }

    @Override
    public Future<RegisterContainerInstanceResult> registerContainerInstanceAsync(RegisterContainerInstanceRequest request, final AsyncHandler<RegisterContainerInstanceRequest, RegisterContainerInstanceResult> asyncHandler) {
        final RegisterContainerInstanceRequest finalRequest = (RegisterContainerInstanceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterContainerInstanceResult>(){

            @Override
            public RegisterContainerInstanceResult call() throws Exception {
                RegisterContainerInstanceResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeRegisterContainerInstance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterTaskDefinitionResult> registerTaskDefinitionAsync(RegisterTaskDefinitionRequest request) {
        return this.registerTaskDefinitionAsync(request, null);
    }

    @Override
    public Future<RegisterTaskDefinitionResult> registerTaskDefinitionAsync(RegisterTaskDefinitionRequest request, final AsyncHandler<RegisterTaskDefinitionRequest, RegisterTaskDefinitionResult> asyncHandler) {
        final RegisterTaskDefinitionRequest finalRequest = (RegisterTaskDefinitionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterTaskDefinitionResult>(){

            @Override
            public RegisterTaskDefinitionResult call() throws Exception {
                RegisterTaskDefinitionResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeRegisterTaskDefinition(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RunTaskResult> runTaskAsync(RunTaskRequest request) {
        return this.runTaskAsync(request, null);
    }

    @Override
    public Future<RunTaskResult> runTaskAsync(RunTaskRequest request, final AsyncHandler<RunTaskRequest, RunTaskResult> asyncHandler) {
        final RunTaskRequest finalRequest = (RunTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RunTaskResult>(){

            @Override
            public RunTaskResult call() throws Exception {
                RunTaskResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeRunTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartTaskResult> startTaskAsync(StartTaskRequest request) {
        return this.startTaskAsync(request, null);
    }

    @Override
    public Future<StartTaskResult> startTaskAsync(StartTaskRequest request, final AsyncHandler<StartTaskRequest, StartTaskResult> asyncHandler) {
        final StartTaskRequest finalRequest = (StartTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartTaskResult>(){

            @Override
            public StartTaskResult call() throws Exception {
                StartTaskResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeStartTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopTaskResult> stopTaskAsync(StopTaskRequest request) {
        return this.stopTaskAsync(request, null);
    }

    @Override
    public Future<StopTaskResult> stopTaskAsync(StopTaskRequest request, final AsyncHandler<StopTaskRequest, StopTaskResult> asyncHandler) {
        final StopTaskRequest finalRequest = (StopTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopTaskResult>(){

            @Override
            public StopTaskResult call() throws Exception {
                StopTaskResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeStopTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SubmitContainerStateChangeResult> submitContainerStateChangeAsync(SubmitContainerStateChangeRequest request) {
        return this.submitContainerStateChangeAsync(request, null);
    }

    @Override
    public Future<SubmitContainerStateChangeResult> submitContainerStateChangeAsync(SubmitContainerStateChangeRequest request, final AsyncHandler<SubmitContainerStateChangeRequest, SubmitContainerStateChangeResult> asyncHandler) {
        final SubmitContainerStateChangeRequest finalRequest = (SubmitContainerStateChangeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SubmitContainerStateChangeResult>(){

            @Override
            public SubmitContainerStateChangeResult call() throws Exception {
                SubmitContainerStateChangeResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeSubmitContainerStateChange(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SubmitContainerStateChangeResult> submitContainerStateChangeAsync() {
        return this.submitContainerStateChangeAsync(new SubmitContainerStateChangeRequest());
    }

    @Override
    public Future<SubmitContainerStateChangeResult> submitContainerStateChangeAsync(AsyncHandler<SubmitContainerStateChangeRequest, SubmitContainerStateChangeResult> asyncHandler) {
        return this.submitContainerStateChangeAsync(new SubmitContainerStateChangeRequest(), asyncHandler);
    }

    @Override
    public Future<SubmitTaskStateChangeResult> submitTaskStateChangeAsync(SubmitTaskStateChangeRequest request) {
        return this.submitTaskStateChangeAsync(request, null);
    }

    @Override
    public Future<SubmitTaskStateChangeResult> submitTaskStateChangeAsync(SubmitTaskStateChangeRequest request, final AsyncHandler<SubmitTaskStateChangeRequest, SubmitTaskStateChangeResult> asyncHandler) {
        final SubmitTaskStateChangeRequest finalRequest = (SubmitTaskStateChangeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SubmitTaskStateChangeResult>(){

            @Override
            public SubmitTaskStateChangeResult call() throws Exception {
                SubmitTaskStateChangeResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeSubmitTaskStateChange(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateContainerAgentResult> updateContainerAgentAsync(UpdateContainerAgentRequest request) {
        return this.updateContainerAgentAsync(request, null);
    }

    @Override
    public Future<UpdateContainerAgentResult> updateContainerAgentAsync(UpdateContainerAgentRequest request, final AsyncHandler<UpdateContainerAgentRequest, UpdateContainerAgentResult> asyncHandler) {
        final UpdateContainerAgentRequest finalRequest = (UpdateContainerAgentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateContainerAgentResult>(){

            @Override
            public UpdateContainerAgentResult call() throws Exception {
                UpdateContainerAgentResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeUpdateContainerAgent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateContainerInstancesStateResult> updateContainerInstancesStateAsync(UpdateContainerInstancesStateRequest request) {
        return this.updateContainerInstancesStateAsync(request, null);
    }

    @Override
    public Future<UpdateContainerInstancesStateResult> updateContainerInstancesStateAsync(UpdateContainerInstancesStateRequest request, final AsyncHandler<UpdateContainerInstancesStateRequest, UpdateContainerInstancesStateResult> asyncHandler) {
        final UpdateContainerInstancesStateRequest finalRequest = (UpdateContainerInstancesStateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateContainerInstancesStateResult>(){

            @Override
            public UpdateContainerInstancesStateResult call() throws Exception {
                UpdateContainerInstancesStateResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeUpdateContainerInstancesState(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateServiceResult> updateServiceAsync(UpdateServiceRequest request) {
        return this.updateServiceAsync(request, null);
    }

    @Override
    public Future<UpdateServiceResult> updateServiceAsync(UpdateServiceRequest request, final AsyncHandler<UpdateServiceRequest, UpdateServiceResult> asyncHandler) {
        final UpdateServiceRequest finalRequest = (UpdateServiceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateServiceResult>(){

            @Override
            public UpdateServiceResult call() throws Exception {
                UpdateServiceResult result = null;
                try {
                    result = AmazonECSAsyncClient.this.executeUpdateService(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

