/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.Compatibility;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import com.amazonaws.services.ecs.model.IpcMode;
import com.amazonaws.services.ecs.model.NetworkMode;
import com.amazonaws.services.ecs.model.PidMode;
import com.amazonaws.services.ecs.model.Tag;
import com.amazonaws.services.ecs.model.TaskDefinitionPlacementConstraint;
import com.amazonaws.services.ecs.model.Volume;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RegisterTaskDefinitionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String family;
    private String taskRoleArn;
    private String executionRoleArn;
    private String networkMode;
    private SdkInternalList<ContainerDefinition> containerDefinitions;
    private SdkInternalList<Volume> volumes;
    private SdkInternalList<TaskDefinitionPlacementConstraint> placementConstraints;
    private SdkInternalList<String> requiresCompatibilities;
    private String cpu;
    private String memory;
    private SdkInternalList<Tag> tags;
    private String pidMode;
    private String ipcMode;

    public void setFamily(String family) {
        this.family = family;
    }

    public String getFamily() {
        return this.family;
    }

    public RegisterTaskDefinitionRequest withFamily(String family) {
        this.setFamily(family);
        return this;
    }

    public void setTaskRoleArn(String taskRoleArn) {
        this.taskRoleArn = taskRoleArn;
    }

    public String getTaskRoleArn() {
        return this.taskRoleArn;
    }

    public RegisterTaskDefinitionRequest withTaskRoleArn(String taskRoleArn) {
        this.setTaskRoleArn(taskRoleArn);
        return this;
    }

    public void setExecutionRoleArn(String executionRoleArn) {
        this.executionRoleArn = executionRoleArn;
    }

    public String getExecutionRoleArn() {
        return this.executionRoleArn;
    }

    public RegisterTaskDefinitionRequest withExecutionRoleArn(String executionRoleArn) {
        this.setExecutionRoleArn(executionRoleArn);
        return this;
    }

    public void setNetworkMode(String networkMode) {
        this.networkMode = networkMode;
    }

    public String getNetworkMode() {
        return this.networkMode;
    }

    public RegisterTaskDefinitionRequest withNetworkMode(String networkMode) {
        this.setNetworkMode(networkMode);
        return this;
    }

    public void setNetworkMode(NetworkMode networkMode) {
        this.withNetworkMode(networkMode);
    }

    public RegisterTaskDefinitionRequest withNetworkMode(NetworkMode networkMode) {
        this.networkMode = networkMode.toString();
        return this;
    }

    public List<ContainerDefinition> getContainerDefinitions() {
        if (this.containerDefinitions == null) {
            this.containerDefinitions = new SdkInternalList();
        }
        return this.containerDefinitions;
    }

    public void setContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        if (containerDefinitions == null) {
            this.containerDefinitions = null;
            return;
        }
        this.containerDefinitions = new SdkInternalList(containerDefinitions);
    }

    public RegisterTaskDefinitionRequest withContainerDefinitions(ContainerDefinition ... containerDefinitions) {
        if (this.containerDefinitions == null) {
            this.setContainerDefinitions((Collection<ContainerDefinition>)new SdkInternalList(containerDefinitions.length));
        }
        for (ContainerDefinition ele : containerDefinitions) {
            this.containerDefinitions.add((Object)ele);
        }
        return this;
    }

    public RegisterTaskDefinitionRequest withContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        this.setContainerDefinitions(containerDefinitions);
        return this;
    }

    public List<Volume> getVolumes() {
        if (this.volumes == null) {
            this.volumes = new SdkInternalList();
        }
        return this.volumes;
    }

    public void setVolumes(Collection<Volume> volumes) {
        if (volumes == null) {
            this.volumes = null;
            return;
        }
        this.volumes = new SdkInternalList(volumes);
    }

    public RegisterTaskDefinitionRequest withVolumes(Volume ... volumes) {
        if (this.volumes == null) {
            this.setVolumes((Collection<Volume>)new SdkInternalList(volumes.length));
        }
        for (Volume ele : volumes) {
            this.volumes.add((Object)ele);
        }
        return this;
    }

    public RegisterTaskDefinitionRequest withVolumes(Collection<Volume> volumes) {
        this.setVolumes(volumes);
        return this;
    }

    public List<TaskDefinitionPlacementConstraint> getPlacementConstraints() {
        if (this.placementConstraints == null) {
            this.placementConstraints = new SdkInternalList();
        }
        return this.placementConstraints;
    }

    public void setPlacementConstraints(Collection<TaskDefinitionPlacementConstraint> placementConstraints) {
        if (placementConstraints == null) {
            this.placementConstraints = null;
            return;
        }
        this.placementConstraints = new SdkInternalList(placementConstraints);
    }

    public RegisterTaskDefinitionRequest withPlacementConstraints(TaskDefinitionPlacementConstraint ... placementConstraints) {
        if (this.placementConstraints == null) {
            this.setPlacementConstraints((Collection<TaskDefinitionPlacementConstraint>)new SdkInternalList(placementConstraints.length));
        }
        for (TaskDefinitionPlacementConstraint ele : placementConstraints) {
            this.placementConstraints.add((Object)ele);
        }
        return this;
    }

    public RegisterTaskDefinitionRequest withPlacementConstraints(Collection<TaskDefinitionPlacementConstraint> placementConstraints) {
        this.setPlacementConstraints(placementConstraints);
        return this;
    }

    public List<String> getRequiresCompatibilities() {
        if (this.requiresCompatibilities == null) {
            this.requiresCompatibilities = new SdkInternalList();
        }
        return this.requiresCompatibilities;
    }

    public void setRequiresCompatibilities(Collection<String> requiresCompatibilities) {
        if (requiresCompatibilities == null) {
            this.requiresCompatibilities = null;
            return;
        }
        this.requiresCompatibilities = new SdkInternalList(requiresCompatibilities);
    }

    public RegisterTaskDefinitionRequest withRequiresCompatibilities(String ... requiresCompatibilities) {
        if (this.requiresCompatibilities == null) {
            this.setRequiresCompatibilities((Collection<String>)new SdkInternalList(requiresCompatibilities.length));
        }
        for (String ele : requiresCompatibilities) {
            this.requiresCompatibilities.add((Object)ele);
        }
        return this;
    }

    public RegisterTaskDefinitionRequest withRequiresCompatibilities(Collection<String> requiresCompatibilities) {
        this.setRequiresCompatibilities(requiresCompatibilities);
        return this;
    }

    public RegisterTaskDefinitionRequest withRequiresCompatibilities(Compatibility ... requiresCompatibilities) {
        SdkInternalList requiresCompatibilitiesCopy = new SdkInternalList(requiresCompatibilities.length);
        for (Compatibility value : requiresCompatibilities) {
            requiresCompatibilitiesCopy.add((Object)value.toString());
        }
        if (this.getRequiresCompatibilities() == null) {
            this.setRequiresCompatibilities((Collection<String>)requiresCompatibilitiesCopy);
        } else {
            this.getRequiresCompatibilities().addAll((Collection<String>)requiresCompatibilitiesCopy);
        }
        return this;
    }

    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    public String getCpu() {
        return this.cpu;
    }

    public RegisterTaskDefinitionRequest withCpu(String cpu) {
        this.setCpu(cpu);
        return this;
    }

    public void setMemory(String memory) {
        this.memory = memory;
    }

    public String getMemory() {
        return this.memory;
    }

    public RegisterTaskDefinitionRequest withMemory(String memory) {
        this.setMemory(memory);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public RegisterTaskDefinitionRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public RegisterTaskDefinitionRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setPidMode(String pidMode) {
        this.pidMode = pidMode;
    }

    public String getPidMode() {
        return this.pidMode;
    }

    public RegisterTaskDefinitionRequest withPidMode(String pidMode) {
        this.setPidMode(pidMode);
        return this;
    }

    public void setPidMode(PidMode pidMode) {
        this.withPidMode(pidMode);
    }

    public RegisterTaskDefinitionRequest withPidMode(PidMode pidMode) {
        this.pidMode = pidMode.toString();
        return this;
    }

    public void setIpcMode(String ipcMode) {
        this.ipcMode = ipcMode;
    }

    public String getIpcMode() {
        return this.ipcMode;
    }

    public RegisterTaskDefinitionRequest withIpcMode(String ipcMode) {
        this.setIpcMode(ipcMode);
        return this;
    }

    public void setIpcMode(IpcMode ipcMode) {
        this.withIpcMode(ipcMode);
    }

    public RegisterTaskDefinitionRequest withIpcMode(IpcMode ipcMode) {
        this.ipcMode = ipcMode.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFamily() != null) {
            sb.append("Family: ").append(this.getFamily()).append(",");
        }
        if (this.getTaskRoleArn() != null) {
            sb.append("TaskRoleArn: ").append(this.getTaskRoleArn()).append(",");
        }
        if (this.getExecutionRoleArn() != null) {
            sb.append("ExecutionRoleArn: ").append(this.getExecutionRoleArn()).append(",");
        }
        if (this.getNetworkMode() != null) {
            sb.append("NetworkMode: ").append(this.getNetworkMode()).append(",");
        }
        if (this.getContainerDefinitions() != null) {
            sb.append("ContainerDefinitions: ").append(this.getContainerDefinitions()).append(",");
        }
        if (this.getVolumes() != null) {
            sb.append("Volumes: ").append(this.getVolumes()).append(",");
        }
        if (this.getPlacementConstraints() != null) {
            sb.append("PlacementConstraints: ").append(this.getPlacementConstraints()).append(",");
        }
        if (this.getRequiresCompatibilities() != null) {
            sb.append("RequiresCompatibilities: ").append(this.getRequiresCompatibilities()).append(",");
        }
        if (this.getCpu() != null) {
            sb.append("Cpu: ").append(this.getCpu()).append(",");
        }
        if (this.getMemory() != null) {
            sb.append("Memory: ").append(this.getMemory()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getPidMode() != null) {
            sb.append("PidMode: ").append(this.getPidMode()).append(",");
        }
        if (this.getIpcMode() != null) {
            sb.append("IpcMode: ").append(this.getIpcMode());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTaskDefinitionRequest)) {
            return false;
        }
        RegisterTaskDefinitionRequest other = (RegisterTaskDefinitionRequest)obj;
        if (other.getFamily() == null ^ this.getFamily() == null) {
            return false;
        }
        if (other.getFamily() != null && !other.getFamily().equals(this.getFamily())) {
            return false;
        }
        if (other.getTaskRoleArn() == null ^ this.getTaskRoleArn() == null) {
            return false;
        }
        if (other.getTaskRoleArn() != null && !other.getTaskRoleArn().equals(this.getTaskRoleArn())) {
            return false;
        }
        if (other.getExecutionRoleArn() == null ^ this.getExecutionRoleArn() == null) {
            return false;
        }
        if (other.getExecutionRoleArn() != null && !other.getExecutionRoleArn().equals(this.getExecutionRoleArn())) {
            return false;
        }
        if (other.getNetworkMode() == null ^ this.getNetworkMode() == null) {
            return false;
        }
        if (other.getNetworkMode() != null && !other.getNetworkMode().equals(this.getNetworkMode())) {
            return false;
        }
        if (other.getContainerDefinitions() == null ^ this.getContainerDefinitions() == null) {
            return false;
        }
        if (other.getContainerDefinitions() != null && !other.getContainerDefinitions().equals(this.getContainerDefinitions())) {
            return false;
        }
        if (other.getVolumes() == null ^ this.getVolumes() == null) {
            return false;
        }
        if (other.getVolumes() != null && !other.getVolumes().equals(this.getVolumes())) {
            return false;
        }
        if (other.getPlacementConstraints() == null ^ this.getPlacementConstraints() == null) {
            return false;
        }
        if (other.getPlacementConstraints() != null && !other.getPlacementConstraints().equals(this.getPlacementConstraints())) {
            return false;
        }
        if (other.getRequiresCompatibilities() == null ^ this.getRequiresCompatibilities() == null) {
            return false;
        }
        if (other.getRequiresCompatibilities() != null && !other.getRequiresCompatibilities().equals(this.getRequiresCompatibilities())) {
            return false;
        }
        if (other.getCpu() == null ^ this.getCpu() == null) {
            return false;
        }
        if (other.getCpu() != null && !other.getCpu().equals(this.getCpu())) {
            return false;
        }
        if (other.getMemory() == null ^ this.getMemory() == null) {
            return false;
        }
        if (other.getMemory() != null && !other.getMemory().equals(this.getMemory())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getPidMode() == null ^ this.getPidMode() == null) {
            return false;
        }
        if (other.getPidMode() != null && !other.getPidMode().equals(this.getPidMode())) {
            return false;
        }
        if (other.getIpcMode() == null ^ this.getIpcMode() == null) {
            return false;
        }
        return other.getIpcMode() == null || other.getIpcMode().equals(this.getIpcMode());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFamily() == null ? 0 : this.getFamily().hashCode());
        hashCode = 31 * hashCode + (this.getTaskRoleArn() == null ? 0 : this.getTaskRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionRoleArn() == null ? 0 : this.getExecutionRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkMode() == null ? 0 : this.getNetworkMode().hashCode());
        hashCode = 31 * hashCode + (this.getContainerDefinitions() == null ? 0 : this.getContainerDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getVolumes() == null ? 0 : this.getVolumes().hashCode());
        hashCode = 31 * hashCode + (this.getPlacementConstraints() == null ? 0 : this.getPlacementConstraints().hashCode());
        hashCode = 31 * hashCode + (this.getRequiresCompatibilities() == null ? 0 : this.getRequiresCompatibilities().hashCode());
        hashCode = 31 * hashCode + (this.getCpu() == null ? 0 : this.getCpu().hashCode());
        hashCode = 31 * hashCode + (this.getMemory() == null ? 0 : this.getMemory().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getPidMode() == null ? 0 : this.getPidMode().hashCode());
        hashCode = 31 * hashCode + (this.getIpcMode() == null ? 0 : this.getIpcMode().hashCode());
        return hashCode;
    }

    public RegisterTaskDefinitionRequest clone() {
        return (RegisterTaskDefinitionRequest)super.clone();
    }
}

