/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.Attribute;
import com.amazonaws.services.ecs.model.RegisterContainerInstanceRequest;
import com.amazonaws.services.ecs.model.Resource;
import com.amazonaws.services.ecs.model.transform.AttributeJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.ResourceJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.VersionInfoJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RegisterContainerInstanceRequestMarshaller
implements Marshaller<Request<RegisterContainerInstanceRequest>, RegisterContainerInstanceRequest> {
    public Request<RegisterContainerInstanceRequest> marshall(RegisterContainerInstanceRequest registerContainerInstanceRequest) {
        if (registerContainerInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerContainerInstanceRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.RegisterContainerInstance");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList attributesList;
            SdkInternalList totalResourcesList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (registerContainerInstanceRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(registerContainerInstanceRequest.getCluster());
            }
            if (registerContainerInstanceRequest.getInstanceIdentityDocument() != null) {
                jsonGenerator.writeFieldName("instanceIdentityDocument").writeValue(registerContainerInstanceRequest.getInstanceIdentityDocument());
            }
            if (registerContainerInstanceRequest.getInstanceIdentityDocumentSignature() != null) {
                jsonGenerator.writeFieldName("instanceIdentityDocumentSignature").writeValue(registerContainerInstanceRequest.getInstanceIdentityDocumentSignature());
            }
            if (!(totalResourcesList = (SdkInternalList)registerContainerInstanceRequest.getTotalResources()).isEmpty() || !totalResourcesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("totalResources");
                jsonGenerator.writeStartArray();
                for (Object totalResourcesListValue : totalResourcesList) {
                    if (totalResourcesListValue == null) continue;
                    ResourceJsonMarshaller.getInstance().marshall((Resource)totalResourcesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (registerContainerInstanceRequest.getVersionInfo() != null) {
                jsonGenerator.writeFieldName("versionInfo");
                VersionInfoJsonMarshaller.getInstance().marshall(registerContainerInstanceRequest.getVersionInfo(), jsonGenerator);
            }
            if (registerContainerInstanceRequest.getContainerInstanceArn() != null) {
                jsonGenerator.writeFieldName("containerInstanceArn").writeValue(registerContainerInstanceRequest.getContainerInstanceArn());
            }
            if (!(attributesList = (SdkInternalList)registerContainerInstanceRequest.getAttributes()).isEmpty() || !attributesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("attributes");
                jsonGenerator.writeStartArray();
                for (Attribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

