/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecs.model.HostEntry;
import com.amazonaws.util.json.SdkJsonGenerator;

public class HostEntryJsonMarshaller {
    private static HostEntryJsonMarshaller instance;

    public void marshall(HostEntry hostEntry, SdkJsonGenerator jsonGenerator) {
        if (hostEntry == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (hostEntry.getHostname() != null) {
                jsonGenerator.writeFieldName("hostname").writeValue(hostEntry.getHostname());
            }
            if (hostEntry.getIpAddress() != null) {
                jsonGenerator.writeFieldName("ipAddress").writeValue(hostEntry.getIpAddress());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static HostEntryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new HostEntryJsonMarshaller();
        }
        return instance;
    }
}

