/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.Container;
import com.amazonaws.services.ecs.model.TaskOverride;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Task
implements Serializable,
Cloneable {
    private String taskArn;
    private String clusterArn;
    private String taskDefinitionArn;
    private String containerInstanceArn;
    private TaskOverride overrides;
    private String lastStatus;
    private String desiredStatus;
    private SdkInternalList<Container> containers;
    private String startedBy;

    public void setTaskArn(String taskArn) {
        this.taskArn = taskArn;
    }

    public String getTaskArn() {
        return this.taskArn;
    }

    public Task withTaskArn(String taskArn) {
        this.setTaskArn(taskArn);
        return this;
    }

    public void setClusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
    }

    public String getClusterArn() {
        return this.clusterArn;
    }

    public Task withClusterArn(String clusterArn) {
        this.setClusterArn(clusterArn);
        return this;
    }

    public void setTaskDefinitionArn(String taskDefinitionArn) {
        this.taskDefinitionArn = taskDefinitionArn;
    }

    public String getTaskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public Task withTaskDefinitionArn(String taskDefinitionArn) {
        this.setTaskDefinitionArn(taskDefinitionArn);
        return this;
    }

    public void setContainerInstanceArn(String containerInstanceArn) {
        this.containerInstanceArn = containerInstanceArn;
    }

    public String getContainerInstanceArn() {
        return this.containerInstanceArn;
    }

    public Task withContainerInstanceArn(String containerInstanceArn) {
        this.setContainerInstanceArn(containerInstanceArn);
        return this;
    }

    public void setOverrides(TaskOverride overrides) {
        this.overrides = overrides;
    }

    public TaskOverride getOverrides() {
        return this.overrides;
    }

    public Task withOverrides(TaskOverride overrides) {
        this.setOverrides(overrides);
        return this;
    }

    public void setLastStatus(String lastStatus) {
        this.lastStatus = lastStatus;
    }

    public String getLastStatus() {
        return this.lastStatus;
    }

    public Task withLastStatus(String lastStatus) {
        this.setLastStatus(lastStatus);
        return this;
    }

    public void setDesiredStatus(String desiredStatus) {
        this.desiredStatus = desiredStatus;
    }

    public String getDesiredStatus() {
        return this.desiredStatus;
    }

    public Task withDesiredStatus(String desiredStatus) {
        this.setDesiredStatus(desiredStatus);
        return this;
    }

    public List<Container> getContainers() {
        if (this.containers == null) {
            this.containers = new SdkInternalList();
        }
        return this.containers;
    }

    public void setContainers(Collection<Container> containers) {
        if (containers == null) {
            this.containers = null;
            return;
        }
        this.containers = new SdkInternalList(containers);
    }

    public Task withContainers(Container ... containers) {
        if (this.containers == null) {
            this.setContainers((Collection<Container>)new SdkInternalList(containers.length));
        }
        for (Container ele : containers) {
            this.containers.add((Object)ele);
        }
        return this;
    }

    public Task withContainers(Collection<Container> containers) {
        this.setContainers(containers);
        return this;
    }

    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public Task withStartedBy(String startedBy) {
        this.setStartedBy(startedBy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTaskArn() != null) {
            sb.append("TaskArn: " + this.getTaskArn() + ",");
        }
        if (this.getClusterArn() != null) {
            sb.append("ClusterArn: " + this.getClusterArn() + ",");
        }
        if (this.getTaskDefinitionArn() != null) {
            sb.append("TaskDefinitionArn: " + this.getTaskDefinitionArn() + ",");
        }
        if (this.getContainerInstanceArn() != null) {
            sb.append("ContainerInstanceArn: " + this.getContainerInstanceArn() + ",");
        }
        if (this.getOverrides() != null) {
            sb.append("Overrides: " + this.getOverrides() + ",");
        }
        if (this.getLastStatus() != null) {
            sb.append("LastStatus: " + this.getLastStatus() + ",");
        }
        if (this.getDesiredStatus() != null) {
            sb.append("DesiredStatus: " + this.getDesiredStatus() + ",");
        }
        if (this.getContainers() != null) {
            sb.append("Containers: " + this.getContainers() + ",");
        }
        if (this.getStartedBy() != null) {
            sb.append("StartedBy: " + this.getStartedBy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Task)) {
            return false;
        }
        Task other = (Task)obj;
        if (other.getTaskArn() == null ^ this.getTaskArn() == null) {
            return false;
        }
        if (other.getTaskArn() != null && !other.getTaskArn().equals(this.getTaskArn())) {
            return false;
        }
        if (other.getClusterArn() == null ^ this.getClusterArn() == null) {
            return false;
        }
        if (other.getClusterArn() != null && !other.getClusterArn().equals(this.getClusterArn())) {
            return false;
        }
        if (other.getTaskDefinitionArn() == null ^ this.getTaskDefinitionArn() == null) {
            return false;
        }
        if (other.getTaskDefinitionArn() != null && !other.getTaskDefinitionArn().equals(this.getTaskDefinitionArn())) {
            return false;
        }
        if (other.getContainerInstanceArn() == null ^ this.getContainerInstanceArn() == null) {
            return false;
        }
        if (other.getContainerInstanceArn() != null && !other.getContainerInstanceArn().equals(this.getContainerInstanceArn())) {
            return false;
        }
        if (other.getOverrides() == null ^ this.getOverrides() == null) {
            return false;
        }
        if (other.getOverrides() != null && !other.getOverrides().equals(this.getOverrides())) {
            return false;
        }
        if (other.getLastStatus() == null ^ this.getLastStatus() == null) {
            return false;
        }
        if (other.getLastStatus() != null && !other.getLastStatus().equals(this.getLastStatus())) {
            return false;
        }
        if (other.getDesiredStatus() == null ^ this.getDesiredStatus() == null) {
            return false;
        }
        if (other.getDesiredStatus() != null && !other.getDesiredStatus().equals(this.getDesiredStatus())) {
            return false;
        }
        if (other.getContainers() == null ^ this.getContainers() == null) {
            return false;
        }
        if (other.getContainers() != null && !other.getContainers().equals(this.getContainers())) {
            return false;
        }
        if (other.getStartedBy() == null ^ this.getStartedBy() == null) {
            return false;
        }
        return other.getStartedBy() == null || other.getStartedBy().equals(this.getStartedBy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaskArn() == null ? 0 : this.getTaskArn().hashCode());
        hashCode = 31 * hashCode + (this.getClusterArn() == null ? 0 : this.getClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.getTaskDefinitionArn() == null ? 0 : this.getTaskDefinitionArn().hashCode());
        hashCode = 31 * hashCode + (this.getContainerInstanceArn() == null ? 0 : this.getContainerInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getOverrides() == null ? 0 : this.getOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getLastStatus() == null ? 0 : this.getLastStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredStatus() == null ? 0 : this.getDesiredStatus().hashCode());
        hashCode = 31 * hashCode + (this.getContainers() == null ? 0 : this.getContainers().hashCode());
        hashCode = 31 * hashCode + (this.getStartedBy() == null ? 0 : this.getStartedBy().hashCode());
        return hashCode;
    }

    public Task clone() {
        try {
            return (Task)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

