/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.Attribute;
import com.amazonaws.services.ecs.model.ContainerInstance;
import com.amazonaws.services.ecs.model.Resource;
import com.amazonaws.services.ecs.model.transform.AttributeJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.ResourceJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.VersionInfoJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ContainerInstanceJsonMarshaller {
    private static ContainerInstanceJsonMarshaller instance;

    public void marshall(ContainerInstance containerInstance, JSONWriter jsonWriter) {
        if (containerInstance == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList attributesList;
            SdkInternalList registeredResourcesList;
            SdkInternalList remainingResourcesList;
            jsonWriter.object();
            if (containerInstance.getContainerInstanceArn() != null) {
                jsonWriter.key("containerInstanceArn").value((Object)containerInstance.getContainerInstanceArn());
            }
            if (containerInstance.getEc2InstanceId() != null) {
                jsonWriter.key("ec2InstanceId").value((Object)containerInstance.getEc2InstanceId());
            }
            if (containerInstance.getVersionInfo() != null) {
                jsonWriter.key("versionInfo");
                VersionInfoJsonMarshaller.getInstance().marshall(containerInstance.getVersionInfo(), jsonWriter);
            }
            if (!(remainingResourcesList = (SdkInternalList)containerInstance.getRemainingResources()).isEmpty() || !remainingResourcesList.isAutoConstruct()) {
                jsonWriter.key("remainingResources");
                jsonWriter.array();
                for (Resource remainingResourcesListValue : remainingResourcesList) {
                    if (remainingResourcesListValue == null) continue;
                    ResourceJsonMarshaller.getInstance().marshall(remainingResourcesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(registeredResourcesList = (SdkInternalList)containerInstance.getRegisteredResources()).isEmpty() || !registeredResourcesList.isAutoConstruct()) {
                jsonWriter.key("registeredResources");
                jsonWriter.array();
                for (Resource registeredResourcesListValue : registeredResourcesList) {
                    if (registeredResourcesListValue == null) continue;
                    ResourceJsonMarshaller.getInstance().marshall(registeredResourcesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (containerInstance.getStatus() != null) {
                jsonWriter.key("status").value((Object)containerInstance.getStatus());
            }
            if (containerInstance.getAgentConnected() != null) {
                jsonWriter.key("agentConnected").value((Object)containerInstance.getAgentConnected());
            }
            if (containerInstance.getRunningTasksCount() != null) {
                jsonWriter.key("runningTasksCount").value((Object)containerInstance.getRunningTasksCount());
            }
            if (containerInstance.getPendingTasksCount() != null) {
                jsonWriter.key("pendingTasksCount").value((Object)containerInstance.getPendingTasksCount());
            }
            if (containerInstance.getAgentUpdateStatus() != null) {
                jsonWriter.key("agentUpdateStatus").value((Object)containerInstance.getAgentUpdateStatus());
            }
            if (!(attributesList = (SdkInternalList)containerInstance.getAttributes()).isEmpty() || !attributesList.isAutoConstruct()) {
                jsonWriter.key("attributes");
                jsonWriter.array();
                for (Attribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ContainerInstanceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ContainerInstanceJsonMarshaller();
        }
        return instance;
    }
}

