/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.HostEntry;
import com.amazonaws.services.ecs.model.KeyValuePair;
import com.amazonaws.services.ecs.model.LogConfiguration;
import com.amazonaws.services.ecs.model.MountPoint;
import com.amazonaws.services.ecs.model.PortMapping;
import com.amazonaws.services.ecs.model.Ulimit;
import com.amazonaws.services.ecs.model.VolumeFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainerDefinition
implements Serializable,
Cloneable {
    private String name;
    private String image;
    private Integer cpu;
    private Integer memory;
    private ListWithAutoConstructFlag<String> links;
    private ListWithAutoConstructFlag<PortMapping> portMappings;
    private Boolean essential;
    private ListWithAutoConstructFlag<String> entryPoint;
    private ListWithAutoConstructFlag<String> command;
    private ListWithAutoConstructFlag<KeyValuePair> environment;
    private ListWithAutoConstructFlag<MountPoint> mountPoints;
    private ListWithAutoConstructFlag<VolumeFrom> volumesFrom;
    private String hostname;
    private String user;
    private String workingDirectory;
    private Boolean disableNetworking;
    private Boolean privileged;
    private Boolean readonlyRootFilesystem;
    private ListWithAutoConstructFlag<String> dnsServers;
    private ListWithAutoConstructFlag<String> dnsSearchDomains;
    private ListWithAutoConstructFlag<HostEntry> extraHosts;
    private ListWithAutoConstructFlag<String> dockerSecurityOptions;
    private Map<String, String> dockerLabels;
    private ListWithAutoConstructFlag<Ulimit> ulimits;
    private LogConfiguration logConfiguration;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContainerDefinition withName(String name) {
        this.name = name;
        return this;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public ContainerDefinition withImage(String image) {
        this.image = image;
        return this;
    }

    public Integer getCpu() {
        return this.cpu;
    }

    public void setCpu(Integer cpu) {
        this.cpu = cpu;
    }

    public ContainerDefinition withCpu(Integer cpu) {
        this.cpu = cpu;
        return this;
    }

    public Integer getMemory() {
        return this.memory;
    }

    public void setMemory(Integer memory) {
        this.memory = memory;
    }

    public ContainerDefinition withMemory(Integer memory) {
        this.memory = memory;
        return this;
    }

    public List<String> getLinks() {
        if (this.links == null) {
            this.links = new ListWithAutoConstructFlag();
            this.links.setAutoConstruct(true);
        }
        return this.links;
    }

    public void setLinks(Collection<String> links) {
        if (links == null) {
            this.links = null;
            return;
        }
        ListWithAutoConstructFlag linksCopy = new ListWithAutoConstructFlag(links.size());
        linksCopy.addAll(links);
        this.links = linksCopy;
    }

    public ContainerDefinition withLinks(String ... links) {
        if (this.getLinks() == null) {
            this.setLinks(new ArrayList<String>(links.length));
        }
        for (String value : links) {
            this.getLinks().add(value);
        }
        return this;
    }

    public ContainerDefinition withLinks(Collection<String> links) {
        if (links == null) {
            this.links = null;
        } else {
            ListWithAutoConstructFlag linksCopy = new ListWithAutoConstructFlag(links.size());
            linksCopy.addAll(links);
            this.links = linksCopy;
        }
        return this;
    }

    public List<PortMapping> getPortMappings() {
        if (this.portMappings == null) {
            this.portMappings = new ListWithAutoConstructFlag();
            this.portMappings.setAutoConstruct(true);
        }
        return this.portMappings;
    }

    public void setPortMappings(Collection<PortMapping> portMappings) {
        if (portMappings == null) {
            this.portMappings = null;
            return;
        }
        ListWithAutoConstructFlag portMappingsCopy = new ListWithAutoConstructFlag(portMappings.size());
        portMappingsCopy.addAll(portMappings);
        this.portMappings = portMappingsCopy;
    }

    public ContainerDefinition withPortMappings(PortMapping ... portMappings) {
        if (this.getPortMappings() == null) {
            this.setPortMappings(new ArrayList<PortMapping>(portMappings.length));
        }
        for (PortMapping value : portMappings) {
            this.getPortMappings().add(value);
        }
        return this;
    }

    public ContainerDefinition withPortMappings(Collection<PortMapping> portMappings) {
        if (portMappings == null) {
            this.portMappings = null;
        } else {
            ListWithAutoConstructFlag portMappingsCopy = new ListWithAutoConstructFlag(portMappings.size());
            portMappingsCopy.addAll(portMappings);
            this.portMappings = portMappingsCopy;
        }
        return this;
    }

    public Boolean isEssential() {
        return this.essential;
    }

    public void setEssential(Boolean essential) {
        this.essential = essential;
    }

    public ContainerDefinition withEssential(Boolean essential) {
        this.essential = essential;
        return this;
    }

    public Boolean getEssential() {
        return this.essential;
    }

    public List<String> getEntryPoint() {
        if (this.entryPoint == null) {
            this.entryPoint = new ListWithAutoConstructFlag();
            this.entryPoint.setAutoConstruct(true);
        }
        return this.entryPoint;
    }

    public void setEntryPoint(Collection<String> entryPoint) {
        if (entryPoint == null) {
            this.entryPoint = null;
            return;
        }
        ListWithAutoConstructFlag entryPointCopy = new ListWithAutoConstructFlag(entryPoint.size());
        entryPointCopy.addAll(entryPoint);
        this.entryPoint = entryPointCopy;
    }

    public ContainerDefinition withEntryPoint(String ... entryPoint) {
        if (this.getEntryPoint() == null) {
            this.setEntryPoint(new ArrayList<String>(entryPoint.length));
        }
        for (String value : entryPoint) {
            this.getEntryPoint().add(value);
        }
        return this;
    }

    public ContainerDefinition withEntryPoint(Collection<String> entryPoint) {
        if (entryPoint == null) {
            this.entryPoint = null;
        } else {
            ListWithAutoConstructFlag entryPointCopy = new ListWithAutoConstructFlag(entryPoint.size());
            entryPointCopy.addAll(entryPoint);
            this.entryPoint = entryPointCopy;
        }
        return this;
    }

    public List<String> getCommand() {
        if (this.command == null) {
            this.command = new ListWithAutoConstructFlag();
            this.command.setAutoConstruct(true);
        }
        return this.command;
    }

    public void setCommand(Collection<String> command) {
        if (command == null) {
            this.command = null;
            return;
        }
        ListWithAutoConstructFlag commandCopy = new ListWithAutoConstructFlag(command.size());
        commandCopy.addAll(command);
        this.command = commandCopy;
    }

    public ContainerDefinition withCommand(String ... command) {
        if (this.getCommand() == null) {
            this.setCommand(new ArrayList<String>(command.length));
        }
        for (String value : command) {
            this.getCommand().add(value);
        }
        return this;
    }

    public ContainerDefinition withCommand(Collection<String> command) {
        if (command == null) {
            this.command = null;
        } else {
            ListWithAutoConstructFlag commandCopy = new ListWithAutoConstructFlag(command.size());
            commandCopy.addAll(command);
            this.command = commandCopy;
        }
        return this;
    }

    public List<KeyValuePair> getEnvironment() {
        if (this.environment == null) {
            this.environment = new ListWithAutoConstructFlag();
            this.environment.setAutoConstruct(true);
        }
        return this.environment;
    }

    public void setEnvironment(Collection<KeyValuePair> environment) {
        if (environment == null) {
            this.environment = null;
            return;
        }
        ListWithAutoConstructFlag environmentCopy = new ListWithAutoConstructFlag(environment.size());
        environmentCopy.addAll(environment);
        this.environment = environmentCopy;
    }

    public ContainerDefinition withEnvironment(KeyValuePair ... environment) {
        if (this.getEnvironment() == null) {
            this.setEnvironment(new ArrayList<KeyValuePair>(environment.length));
        }
        for (KeyValuePair value : environment) {
            this.getEnvironment().add(value);
        }
        return this;
    }

    public ContainerDefinition withEnvironment(Collection<KeyValuePair> environment) {
        if (environment == null) {
            this.environment = null;
        } else {
            ListWithAutoConstructFlag environmentCopy = new ListWithAutoConstructFlag(environment.size());
            environmentCopy.addAll(environment);
            this.environment = environmentCopy;
        }
        return this;
    }

    public List<MountPoint> getMountPoints() {
        if (this.mountPoints == null) {
            this.mountPoints = new ListWithAutoConstructFlag();
            this.mountPoints.setAutoConstruct(true);
        }
        return this.mountPoints;
    }

    public void setMountPoints(Collection<MountPoint> mountPoints) {
        if (mountPoints == null) {
            this.mountPoints = null;
            return;
        }
        ListWithAutoConstructFlag mountPointsCopy = new ListWithAutoConstructFlag(mountPoints.size());
        mountPointsCopy.addAll(mountPoints);
        this.mountPoints = mountPointsCopy;
    }

    public ContainerDefinition withMountPoints(MountPoint ... mountPoints) {
        if (this.getMountPoints() == null) {
            this.setMountPoints(new ArrayList<MountPoint>(mountPoints.length));
        }
        for (MountPoint value : mountPoints) {
            this.getMountPoints().add(value);
        }
        return this;
    }

    public ContainerDefinition withMountPoints(Collection<MountPoint> mountPoints) {
        if (mountPoints == null) {
            this.mountPoints = null;
        } else {
            ListWithAutoConstructFlag mountPointsCopy = new ListWithAutoConstructFlag(mountPoints.size());
            mountPointsCopy.addAll(mountPoints);
            this.mountPoints = mountPointsCopy;
        }
        return this;
    }

    public List<VolumeFrom> getVolumesFrom() {
        if (this.volumesFrom == null) {
            this.volumesFrom = new ListWithAutoConstructFlag();
            this.volumesFrom.setAutoConstruct(true);
        }
        return this.volumesFrom;
    }

    public void setVolumesFrom(Collection<VolumeFrom> volumesFrom) {
        if (volumesFrom == null) {
            this.volumesFrom = null;
            return;
        }
        ListWithAutoConstructFlag volumesFromCopy = new ListWithAutoConstructFlag(volumesFrom.size());
        volumesFromCopy.addAll(volumesFrom);
        this.volumesFrom = volumesFromCopy;
    }

    public ContainerDefinition withVolumesFrom(VolumeFrom ... volumesFrom) {
        if (this.getVolumesFrom() == null) {
            this.setVolumesFrom(new ArrayList<VolumeFrom>(volumesFrom.length));
        }
        for (VolumeFrom value : volumesFrom) {
            this.getVolumesFrom().add(value);
        }
        return this;
    }

    public ContainerDefinition withVolumesFrom(Collection<VolumeFrom> volumesFrom) {
        if (volumesFrom == null) {
            this.volumesFrom = null;
        } else {
            ListWithAutoConstructFlag volumesFromCopy = new ListWithAutoConstructFlag(volumesFrom.size());
            volumesFromCopy.addAll(volumesFrom);
            this.volumesFrom = volumesFromCopy;
        }
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public ContainerDefinition withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public ContainerDefinition withUser(String user) {
        this.user = user;
        return this;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public ContainerDefinition withWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public Boolean isDisableNetworking() {
        return this.disableNetworking;
    }

    public void setDisableNetworking(Boolean disableNetworking) {
        this.disableNetworking = disableNetworking;
    }

    public ContainerDefinition withDisableNetworking(Boolean disableNetworking) {
        this.disableNetworking = disableNetworking;
        return this;
    }

    public Boolean getDisableNetworking() {
        return this.disableNetworking;
    }

    public Boolean isPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    public ContainerDefinition withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public Boolean isReadonlyRootFilesystem() {
        return this.readonlyRootFilesystem;
    }

    public void setReadonlyRootFilesystem(Boolean readonlyRootFilesystem) {
        this.readonlyRootFilesystem = readonlyRootFilesystem;
    }

    public ContainerDefinition withReadonlyRootFilesystem(Boolean readonlyRootFilesystem) {
        this.readonlyRootFilesystem = readonlyRootFilesystem;
        return this;
    }

    public Boolean getReadonlyRootFilesystem() {
        return this.readonlyRootFilesystem;
    }

    public List<String> getDnsServers() {
        if (this.dnsServers == null) {
            this.dnsServers = new ListWithAutoConstructFlag();
            this.dnsServers.setAutoConstruct(true);
        }
        return this.dnsServers;
    }

    public void setDnsServers(Collection<String> dnsServers) {
        if (dnsServers == null) {
            this.dnsServers = null;
            return;
        }
        ListWithAutoConstructFlag dnsServersCopy = new ListWithAutoConstructFlag(dnsServers.size());
        dnsServersCopy.addAll(dnsServers);
        this.dnsServers = dnsServersCopy;
    }

    public ContainerDefinition withDnsServers(String ... dnsServers) {
        if (this.getDnsServers() == null) {
            this.setDnsServers(new ArrayList<String>(dnsServers.length));
        }
        for (String value : dnsServers) {
            this.getDnsServers().add(value);
        }
        return this;
    }

    public ContainerDefinition withDnsServers(Collection<String> dnsServers) {
        if (dnsServers == null) {
            this.dnsServers = null;
        } else {
            ListWithAutoConstructFlag dnsServersCopy = new ListWithAutoConstructFlag(dnsServers.size());
            dnsServersCopy.addAll(dnsServers);
            this.dnsServers = dnsServersCopy;
        }
        return this;
    }

    public List<String> getDnsSearchDomains() {
        if (this.dnsSearchDomains == null) {
            this.dnsSearchDomains = new ListWithAutoConstructFlag();
            this.dnsSearchDomains.setAutoConstruct(true);
        }
        return this.dnsSearchDomains;
    }

    public void setDnsSearchDomains(Collection<String> dnsSearchDomains) {
        if (dnsSearchDomains == null) {
            this.dnsSearchDomains = null;
            return;
        }
        ListWithAutoConstructFlag dnsSearchDomainsCopy = new ListWithAutoConstructFlag(dnsSearchDomains.size());
        dnsSearchDomainsCopy.addAll(dnsSearchDomains);
        this.dnsSearchDomains = dnsSearchDomainsCopy;
    }

    public ContainerDefinition withDnsSearchDomains(String ... dnsSearchDomains) {
        if (this.getDnsSearchDomains() == null) {
            this.setDnsSearchDomains(new ArrayList<String>(dnsSearchDomains.length));
        }
        for (String value : dnsSearchDomains) {
            this.getDnsSearchDomains().add(value);
        }
        return this;
    }

    public ContainerDefinition withDnsSearchDomains(Collection<String> dnsSearchDomains) {
        if (dnsSearchDomains == null) {
            this.dnsSearchDomains = null;
        } else {
            ListWithAutoConstructFlag dnsSearchDomainsCopy = new ListWithAutoConstructFlag(dnsSearchDomains.size());
            dnsSearchDomainsCopy.addAll(dnsSearchDomains);
            this.dnsSearchDomains = dnsSearchDomainsCopy;
        }
        return this;
    }

    public List<HostEntry> getExtraHosts() {
        if (this.extraHosts == null) {
            this.extraHosts = new ListWithAutoConstructFlag();
            this.extraHosts.setAutoConstruct(true);
        }
        return this.extraHosts;
    }

    public void setExtraHosts(Collection<HostEntry> extraHosts) {
        if (extraHosts == null) {
            this.extraHosts = null;
            return;
        }
        ListWithAutoConstructFlag extraHostsCopy = new ListWithAutoConstructFlag(extraHosts.size());
        extraHostsCopy.addAll(extraHosts);
        this.extraHosts = extraHostsCopy;
    }

    public ContainerDefinition withExtraHosts(HostEntry ... extraHosts) {
        if (this.getExtraHosts() == null) {
            this.setExtraHosts(new ArrayList<HostEntry>(extraHosts.length));
        }
        for (HostEntry value : extraHosts) {
            this.getExtraHosts().add(value);
        }
        return this;
    }

    public ContainerDefinition withExtraHosts(Collection<HostEntry> extraHosts) {
        if (extraHosts == null) {
            this.extraHosts = null;
        } else {
            ListWithAutoConstructFlag extraHostsCopy = new ListWithAutoConstructFlag(extraHosts.size());
            extraHostsCopy.addAll(extraHosts);
            this.extraHosts = extraHostsCopy;
        }
        return this;
    }

    public List<String> getDockerSecurityOptions() {
        if (this.dockerSecurityOptions == null) {
            this.dockerSecurityOptions = new ListWithAutoConstructFlag();
            this.dockerSecurityOptions.setAutoConstruct(true);
        }
        return this.dockerSecurityOptions;
    }

    public void setDockerSecurityOptions(Collection<String> dockerSecurityOptions) {
        if (dockerSecurityOptions == null) {
            this.dockerSecurityOptions = null;
            return;
        }
        ListWithAutoConstructFlag dockerSecurityOptionsCopy = new ListWithAutoConstructFlag(dockerSecurityOptions.size());
        dockerSecurityOptionsCopy.addAll(dockerSecurityOptions);
        this.dockerSecurityOptions = dockerSecurityOptionsCopy;
    }

    public ContainerDefinition withDockerSecurityOptions(String ... dockerSecurityOptions) {
        if (this.getDockerSecurityOptions() == null) {
            this.setDockerSecurityOptions(new ArrayList<String>(dockerSecurityOptions.length));
        }
        for (String value : dockerSecurityOptions) {
            this.getDockerSecurityOptions().add(value);
        }
        return this;
    }

    public ContainerDefinition withDockerSecurityOptions(Collection<String> dockerSecurityOptions) {
        if (dockerSecurityOptions == null) {
            this.dockerSecurityOptions = null;
        } else {
            ListWithAutoConstructFlag dockerSecurityOptionsCopy = new ListWithAutoConstructFlag(dockerSecurityOptions.size());
            dockerSecurityOptionsCopy.addAll(dockerSecurityOptions);
            this.dockerSecurityOptions = dockerSecurityOptionsCopy;
        }
        return this;
    }

    public Map<String, String> getDockerLabels() {
        if (this.dockerLabels == null) {
            this.dockerLabels = new HashMap<String, String>();
        }
        return this.dockerLabels;
    }

    public void setDockerLabels(Map<String, String> dockerLabels) {
        this.dockerLabels = dockerLabels;
    }

    public ContainerDefinition withDockerLabels(Map<String, String> dockerLabels) {
        this.setDockerLabels(dockerLabels);
        return this;
    }

    public ContainerDefinition addDockerLabelsEntry(String key, String value) {
        if (null == this.dockerLabels) {
            this.dockerLabels = new HashMap<String, String>();
        }
        if (this.dockerLabels.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.dockerLabels.put(key, value);
        return this;
    }

    public ContainerDefinition clearDockerLabelsEntries() {
        this.dockerLabels = null;
        return this;
    }

    public List<Ulimit> getUlimits() {
        if (this.ulimits == null) {
            this.ulimits = new ListWithAutoConstructFlag();
            this.ulimits.setAutoConstruct(true);
        }
        return this.ulimits;
    }

    public void setUlimits(Collection<Ulimit> ulimits) {
        if (ulimits == null) {
            this.ulimits = null;
            return;
        }
        ListWithAutoConstructFlag ulimitsCopy = new ListWithAutoConstructFlag(ulimits.size());
        ulimitsCopy.addAll(ulimits);
        this.ulimits = ulimitsCopy;
    }

    public ContainerDefinition withUlimits(Ulimit ... ulimits) {
        if (this.getUlimits() == null) {
            this.setUlimits(new ArrayList<Ulimit>(ulimits.length));
        }
        for (Ulimit value : ulimits) {
            this.getUlimits().add(value);
        }
        return this;
    }

    public ContainerDefinition withUlimits(Collection<Ulimit> ulimits) {
        if (ulimits == null) {
            this.ulimits = null;
        } else {
            ListWithAutoConstructFlag ulimitsCopy = new ListWithAutoConstructFlag(ulimits.size());
            ulimitsCopy.addAll(ulimits);
            this.ulimits = ulimitsCopy;
        }
        return this;
    }

    public LogConfiguration getLogConfiguration() {
        return this.logConfiguration;
    }

    public void setLogConfiguration(LogConfiguration logConfiguration) {
        this.logConfiguration = logConfiguration;
    }

    public ContainerDefinition withLogConfiguration(LogConfiguration logConfiguration) {
        this.logConfiguration = logConfiguration;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getImage() != null) {
            sb.append("Image: " + this.getImage() + ",");
        }
        if (this.getCpu() != null) {
            sb.append("Cpu: " + this.getCpu() + ",");
        }
        if (this.getMemory() != null) {
            sb.append("Memory: " + this.getMemory() + ",");
        }
        if (this.getLinks() != null) {
            sb.append("Links: " + this.getLinks() + ",");
        }
        if (this.getPortMappings() != null) {
            sb.append("PortMappings: " + this.getPortMappings() + ",");
        }
        if (this.isEssential() != null) {
            sb.append("Essential: " + this.isEssential() + ",");
        }
        if (this.getEntryPoint() != null) {
            sb.append("EntryPoint: " + this.getEntryPoint() + ",");
        }
        if (this.getCommand() != null) {
            sb.append("Command: " + this.getCommand() + ",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: " + this.getEnvironment() + ",");
        }
        if (this.getMountPoints() != null) {
            sb.append("MountPoints: " + this.getMountPoints() + ",");
        }
        if (this.getVolumesFrom() != null) {
            sb.append("VolumesFrom: " + this.getVolumesFrom() + ",");
        }
        if (this.getHostname() != null) {
            sb.append("Hostname: " + this.getHostname() + ",");
        }
        if (this.getUser() != null) {
            sb.append("User: " + this.getUser() + ",");
        }
        if (this.getWorkingDirectory() != null) {
            sb.append("WorkingDirectory: " + this.getWorkingDirectory() + ",");
        }
        if (this.isDisableNetworking() != null) {
            sb.append("DisableNetworking: " + this.isDisableNetworking() + ",");
        }
        if (this.isPrivileged() != null) {
            sb.append("Privileged: " + this.isPrivileged() + ",");
        }
        if (this.isReadonlyRootFilesystem() != null) {
            sb.append("ReadonlyRootFilesystem: " + this.isReadonlyRootFilesystem() + ",");
        }
        if (this.getDnsServers() != null) {
            sb.append("DnsServers: " + this.getDnsServers() + ",");
        }
        if (this.getDnsSearchDomains() != null) {
            sb.append("DnsSearchDomains: " + this.getDnsSearchDomains() + ",");
        }
        if (this.getExtraHosts() != null) {
            sb.append("ExtraHosts: " + this.getExtraHosts() + ",");
        }
        if (this.getDockerSecurityOptions() != null) {
            sb.append("DockerSecurityOptions: " + this.getDockerSecurityOptions() + ",");
        }
        if (this.getDockerLabels() != null) {
            sb.append("DockerLabels: " + this.getDockerLabels() + ",");
        }
        if (this.getUlimits() != null) {
            sb.append("Ulimits: " + this.getUlimits() + ",");
        }
        if (this.getLogConfiguration() != null) {
            sb.append("LogConfiguration: " + this.getLogConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getCpu() == null ? 0 : this.getCpu().hashCode());
        hashCode = 31 * hashCode + (this.getMemory() == null ? 0 : this.getMemory().hashCode());
        hashCode = 31 * hashCode + (this.getLinks() == null ? 0 : this.getLinks().hashCode());
        hashCode = 31 * hashCode + (this.getPortMappings() == null ? 0 : this.getPortMappings().hashCode());
        hashCode = 31 * hashCode + (this.isEssential() == null ? 0 : this.isEssential().hashCode());
        hashCode = 31 * hashCode + (this.getEntryPoint() == null ? 0 : this.getEntryPoint().hashCode());
        hashCode = 31 * hashCode + (this.getCommand() == null ? 0 : this.getCommand().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getMountPoints() == null ? 0 : this.getMountPoints().hashCode());
        hashCode = 31 * hashCode + (this.getVolumesFrom() == null ? 0 : this.getVolumesFrom().hashCode());
        hashCode = 31 * hashCode + (this.getHostname() == null ? 0 : this.getHostname().hashCode());
        hashCode = 31 * hashCode + (this.getUser() == null ? 0 : this.getUser().hashCode());
        hashCode = 31 * hashCode + (this.getWorkingDirectory() == null ? 0 : this.getWorkingDirectory().hashCode());
        hashCode = 31 * hashCode + (this.isDisableNetworking() == null ? 0 : this.isDisableNetworking().hashCode());
        hashCode = 31 * hashCode + (this.isPrivileged() == null ? 0 : this.isPrivileged().hashCode());
        hashCode = 31 * hashCode + (this.isReadonlyRootFilesystem() == null ? 0 : this.isReadonlyRootFilesystem().hashCode());
        hashCode = 31 * hashCode + (this.getDnsServers() == null ? 0 : this.getDnsServers().hashCode());
        hashCode = 31 * hashCode + (this.getDnsSearchDomains() == null ? 0 : this.getDnsSearchDomains().hashCode());
        hashCode = 31 * hashCode + (this.getExtraHosts() == null ? 0 : this.getExtraHosts().hashCode());
        hashCode = 31 * hashCode + (this.getDockerSecurityOptions() == null ? 0 : this.getDockerSecurityOptions().hashCode());
        hashCode = 31 * hashCode + (this.getDockerLabels() == null ? 0 : this.getDockerLabels().hashCode());
        hashCode = 31 * hashCode + (this.getUlimits() == null ? 0 : this.getUlimits().hashCode());
        hashCode = 31 * hashCode + (this.getLogConfiguration() == null ? 0 : this.getLogConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDefinition)) {
            return false;
        }
        ContainerDefinition other = (ContainerDefinition)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getCpu() == null ^ this.getCpu() == null) {
            return false;
        }
        if (other.getCpu() != null && !other.getCpu().equals(this.getCpu())) {
            return false;
        }
        if (other.getMemory() == null ^ this.getMemory() == null) {
            return false;
        }
        if (other.getMemory() != null && !other.getMemory().equals(this.getMemory())) {
            return false;
        }
        if (other.getLinks() == null ^ this.getLinks() == null) {
            return false;
        }
        if (other.getLinks() != null && !other.getLinks().equals(this.getLinks())) {
            return false;
        }
        if (other.getPortMappings() == null ^ this.getPortMappings() == null) {
            return false;
        }
        if (other.getPortMappings() != null && !other.getPortMappings().equals(this.getPortMappings())) {
            return false;
        }
        if (other.isEssential() == null ^ this.isEssential() == null) {
            return false;
        }
        if (other.isEssential() != null && !other.isEssential().equals(this.isEssential())) {
            return false;
        }
        if (other.getEntryPoint() == null ^ this.getEntryPoint() == null) {
            return false;
        }
        if (other.getEntryPoint() != null && !other.getEntryPoint().equals(this.getEntryPoint())) {
            return false;
        }
        if (other.getCommand() == null ^ this.getCommand() == null) {
            return false;
        }
        if (other.getCommand() != null && !other.getCommand().equals(this.getCommand())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getMountPoints() == null ^ this.getMountPoints() == null) {
            return false;
        }
        if (other.getMountPoints() != null && !other.getMountPoints().equals(this.getMountPoints())) {
            return false;
        }
        if (other.getVolumesFrom() == null ^ this.getVolumesFrom() == null) {
            return false;
        }
        if (other.getVolumesFrom() != null && !other.getVolumesFrom().equals(this.getVolumesFrom())) {
            return false;
        }
        if (other.getHostname() == null ^ this.getHostname() == null) {
            return false;
        }
        if (other.getHostname() != null && !other.getHostname().equals(this.getHostname())) {
            return false;
        }
        if (other.getUser() == null ^ this.getUser() == null) {
            return false;
        }
        if (other.getUser() != null && !other.getUser().equals(this.getUser())) {
            return false;
        }
        if (other.getWorkingDirectory() == null ^ this.getWorkingDirectory() == null) {
            return false;
        }
        if (other.getWorkingDirectory() != null && !other.getWorkingDirectory().equals(this.getWorkingDirectory())) {
            return false;
        }
        if (other.isDisableNetworking() == null ^ this.isDisableNetworking() == null) {
            return false;
        }
        if (other.isDisableNetworking() != null && !other.isDisableNetworking().equals(this.isDisableNetworking())) {
            return false;
        }
        if (other.isPrivileged() == null ^ this.isPrivileged() == null) {
            return false;
        }
        if (other.isPrivileged() != null && !other.isPrivileged().equals(this.isPrivileged())) {
            return false;
        }
        if (other.isReadonlyRootFilesystem() == null ^ this.isReadonlyRootFilesystem() == null) {
            return false;
        }
        if (other.isReadonlyRootFilesystem() != null && !other.isReadonlyRootFilesystem().equals(this.isReadonlyRootFilesystem())) {
            return false;
        }
        if (other.getDnsServers() == null ^ this.getDnsServers() == null) {
            return false;
        }
        if (other.getDnsServers() != null && !other.getDnsServers().equals(this.getDnsServers())) {
            return false;
        }
        if (other.getDnsSearchDomains() == null ^ this.getDnsSearchDomains() == null) {
            return false;
        }
        if (other.getDnsSearchDomains() != null && !other.getDnsSearchDomains().equals(this.getDnsSearchDomains())) {
            return false;
        }
        if (other.getExtraHosts() == null ^ this.getExtraHosts() == null) {
            return false;
        }
        if (other.getExtraHosts() != null && !other.getExtraHosts().equals(this.getExtraHosts())) {
            return false;
        }
        if (other.getDockerSecurityOptions() == null ^ this.getDockerSecurityOptions() == null) {
            return false;
        }
        if (other.getDockerSecurityOptions() != null && !other.getDockerSecurityOptions().equals(this.getDockerSecurityOptions())) {
            return false;
        }
        if (other.getDockerLabels() == null ^ this.getDockerLabels() == null) {
            return false;
        }
        if (other.getDockerLabels() != null && !other.getDockerLabels().equals(this.getDockerLabels())) {
            return false;
        }
        if (other.getUlimits() == null ^ this.getUlimits() == null) {
            return false;
        }
        if (other.getUlimits() != null && !other.getUlimits().equals(this.getUlimits())) {
            return false;
        }
        if (other.getLogConfiguration() == null ^ this.getLogConfiguration() == null) {
            return false;
        }
        return other.getLogConfiguration() == null || other.getLogConfiguration().equals(this.getLogConfiguration());
    }

    public ContainerDefinition clone() {
        try {
            return (ContainerDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

