/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecr.model.ReplicationDestination;
import com.amazonaws.services.ecr.model.RepositoryFilter;
import com.amazonaws.services.ecr.model.transform.ReplicationRuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReplicationRule
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ReplicationDestination> destinations;
    private List<RepositoryFilter> repositoryFilters;

    public List<ReplicationDestination> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<ReplicationDestination> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<ReplicationDestination>(destinations);
    }

    public ReplicationRule withDestinations(ReplicationDestination ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<ReplicationDestination>(destinations.length));
        }
        for (ReplicationDestination ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public ReplicationRule withDestinations(Collection<ReplicationDestination> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public List<RepositoryFilter> getRepositoryFilters() {
        return this.repositoryFilters;
    }

    public void setRepositoryFilters(Collection<RepositoryFilter> repositoryFilters) {
        if (repositoryFilters == null) {
            this.repositoryFilters = null;
            return;
        }
        this.repositoryFilters = new ArrayList<RepositoryFilter>(repositoryFilters);
    }

    public ReplicationRule withRepositoryFilters(RepositoryFilter ... repositoryFilters) {
        if (this.repositoryFilters == null) {
            this.setRepositoryFilters(new ArrayList<RepositoryFilter>(repositoryFilters.length));
        }
        for (RepositoryFilter ele : repositoryFilters) {
            this.repositoryFilters.add(ele);
        }
        return this;
    }

    public ReplicationRule withRepositoryFilters(Collection<RepositoryFilter> repositoryFilters) {
        this.setRepositoryFilters(repositoryFilters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getRepositoryFilters() != null) {
            sb.append("RepositoryFilters: ").append(this.getRepositoryFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationRule)) {
            return false;
        }
        ReplicationRule other = (ReplicationRule)obj;
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getRepositoryFilters() == null ^ this.getRepositoryFilters() == null) {
            return false;
        }
        return other.getRepositoryFilters() == null || other.getRepositoryFilters().equals(this.getRepositoryFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getRepositoryFilters() == null ? 0 : this.getRepositoryFilters().hashCode());
        return hashCode;
    }

    public ReplicationRule clone() {
        try {
            return (ReplicationRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicationRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

