/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.LaunchPermission;
import com.amazonaws.services.ec2.model.LaunchPermissionModifications;
import com.amazonaws.services.ec2.model.ModifyImageAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyImageAttributeRequestMarshaller
implements Marshaller<Request<ModifyImageAttributeRequest>, ModifyImageAttributeRequest> {
    public Request<ModifyImageAttributeRequest> marshall(ModifyImageAttributeRequest modifyImageAttributeRequest) {
        LaunchPermissionModifications launchPermissionModificationsLaunchPermission;
        if (modifyImageAttributeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyImageAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyImageAttribute");
        request.addParameter("Version", "2015-04-15");
        if (modifyImageAttributeRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)modifyImageAttributeRequest.getImageId()));
        }
        if (modifyImageAttributeRequest.getAttribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)modifyImageAttributeRequest.getAttribute()));
        }
        if (modifyImageAttributeRequest.getOperationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString((String)modifyImageAttributeRequest.getOperationType()));
        }
        List<String> userIdsList = modifyImageAttributeRequest.getUserIds();
        int userIdsListIndex = 1;
        for (String userIdsListValue : userIdsList) {
            if (userIdsListValue != null) {
                request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString((String)userIdsListValue));
            }
            ++userIdsListIndex;
        }
        List<String> userGroupsList = modifyImageAttributeRequest.getUserGroups();
        int userGroupsListIndex = 1;
        for (String userGroupsListValue : userGroupsList) {
            if (userGroupsListValue != null) {
                request.addParameter("UserGroup." + userGroupsListIndex, StringUtils.fromString((String)userGroupsListValue));
            }
            ++userGroupsListIndex;
        }
        List<String> productCodesList = modifyImageAttributeRequest.getProductCodes();
        int productCodesListIndex = 1;
        for (String productCodesListValue : productCodesList) {
            if (productCodesListValue != null) {
                request.addParameter("ProductCode." + productCodesListIndex, StringUtils.fromString((String)productCodesListValue));
            }
            ++productCodesListIndex;
        }
        if (modifyImageAttributeRequest.getValue() != null) {
            request.addParameter("Value", StringUtils.fromString((String)modifyImageAttributeRequest.getValue()));
        }
        if ((launchPermissionModificationsLaunchPermission = modifyImageAttributeRequest.getLaunchPermission()) != null) {
            List<LaunchPermission> addList = launchPermissionModificationsLaunchPermission.getAdd();
            int addListIndex = 1;
            for (LaunchPermission addListValue : addList) {
                LaunchPermission launchPermissionMember = addListValue;
                if (launchPermissionMember != null) {
                    if (launchPermissionMember.getUserId() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".UserId", StringUtils.fromString((String)launchPermissionMember.getUserId()));
                    }
                    if (launchPermissionMember.getGroup() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".Group", StringUtils.fromString((String)launchPermissionMember.getGroup()));
                    }
                }
                ++addListIndex;
            }
            List<LaunchPermission> removeList = launchPermissionModificationsLaunchPermission.getRemove();
            int removeListIndex = 1;
            for (LaunchPermission removeListValue : removeList) {
                LaunchPermission launchPermissionMember = removeListValue;
                if (launchPermissionMember != null) {
                    if (launchPermissionMember.getUserId() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString((String)launchPermissionMember.getUserId()));
                    }
                    if (launchPermissionMember.getGroup() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".Group", StringUtils.fromString((String)launchPermissionMember.getGroup()));
                    }
                }
                ++removeListIndex;
            }
        }
        if (modifyImageAttributeRequest.getDescription() != null) {
            request.addParameter("Description.Value", StringUtils.fromString((String)modifyImageAttributeRequest.getDescription()));
        }
        return request;
    }
}

