/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.ec2.model.DescribeSpotFleetRequestHistoryRequest;
import com.amazonaws.services.ec2.model.RequestSpotFleetRequest;
import java.util.Map;
import java.util.regex.Pattern;

public final class TimestampFormatRequestHandler
extends RequestHandler2 {
    private static final Pattern PATTERN = Pattern.compile("\\.\\d\\d\\dZ");
    private static final String START_TIME = "StartTime";
    private static final String VALID_FROM = "SpotFleetRequestConfig.ValidFrom";
    private static final String VALID_UNTIL = "SpotFleetRequestConfig.ValidUntil";

    public void beforeRequest(Request<?> request) {
        AmazonWebServiceRequest original = request.getOriginalRequest();
        if (original instanceof DescribeSpotFleetRequestHistoryRequest) {
            Map params = request.getParameters();
            String startTime = (String)params.get(START_TIME);
            if (startTime != null) {
                params.put(START_TIME, this.sanitize(startTime));
            }
        } else if (original instanceof RequestSpotFleetRequest) {
            Map params = request.getParameters();
            String validFrom = (String)params.get(VALID_FROM);
            String validUntil = (String)params.get(VALID_UNTIL);
            if (validFrom != null) {
                params.put(VALID_FROM, this.sanitize(validFrom));
            }
            if (validUntil != null) {
                params.put(VALID_UNTIL, this.sanitize(validUntil));
            }
        }
    }

    private String sanitize(String input) {
        return PATTERN.matcher(input).replaceFirst("Z");
    }

    public void afterResponse(Request<?> request, Response<?> response) {
    }

    public void afterError(Request<?> request, Response<?> response, Exception e) {
    }
}

