/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.LaunchSpecification;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.RequestSpotInstancesRequest;
import com.amazonaws.services.ec2.model.SpotPlacement;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.List;

public class RequestSpotInstancesRequestMarshaller
implements Marshaller<Request<RequestSpotInstancesRequest>, RequestSpotInstancesRequest> {
    public Request<RequestSpotInstancesRequest> marshall(RequestSpotInstancesRequest requestSpotInstancesRequest) {
        LaunchSpecification launchSpecificationLaunchSpecification;
        if (requestSpotInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)requestSpotInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "RequestSpotInstances");
        request.addParameter("Version", "2014-10-01");
        if (requestSpotInstancesRequest.getSpotPrice() != null) {
            request.addParameter("SpotPrice", StringUtils.fromString((String)requestSpotInstancesRequest.getSpotPrice()));
        }
        if (requestSpotInstancesRequest.getInstanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger((Integer)requestSpotInstancesRequest.getInstanceCount()));
        }
        if (requestSpotInstancesRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString((String)requestSpotInstancesRequest.getType()));
        }
        if (requestSpotInstancesRequest.getValidFrom() != null) {
            request.addParameter("ValidFrom", StringUtils.fromDate((Date)requestSpotInstancesRequest.getValidFrom()));
        }
        if (requestSpotInstancesRequest.getValidUntil() != null) {
            request.addParameter("ValidUntil", StringUtils.fromDate((Date)requestSpotInstancesRequest.getValidUntil()));
        }
        if (requestSpotInstancesRequest.getLaunchGroup() != null) {
            request.addParameter("LaunchGroup", StringUtils.fromString((String)requestSpotInstancesRequest.getLaunchGroup()));
        }
        if (requestSpotInstancesRequest.getAvailabilityZoneGroup() != null) {
            request.addParameter("AvailabilityZoneGroup", StringUtils.fromString((String)requestSpotInstancesRequest.getAvailabilityZoneGroup()));
        }
        if ((launchSpecificationLaunchSpecification = requestSpotInstancesRequest.getLaunchSpecification()) != null) {
            SpotPlacement spotPlacementPlacement;
            if (launchSpecificationLaunchSpecification.getImageId() != null) {
                request.addParameter("LaunchSpecification.ImageId", StringUtils.fromString((String)launchSpecificationLaunchSpecification.getImageId()));
            }
            if (launchSpecificationLaunchSpecification.getKeyName() != null) {
                request.addParameter("LaunchSpecification.KeyName", StringUtils.fromString((String)launchSpecificationLaunchSpecification.getKeyName()));
            }
            List<GroupIdentifier> allSecurityGroupsList = launchSpecificationLaunchSpecification.getAllSecurityGroups();
            int allSecurityGroupsListIndex = 1;
            for (GroupIdentifier allSecurityGroupsListValue : allSecurityGroupsList) {
                GroupIdentifier groupIdentifierMember = allSecurityGroupsListValue;
                if (groupIdentifierMember != null) {
                    if (groupIdentifierMember.getGroupName() != null) {
                        request.addParameter("LaunchSpecification.GroupSet." + allSecurityGroupsListIndex + ".GroupName", StringUtils.fromString((String)groupIdentifierMember.getGroupName()));
                    }
                    if (groupIdentifierMember.getGroupId() != null) {
                        request.addParameter("LaunchSpecification.GroupSet." + allSecurityGroupsListIndex + ".GroupId", StringUtils.fromString((String)groupIdentifierMember.getGroupId()));
                    }
                }
                ++allSecurityGroupsListIndex;
            }
            List<String> securityGroupsList = launchSpecificationLaunchSpecification.getSecurityGroups();
            int securityGroupsListIndex = 1;
            for (String securityGroupsListValue : securityGroupsList) {
                if (securityGroupsListValue != null) {
                    request.addParameter("LaunchSpecification.SecurityGroup." + securityGroupsListIndex, StringUtils.fromString((String)securityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
            if (launchSpecificationLaunchSpecification.getUserData() != null) {
                request.addParameter("LaunchSpecification.UserData", StringUtils.fromString((String)launchSpecificationLaunchSpecification.getUserData()));
            }
            if (launchSpecificationLaunchSpecification.getAddressingType() != null) {
                request.addParameter("LaunchSpecification.AddressingType", StringUtils.fromString((String)launchSpecificationLaunchSpecification.getAddressingType()));
            }
            if (launchSpecificationLaunchSpecification.getInstanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringUtils.fromString((String)launchSpecificationLaunchSpecification.getInstanceType()));
            }
            if ((spotPlacementPlacement = launchSpecificationLaunchSpecification.getPlacement()) != null) {
                if (spotPlacementPlacement.getAvailabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringUtils.fromString((String)spotPlacementPlacement.getAvailabilityZone()));
                }
                if (spotPlacementPlacement.getGroupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString((String)spotPlacementPlacement.getGroupName()));
                }
            }
            if (launchSpecificationLaunchSpecification.getKernelId() != null) {
                request.addParameter("LaunchSpecification.KernelId", StringUtils.fromString((String)launchSpecificationLaunchSpecification.getKernelId()));
            }
            if (launchSpecificationLaunchSpecification.getRamdiskId() != null) {
                request.addParameter("LaunchSpecification.RamdiskId", StringUtils.fromString((String)launchSpecificationLaunchSpecification.getRamdiskId()));
            }
            List<BlockDeviceMapping> blockDeviceMappingsList = launchSpecificationLaunchSpecification.getBlockDeviceMappings();
            int blockDeviceMappingsListIndex = 1;
            for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
                BlockDeviceMapping blockDeviceMappingMember = blockDeviceMappingsListValue;
                if (blockDeviceMappingMember != null) {
                    EbsBlockDevice ebsBlockDeviceEbs;
                    if (blockDeviceMappingMember.getVirtualName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)blockDeviceMappingMember.getVirtualName()));
                    }
                    if (blockDeviceMappingMember.getDeviceName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)blockDeviceMappingMember.getDeviceName()));
                    }
                    if ((ebsBlockDeviceEbs = blockDeviceMappingMember.getEbs()) != null) {
                        if (ebsBlockDeviceEbs.getSnapshotId() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebsBlockDeviceEbs.getSnapshotId()));
                        }
                        if (ebsBlockDeviceEbs.getVolumeSize() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebsBlockDeviceEbs.getVolumeSize()));
                        }
                        if (ebsBlockDeviceEbs.isDeleteOnTermination() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebsBlockDeviceEbs.isDeleteOnTermination()));
                        }
                        if (ebsBlockDeviceEbs.getVolumeType() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebsBlockDeviceEbs.getVolumeType()));
                        }
                        if (ebsBlockDeviceEbs.getIops() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebsBlockDeviceEbs.getIops()));
                        }
                        if (ebsBlockDeviceEbs.isEncrypted() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebsBlockDeviceEbs.isEncrypted()));
                        }
                    }
                    if (blockDeviceMappingMember.getNoDevice() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)blockDeviceMappingMember.getNoDevice()));
                    }
                }
                ++blockDeviceMappingsListIndex;
            }
            if (launchSpecificationLaunchSpecification.isMonitoringEnabled() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean((Boolean)launchSpecificationLaunchSpecification.isMonitoringEnabled()));
            }
            if (launchSpecificationLaunchSpecification.getSubnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString((String)launchSpecificationLaunchSpecification.getSubnetId()));
            }
            List<InstanceNetworkInterfaceSpecification> networkInterfacesList = launchSpecificationLaunchSpecification.getNetworkInterfaces();
            int networkInterfacesListIndex = 1;
            for (InstanceNetworkInterfaceSpecification networkInterfacesListValue : networkInterfacesList) {
                InstanceNetworkInterfaceSpecification instanceNetworkInterfaceSpecificationMember = networkInterfacesListValue;
                if (instanceNetworkInterfaceSpecificationMember != null) {
                    if (instanceNetworkInterfaceSpecificationMember.getNetworkInterfaceId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationMember.getNetworkInterfaceId()));
                    }
                    if (instanceNetworkInterfaceSpecificationMember.getDeviceIndex() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)instanceNetworkInterfaceSpecificationMember.getDeviceIndex()));
                    }
                    if (instanceNetworkInterfaceSpecificationMember.getSubnetId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationMember.getSubnetId()));
                    }
                    if (instanceNetworkInterfaceSpecificationMember.getDescription() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationMember.getDescription()));
                    }
                    if (instanceNetworkInterfaceSpecificationMember.getPrivateIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationMember.getPrivateIpAddress()));
                    }
                    List<String> groupsList = instanceNetworkInterfaceSpecificationMember.getGroups();
                    int groupsListIndex = 1;
                    for (String groupsListValue : groupsList) {
                        if (groupsListValue != null) {
                            request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)groupsListValue));
                        }
                        ++groupsListIndex;
                    }
                    if (instanceNetworkInterfaceSpecificationMember.isDeleteOnTermination() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)instanceNetworkInterfaceSpecificationMember.isDeleteOnTermination()));
                    }
                    List<PrivateIpAddressSpecification> privateIpAddressesList = instanceNetworkInterfaceSpecificationMember.getPrivateIpAddresses();
                    int privateIpAddressesListIndex = 1;
                    for (PrivateIpAddressSpecification privateIpAddressesListValue : privateIpAddressesList) {
                        PrivateIpAddressSpecification privateIpAddressSpecificationMember = privateIpAddressesListValue;
                        if (privateIpAddressSpecificationMember != null) {
                            if (privateIpAddressSpecificationMember.getPrivateIpAddress() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)privateIpAddressSpecificationMember.getPrivateIpAddress()));
                            }
                            if (privateIpAddressSpecificationMember.isPrimary() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)privateIpAddressSpecificationMember.isPrimary()));
                            }
                        }
                        ++privateIpAddressesListIndex;
                    }
                    if (instanceNetworkInterfaceSpecificationMember.getSecondaryPrivateIpAddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)instanceNetworkInterfaceSpecificationMember.getSecondaryPrivateIpAddressCount()));
                    }
                    if (instanceNetworkInterfaceSpecificationMember.isAssociatePublicIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)instanceNetworkInterfaceSpecificationMember.isAssociatePublicIpAddress()));
                    }
                }
                ++networkInterfacesListIndex;
            }
            IamInstanceProfileSpecification iamInstanceProfileSpecificationIamInstanceProfile = launchSpecificationLaunchSpecification.getIamInstanceProfile();
            if (iamInstanceProfileSpecificationIamInstanceProfile != null) {
                if (iamInstanceProfileSpecificationIamInstanceProfile.getArn() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfileSpecificationIamInstanceProfile.getArn()));
                }
                if (iamInstanceProfileSpecificationIamInstanceProfile.getName() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfileSpecificationIamInstanceProfile.getName()));
                }
            }
            if (launchSpecificationLaunchSpecification.isEbsOptimized() != null) {
                request.addParameter("LaunchSpecification.EbsOptimized", StringUtils.fromBoolean((Boolean)launchSpecificationLaunchSpecification.isEbsOptimized()));
            }
        }
        return request;
    }
}

