/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest;
import com.amazonaws.services.ec2.model.PriceScheduleSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateReservedInstancesListingRequestMarshaller
implements Marshaller<Request<CreateReservedInstancesListingRequest>, CreateReservedInstancesListingRequest> {
    public Request<CreateReservedInstancesListingRequest> marshall(CreateReservedInstancesListingRequest createReservedInstancesListingRequest) {
        if (createReservedInstancesListingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReservedInstancesListingRequest, "AmazonEC2");
        request.addParameter("Action", "CreateReservedInstancesListing");
        request.addParameter("Version", "2014-06-15");
        if (createReservedInstancesListingRequest.getReservedInstancesId() != null) {
            request.addParameter("ReservedInstancesId", StringUtils.fromString((String)createReservedInstancesListingRequest.getReservedInstancesId()));
        }
        if (createReservedInstancesListingRequest.getInstanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger((Integer)createReservedInstancesListingRequest.getInstanceCount()));
        }
        List<PriceScheduleSpecification> priceSchedulesList = createReservedInstancesListingRequest.getPriceSchedules();
        int priceSchedulesListIndex = 1;
        for (PriceScheduleSpecification priceSchedulesListValue : priceSchedulesList) {
            PriceScheduleSpecification priceScheduleSpecificationMember = priceSchedulesListValue;
            if (priceScheduleSpecificationMember != null) {
                if (priceScheduleSpecificationMember.getTerm() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".Term", StringUtils.fromLong((Long)priceScheduleSpecificationMember.getTerm()));
                }
                if (priceScheduleSpecificationMember.getPrice() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".Price", StringUtils.fromDouble((Double)priceScheduleSpecificationMember.getPrice()));
                }
                if (priceScheduleSpecificationMember.getCurrencyCode() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".CurrencyCode", StringUtils.fromString((String)priceScheduleSpecificationMember.getCurrencyCode()));
                }
            }
            ++priceSchedulesListIndex;
        }
        if (createReservedInstancesListingRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createReservedInstancesListingRequest.getClientToken()));
        }
        return request;
    }
}

