/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.SearchLocalGatewayRoutesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SearchLocalGatewayRoutesRequestMarshaller
implements Marshaller<Request<SearchLocalGatewayRoutesRequest>, SearchLocalGatewayRoutesRequest> {
    public Request<SearchLocalGatewayRoutesRequest> marshall(SearchLocalGatewayRoutesRequest searchLocalGatewayRoutesRequest) {
        SdkInternalList searchLocalGatewayRoutesRequestFiltersList;
        if (searchLocalGatewayRoutesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)searchLocalGatewayRoutesRequest, "AmazonEC2");
        request.addParameter("Action", "SearchLocalGatewayRoutes");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (searchLocalGatewayRoutesRequest.getLocalGatewayRouteTableId() != null) {
            request.addParameter("LocalGatewayRouteTableId", StringUtils.fromString((String)searchLocalGatewayRoutesRequest.getLocalGatewayRouteTableId()));
        }
        if (searchLocalGatewayRoutesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)searchLocalGatewayRoutesRequest.getMaxResults()));
        }
        if (searchLocalGatewayRoutesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)searchLocalGatewayRoutesRequest.getNextToken()));
        }
        if (!(searchLocalGatewayRoutesRequestFiltersList = (SdkInternalList)searchLocalGatewayRoutesRequest.getFilters()).isEmpty() || !searchLocalGatewayRoutesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter searchLocalGatewayRoutesRequestFiltersListValue : searchLocalGatewayRoutesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (searchLocalGatewayRoutesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)searchLocalGatewayRoutesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)searchLocalGatewayRoutesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

