/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.DiskInfo;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class DiskInfoStaxUnmarshaller
implements Unmarshaller<DiskInfo, StaxUnmarshallerContext> {
    private static DiskInfoStaxUnmarshaller instance;

    public DiskInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        DiskInfo diskInfo = new DiskInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return diskInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("sizeInGB", targetDepth)) {
                    diskInfo.setSizeInGB(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("count", targetDepth)) {
                    diskInfo.setCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("type", targetDepth)) continue;
                diskInfo.setType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return diskInfo;
    }

    public static DiskInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DiskInfoStaxUnmarshaller();
        }
        return instance;
    }
}

