/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateNatGatewayRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateNatGatewayRequestMarshaller
implements Marshaller<Request<CreateNatGatewayRequest>, CreateNatGatewayRequest> {
    public Request<CreateNatGatewayRequest> marshall(CreateNatGatewayRequest createNatGatewayRequest) {
        SdkInternalList createNatGatewayRequestSecondaryPrivateIpAddressesList;
        SdkInternalList createNatGatewayRequestSecondaryAllocationIdsList;
        SdkInternalList createNatGatewayRequestTagSpecificationsList;
        if (createNatGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createNatGatewayRequest, "AmazonEC2");
        request.addParameter("Action", "CreateNatGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNatGatewayRequest.getAllocationId() != null) {
            request.addParameter("AllocationId", StringUtils.fromString((String)createNatGatewayRequest.getAllocationId()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createNatGatewayRequest.getClientToken()));
        if (createNatGatewayRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)createNatGatewayRequest.getSubnetId()));
        }
        if (!(createNatGatewayRequestTagSpecificationsList = (SdkInternalList)createNatGatewayRequest.getTagSpecifications()).isEmpty() || !createNatGatewayRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (Object createNatGatewayRequestTagSpecificationsListValue : createNatGatewayRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (((TagSpecification)createNatGatewayRequestTagSpecificationsListValue).getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)((TagSpecification)createNatGatewayRequestTagSpecificationsListValue).getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)((TagSpecification)createNatGatewayRequestTagSpecificationsListValue).getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createNatGatewayRequest.getConnectivityType() != null) {
            request.addParameter("ConnectivityType", StringUtils.fromString((String)createNatGatewayRequest.getConnectivityType()));
        }
        if (createNatGatewayRequest.getPrivateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString((String)createNatGatewayRequest.getPrivateIpAddress()));
        }
        if (!(createNatGatewayRequestSecondaryAllocationIdsList = (SdkInternalList)createNatGatewayRequest.getSecondaryAllocationIds()).isEmpty() || !createNatGatewayRequestSecondaryAllocationIdsList.isAutoConstruct()) {
            int secondaryAllocationIdsListIndex = 1;
            for (String createNatGatewayRequestSecondaryAllocationIdsListValue : createNatGatewayRequestSecondaryAllocationIdsList) {
                if (createNatGatewayRequestSecondaryAllocationIdsListValue != null) {
                    request.addParameter("SecondaryAllocationId." + secondaryAllocationIdsListIndex, StringUtils.fromString((String)createNatGatewayRequestSecondaryAllocationIdsListValue));
                }
                ++secondaryAllocationIdsListIndex;
            }
        }
        if (!(createNatGatewayRequestSecondaryPrivateIpAddressesList = (SdkInternalList)createNatGatewayRequest.getSecondaryPrivateIpAddresses()).isEmpty() || !createNatGatewayRequestSecondaryPrivateIpAddressesList.isAutoConstruct()) {
            int secondaryPrivateIpAddressesListIndex = 1;
            for (String createNatGatewayRequestSecondaryPrivateIpAddressesListValue : createNatGatewayRequestSecondaryPrivateIpAddressesList) {
                if (createNatGatewayRequestSecondaryPrivateIpAddressesListValue != null) {
                    request.addParameter("SecondaryPrivateIpAddress." + secondaryPrivateIpAddressesListIndex, StringUtils.fromString((String)createNatGatewayRequestSecondaryPrivateIpAddressesListValue));
                }
                ++secondaryPrivateIpAddressesListIndex;
            }
        }
        if (createNatGatewayRequest.getSecondaryPrivateIpAddressCount() != null) {
            request.addParameter("SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)createNatGatewayRequest.getSecondaryPrivateIpAddressCount()));
        }
        return request;
    }
}

