/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.GetIpamPoolCidrsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetIpamPoolCidrsRequestMarshaller
implements Marshaller<Request<GetIpamPoolCidrsRequest>, GetIpamPoolCidrsRequest> {
    public Request<GetIpamPoolCidrsRequest> marshall(GetIpamPoolCidrsRequest getIpamPoolCidrsRequest) {
        SdkInternalList getIpamPoolCidrsRequestFiltersList;
        if (getIpamPoolCidrsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getIpamPoolCidrsRequest, "AmazonEC2");
        request.addParameter("Action", "GetIpamPoolCidrs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getIpamPoolCidrsRequest.getIpamPoolId() != null) {
            request.addParameter("IpamPoolId", StringUtils.fromString((String)getIpamPoolCidrsRequest.getIpamPoolId()));
        }
        if (!(getIpamPoolCidrsRequestFiltersList = (SdkInternalList)getIpamPoolCidrsRequest.getFilters()).isEmpty() || !getIpamPoolCidrsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter getIpamPoolCidrsRequestFiltersListValue : getIpamPoolCidrsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (getIpamPoolCidrsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)getIpamPoolCidrsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)getIpamPoolCidrsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (getIpamPoolCidrsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)getIpamPoolCidrsRequest.getMaxResults()));
        }
        if (getIpamPoolCidrsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)getIpamPoolCidrsRequest.getNextToken()));
        }
        return request;
    }
}

