/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateVerifiedAccessInstanceRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateVerifiedAccessInstanceRequestMarshaller
implements Marshaller<Request<CreateVerifiedAccessInstanceRequest>, CreateVerifiedAccessInstanceRequest> {
    public Request<CreateVerifiedAccessInstanceRequest> marshall(CreateVerifiedAccessInstanceRequest createVerifiedAccessInstanceRequest) {
        SdkInternalList createVerifiedAccessInstanceRequestTagSpecificationsList;
        if (createVerifiedAccessInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVerifiedAccessInstanceRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVerifiedAccessInstance");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVerifiedAccessInstanceRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createVerifiedAccessInstanceRequest.getDescription()));
        }
        if (!(createVerifiedAccessInstanceRequestTagSpecificationsList = (SdkInternalList)createVerifiedAccessInstanceRequest.getTagSpecifications()).isEmpty() || !createVerifiedAccessInstanceRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createVerifiedAccessInstanceRequestTagSpecificationsListValue : createVerifiedAccessInstanceRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createVerifiedAccessInstanceRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createVerifiedAccessInstanceRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createVerifiedAccessInstanceRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)createVerifiedAccessInstanceRequest.getClientToken()));
        return request;
    }
}

