/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.DiskInfo;
import com.amazonaws.services.ec2.model.InstanceStorageInfo;
import com.amazonaws.services.ec2.model.transform.DiskInfoStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class InstanceStorageInfoStaxUnmarshaller
implements Unmarshaller<InstanceStorageInfo, StaxUnmarshallerContext> {
    private static InstanceStorageInfoStaxUnmarshaller instance;

    public InstanceStorageInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceStorageInfo instanceStorageInfo = new InstanceStorageInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return instanceStorageInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("totalSizeInGB", targetDepth)) {
                    instanceStorageInfo.setTotalSizeInGB(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("disks", targetDepth)) {
                    instanceStorageInfo.withDisks(new ArrayList<DiskInfo>());
                    continue;
                }
                if (context.testExpression("disks/item", targetDepth)) {
                    instanceStorageInfo.withDisks(DiskInfoStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("nvmeSupport", targetDepth)) {
                    instanceStorageInfo.setNvmeSupport(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("encryptionSupport", targetDepth)) continue;
                instanceStorageInfo.setEncryptionSupport(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return instanceStorageInfo;
    }

    public static InstanceStorageInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceStorageInfoStaxUnmarshaller();
        }
        return instance;
    }
}

