/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.AddressTransfer;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class AddressTransferStaxUnmarshaller
implements Unmarshaller<AddressTransfer, StaxUnmarshallerContext> {
    private static AddressTransferStaxUnmarshaller instance;

    public AddressTransfer unmarshall(StaxUnmarshallerContext context) throws Exception {
        AddressTransfer addressTransfer = new AddressTransfer();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return addressTransfer;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("publicIp", targetDepth)) {
                    addressTransfer.setPublicIp(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("allocationId", targetDepth)) {
                    addressTransfer.setAllocationId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("transferAccountId", targetDepth)) {
                    addressTransfer.setTransferAccountId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("transferOfferExpirationTimestamp", targetDepth)) {
                    addressTransfer.setTransferOfferExpirationTimestamp(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("transferOfferAcceptedTimestamp", targetDepth)) {
                    addressTransfer.setTransferOfferAcceptedTimestamp(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (!context.testExpression("addressTransferStatus", targetDepth)) continue;
                addressTransfer.setAddressTransferStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return addressTransfer;
    }

    public static AddressTransferStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AddressTransferStaxUnmarshaller();
        }
        return instance;
    }
}

