/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AssociateInstanceEventWindowRequest;
import com.amazonaws.services.ec2.model.InstanceEventWindowAssociationRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AssociateInstanceEventWindowRequestMarshaller
implements Marshaller<Request<AssociateInstanceEventWindowRequest>, AssociateInstanceEventWindowRequest> {
    public Request<AssociateInstanceEventWindowRequest> marshall(AssociateInstanceEventWindowRequest associateInstanceEventWindowRequest) {
        InstanceEventWindowAssociationRequest associationTarget;
        if (associateInstanceEventWindowRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)associateInstanceEventWindowRequest, "AmazonEC2");
        request.addParameter("Action", "AssociateInstanceEventWindow");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (associateInstanceEventWindowRequest.getInstanceEventWindowId() != null) {
            request.addParameter("InstanceEventWindowId", StringUtils.fromString((String)associateInstanceEventWindowRequest.getInstanceEventWindowId()));
        }
        if ((associationTarget = associateInstanceEventWindowRequest.getAssociationTarget()) != null) {
            SdkInternalList instanceEventWindowAssociationRequestDedicatedHostIdsList;
            SdkInternalList instanceEventWindowAssociationRequestInstanceTagsList;
            SdkInternalList instanceEventWindowAssociationRequestInstanceIdsList = (SdkInternalList)associationTarget.getInstanceIds();
            if (!instanceEventWindowAssociationRequestInstanceIdsList.isEmpty() || !instanceEventWindowAssociationRequestInstanceIdsList.isAutoConstruct()) {
                int instanceIdsListIndex = 1;
                for (Object instanceEventWindowAssociationRequestInstanceIdsListValue : instanceEventWindowAssociationRequestInstanceIdsList) {
                    if (instanceEventWindowAssociationRequestInstanceIdsListValue != null) {
                        request.addParameter("AssociationTarget.InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)instanceEventWindowAssociationRequestInstanceIdsListValue));
                    }
                    ++instanceIdsListIndex;
                }
            }
            if (!(instanceEventWindowAssociationRequestInstanceTagsList = (SdkInternalList)associationTarget.getInstanceTags()).isEmpty() || !instanceEventWindowAssociationRequestInstanceTagsList.isAutoConstruct()) {
                int instanceTagsListIndex = 1;
                for (Tag instanceEventWindowAssociationRequestInstanceTagsListValue : instanceEventWindowAssociationRequestInstanceTagsList) {
                    if (instanceEventWindowAssociationRequestInstanceTagsListValue.getKey() != null) {
                        request.addParameter("AssociationTarget.InstanceTag." + instanceTagsListIndex + ".Key", StringUtils.fromString((String)instanceEventWindowAssociationRequestInstanceTagsListValue.getKey()));
                    }
                    if (instanceEventWindowAssociationRequestInstanceTagsListValue.getValue() != null) {
                        request.addParameter("AssociationTarget.InstanceTag." + instanceTagsListIndex + ".Value", StringUtils.fromString((String)instanceEventWindowAssociationRequestInstanceTagsListValue.getValue()));
                    }
                    ++instanceTagsListIndex;
                }
            }
            if (!(instanceEventWindowAssociationRequestDedicatedHostIdsList = (SdkInternalList)associationTarget.getDedicatedHostIds()).isEmpty() || !instanceEventWindowAssociationRequestDedicatedHostIdsList.isAutoConstruct()) {
                int dedicatedHostIdsListIndex = 1;
                for (String instanceEventWindowAssociationRequestDedicatedHostIdsListValue : instanceEventWindowAssociationRequestDedicatedHostIdsList) {
                    if (instanceEventWindowAssociationRequestDedicatedHostIdsListValue != null) {
                        request.addParameter("AssociationTarget.DedicatedHostId." + dedicatedHostIdsListIndex, StringUtils.fromString((String)instanceEventWindowAssociationRequestDedicatedHostIdsListValue));
                    }
                    ++dedicatedHostIdsListIndex;
                }
            }
        }
        return request;
    }
}

