/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * Describes a flow log.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/FlowLog" target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class FlowLog implements Serializable, Cloneable {

    /**
     * <p>
     * The date and time the flow log was created.
     * </p>
     */
    private java.util.Date creationTime;
    /**
     * <p>
     * Information about the error that occurred. <code>Rate limited</code> indicates that CloudWatch Logs throttling
     * has been applied for one or more network interfaces, or that you've reached the limit on the number of log groups
     * that you can create. <code>Access error</code> indicates that the IAM role associated with the flow log does not
     * have sufficient permissions to publish to CloudWatch Logs. <code>Unknown error</code> indicates an internal
     * error.
     * </p>
     */
    private String deliverLogsErrorMessage;
    /**
     * <p>
     * The ARN of the IAM role allows the service to publish logs to CloudWatch Logs.
     * </p>
     */
    private String deliverLogsPermissionArn;
    /**
     * <p>
     * The ARN of the IAM role that allows the service to publish flow logs across accounts.
     * </p>
     */
    private String deliverCrossAccountRole;
    /**
     * <p>
     * The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
     * </p>
     */
    private String deliverLogsStatus;
    /**
     * <p>
     * The ID of the flow log.
     * </p>
     */
    private String flowLogId;
    /**
     * <p>
     * The status of the flow log (<code>ACTIVE</code>).
     * </p>
     */
    private String flowLogStatus;
    /**
     * <p>
     * The name of the flow log group.
     * </p>
     */
    private String logGroupName;
    /**
     * <p>
     * The ID of the resource being monitored.
     * </p>
     */
    private String resourceId;
    /**
     * <p>
     * The type of traffic captured for the flow log.
     * </p>
     */
    private String trafficType;
    /**
     * <p>
     * The type of destination for the flow log data.
     * </p>
     */
    private String logDestinationType;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the destination for the flow log data.
     * </p>
     */
    private String logDestination;
    /**
     * <p>
     * The format of the flow log record.
     * </p>
     */
    private String logFormat;
    /**
     * <p>
     * The tags for the flow log.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<Tag> tags;
    /**
     * <p>
     * The maximum interval of time, in seconds, during which a flow of packets is captured and aggregated into a flow
     * log record.
     * </p>
     * <p>
     * When a network interface is attached to a <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based
     * instance</a>, the aggregation interval is always 60 seconds (1 minute) or less, regardless of the specified
     * value.
     * </p>
     * <p>
     * Valid Values: <code>60</code> | <code>600</code>
     * </p>
     */
    private Integer maxAggregationInterval;
    /**
     * <p>
     * The destination options.
     * </p>
     */
    private DestinationOptionsResponse destinationOptions;

    /**
     * <p>
     * The date and time the flow log was created.
     * </p>
     * 
     * @param creationTime
     *        The date and time the flow log was created.
     */

    public void setCreationTime(java.util.Date creationTime) {
        this.creationTime = creationTime;
    }

    /**
     * <p>
     * The date and time the flow log was created.
     * </p>
     * 
     * @return The date and time the flow log was created.
     */

    public java.util.Date getCreationTime() {
        return this.creationTime;
    }

    /**
     * <p>
     * The date and time the flow log was created.
     * </p>
     * 
     * @param creationTime
     *        The date and time the flow log was created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FlowLog withCreationTime(java.util.Date creationTime) {
        setCreationTime(creationTime);
        return this;
    }

    /**
     * <p>
     * Information about the error that occurred. <code>Rate limited</code> indicates that CloudWatch Logs throttling
     * has been applied for one or more network interfaces, or that you've reached the limit on the number of log groups
     * that you can create. <code>Access error</code> indicates that the IAM role associated with the flow log does not
     * have sufficient permissions to publish to CloudWatch Logs. <code>Unknown error</code> indicates an internal
     * error.
     * </p>
     * 
     * @param deliverLogsErrorMessage
     *        Information about the error that occurred. <code>Rate limited</code> indicates that CloudWatch Logs
     *        throttling has been applied for one or more network interfaces, or that you've reached the limit on the
     *        number of log groups that you can create. <code>Access error</code> indicates that the IAM role associated
     *        with the flow log does not have sufficient permissions to publish to CloudWatch Logs.
     *        <code>Unknown error</code> indicates an internal error.
     */

    public void setDeliverLogsErrorMessage(String deliverLogsErrorMessage) {
        this.deliverLogsErrorMessage = deliverLogsErrorMessage;
    }

    /**
     * <p>
     * Information about the error that occurred. <code>Rate limited</code> indicates that CloudWatch Logs throttling
     * has been applied for one or more network interfaces, or that you've reached the limit on the number of log groups
     * that you can create. <code>Access error</code> indicates that the IAM role associated with the flow log does not
     * have sufficient permissions to publish to CloudWatch Logs. <code>Unknown error</code> indicates an internal
     * error.
     * </p>
     * 
     * @return Information about the error that occurred. <code>Rate limited</code> indicates that CloudWatch Logs
     *         throttling has been applied for one or more network interfaces, or that you've reached the limit on the
     *         number of log groups that you can create. <code>Access error</code> indicates that the IAM role
     *         associated with the flow log does not have sufficient permissions to publish to CloudWatch Logs.
     *         <code>Unknown error</code> indicates an internal error.
     */

    public String getDeliverLogsErrorMessage() {
        return this.deliverLogsErrorMessage;
    }

    /**
     * <p>
     * Information about the error that occurred. <code>Rate limited</code> indicates that CloudWatch Logs throttling
     * has been applied for one or more network interfaces, or that you've reached the limit on the number of log groups
     * that you can create. <code>Access error</code> indicates that the IAM role associated with the flow log does not
     * have sufficient permissions to publish to CloudWatch Logs. <code>Unknown error</code> indicates an internal
     * error.
     * </p>
     * 
     * @param deliverLogsErrorMessage
     *        Information about the error that occurred. <code>Rate limited</code> indicates that CloudWatch Logs
     *        throttling has been applied for one or more network interfaces, or that you've reached the limit on the
     *        number of log groups that you can create. <code>Access error</code> indicates that the IAM role associated
     *        with the flow log does not have sufficient permissions to publish to CloudWatch Logs.
     *        <code>Unknown error</code> indicates an internal error.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FlowLog withDeliverLogsErrorMessage(String deliverLogsErrorMessage) {
        setDeliverLogsErrorMessage(deliverLogsErrorMessage);
        return this;
    }

    /**
     * <p>
     * The ARN of the IAM role allows the service to publish logs to CloudWatch Logs.
     * </p>
     * 
     * @param deliverLogsPermissionArn
     *        The ARN of the IAM role allows the service to publish logs to CloudWatch Logs.
     */

    public void setDeliverLogsPermissionArn(String deliverLogsPermissionArn) {
        this.deliverLogsPermissionArn = deliverLogsPermissionArn;
    }

    /**
     * <p>
     * The ARN of the IAM role allows the service to publish logs to CloudWatch Logs.
     * </p>
     * 
     * @return The ARN of the IAM role allows the service to publish logs to CloudWatch Logs.
     */

    public String getDeliverLogsPermissionArn() {
        return this.deliverLogsPermissionArn;
    }

    /**
     * <p>
     * The ARN of the IAM role allows the service to publish logs to CloudWatch Logs.
     * </p>
     * 
     * @param deliverLogsPermissionArn
     *        The ARN of the IAM role allows the service to publish logs to CloudWatch Logs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FlowLog withDeliverLogsPermissionArn(String deliverLogsPermissionArn) {
        setDeliverLogsPermissionArn(deliverLogsPermissionArn);
        return this;
    }

    /**
     * <p>
     * The ARN of the IAM role that allows the service to publish flow logs across accounts.
     * </p>
     * 
     * @param deliverCrossAccountRole
     *        The ARN of the IAM role that allows the service to publish flow logs across accounts.
     */

    public void setDeliverCrossAccountRole(String deliverCrossAccountRole) {
        this.deliverCrossAccountRole = deliverCrossAccountRole;
    }

    /**
     * <p>
     * The ARN of the IAM role that allows the service to publish flow logs across accounts.
     * </p>
     * 
     * @return The ARN of the IAM role that allows the service to publish flow logs across accounts.
     */

    public String getDeliverCrossAccountRole() {
        return this.deliverCrossAccountRole;
    }

    /**
     * <p>
     * The ARN of the IAM role that allows the service to publish flow logs across accounts.
     * </p>
     * 
     * @param deliverCrossAccountRole
     *        The ARN of the IAM role that allows the service to publish flow logs across accounts.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FlowLog withDeliverCrossAccountRole(String deliverCrossAccountRole) {
        setDeliverCrossAccountRole(deliverCrossAccountRole);
        return this;
    }

    /**
     * <p>
     * The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
     * </p>
     * 
     * @param deliverLogsStatus
     *        The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
     */

    public void setDeliverLogsStatus(String deliverLogsStatus) {
        this.deliverLogsStatus = deliverLogsStatus;
    }

    /**
     * <p>
     * The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
     * </p>
     * 
     * @return The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
     */

    public String getDeliverLogsStatus() {
        return this.deliverLogsStatus;
    }

    /**
     * <p>
     * The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
     * </p>
     * 
     * @param deliverLogsStatus
     *        The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FlowLog withDeliverLogsStatus(String deliverLogsStatus) {
        setDeliverLogsStatus(deliverLogsStatus);
        return this;
    }

    /**
     * <p>
     * The ID of the flow log.
     * </p>
     * 
     * @param flowLogId
     *        The ID of the flow log.
     */

    public void setFlowLogId(String flowLogId) {
        this.flowLogId = flowLogId;
    }

    /**
     * <p>
     * The ID of the flow log.
     * </p>
     * 
     * @return The ID of the flow log.
     */

    public String getFlowLogId() {
        return this.flowLogId;
    }

    /**
     * <p>
     * The ID of the flow log.
     * </p>
     * 
     * @param flowLogId
     *        The ID of the flow log.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FlowLog withFlowLogId(String flowLogId) {
        setFlowLogId(flowLogId);
        return this;
    }

    /**
     * <p>
     * The status of the flow log (<code>ACTIVE</code>).
     * </p>
     * 
     * @param flowLogStatus
     *        The status of the flow log (<code>ACTIVE</code>).
     */

    public void setFlowLogStatus(String flowLogStatus) {
        this.flowLogStatus = flowLogStatus;
    }

    /**
     * <p>
     * The status of the flow log (<code>ACTIVE</code>).
     * </p>
     * 
     * @return The status of the flow log (<code>ACTIVE</code>).
     */

    public String getFlowLogStatus() {
        return this.flowLogStatus;
    }

    /**
     * <p>
     * The status of the flow log (<code>ACTIVE</code>).
     * </p>
     * 
     * @param flowLogStatus
     *        The status of the flow log (<code>ACTIVE</code>).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FlowLog withFlowLogStatus(String flowLogStatus) {
        setFlowLogStatus(flowLogStatus);
        return this;
    }

    /**
     * <p>
     * The name of the flow log group.
     * </p>
     * 
     * @param logGroupName
     *        The name of the flow log group.
     */

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    /**
     * <p>
     * The name of the flow log group.
     * </p>
     * 
     * @return The name of the flow log group.
     */

    public String getLogGroupName() {
        return this.logGroupName;
    }

    /**
     * <p>
     * The name of the flow log group.
     * </p>
     * 
     * @param logGroupName
     *        The name of the flow log group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FlowLog withLogGroupName(String logGroupName) {
        setLogGroupName(logGroupName);
        return this;
    }

    /**
     * <p>
     * The ID of the resource being monitored.
     * </p>
     * 
     * @param resourceId
     *        The ID of the resource being monitored.
     */

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    /**
     * <p>
     * The ID of the resource being monitored.
     * </p>
     * 
     * @return The ID of the resource being monitored.
     */

    public String getResourceId() {
        return this.resourceId;
    }

    /**
     * <p>
     * The ID of the resource being monitored.
     * </p>
     * 
     * @param resourceId
     *        The ID of the resource being monitored.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FlowLog withResourceId(String resourceId) {
        setResourceId(resourceId);
        return this;
    }

    /**
     * <p>
     * The type of traffic captured for the flow log.
     * </p>
     * 
     * @param trafficType
     *        The type of traffic captured for the flow log.
     * @see TrafficType
     */

    public void setTrafficType(String trafficType) {
        this.trafficType = trafficType;
    }

    /**
     * <p>
     * The type of traffic captured for the flow log.
     * </p>
     * 
     * @return The type of traffic captured for the flow log.
     * @see TrafficType
     */

    public String getTrafficType() {
        return this.trafficType;
    }

    /**
     * <p>
     * The type of traffic captured for the flow log.
     * </p>
     * 
     * @param trafficType
     *        The type of traffic captured for the flow log.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TrafficType
     */

    public FlowLog withTrafficType(String trafficType) {
        setTrafficType(trafficType);
        return this;
    }

    /**
     * <p>
     * The type of traffic captured for the flow log.
     * </p>
     * 
     * @param trafficType
     *        The type of traffic captured for the flow log.
     * @see TrafficType
     */

    public void setTrafficType(TrafficType trafficType) {
        withTrafficType(trafficType);
    }

    /**
     * <p>
     * The type of traffic captured for the flow log.
     * </p>
     * 
     * @param trafficType
     *        The type of traffic captured for the flow log.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TrafficType
     */

    public FlowLog withTrafficType(TrafficType trafficType) {
        this.trafficType = trafficType.toString();
        return this;
    }

    /**
     * <p>
     * The type of destination for the flow log data.
     * </p>
     * 
     * @param logDestinationType
     *        The type of destination for the flow log data.
     * @see LogDestinationType
     */

    public void setLogDestinationType(String logDestinationType) {
        this.logDestinationType = logDestinationType;
    }

    /**
     * <p>
     * The type of destination for the flow log data.
     * </p>
     * 
     * @return The type of destination for the flow log data.
     * @see LogDestinationType
     */

    public String getLogDestinationType() {
        return this.logDestinationType;
    }

    /**
     * <p>
     * The type of destination for the flow log data.
     * </p>
     * 
     * @param logDestinationType
     *        The type of destination for the flow log data.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LogDestinationType
     */

    public FlowLog withLogDestinationType(String logDestinationType) {
        setLogDestinationType(logDestinationType);
        return this;
    }

    /**
     * <p>
     * The type of destination for the flow log data.
     * </p>
     * 
     * @param logDestinationType
     *        The type of destination for the flow log data.
     * @see LogDestinationType
     */

    public void setLogDestinationType(LogDestinationType logDestinationType) {
        withLogDestinationType(logDestinationType);
    }

    /**
     * <p>
     * The type of destination for the flow log data.
     * </p>
     * 
     * @param logDestinationType
     *        The type of destination for the flow log data.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LogDestinationType
     */

    public FlowLog withLogDestinationType(LogDestinationType logDestinationType) {
        this.logDestinationType = logDestinationType.toString();
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the destination for the flow log data.
     * </p>
     * 
     * @param logDestination
     *        The Amazon Resource Name (ARN) of the destination for the flow log data.
     */

    public void setLogDestination(String logDestination) {
        this.logDestination = logDestination;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the destination for the flow log data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the destination for the flow log data.
     */

    public String getLogDestination() {
        return this.logDestination;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the destination for the flow log data.
     * </p>
     * 
     * @param logDestination
     *        The Amazon Resource Name (ARN) of the destination for the flow log data.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FlowLog withLogDestination(String logDestination) {
        setLogDestination(logDestination);
        return this;
    }

    /**
     * <p>
     * The format of the flow log record.
     * </p>
     * 
     * @param logFormat
     *        The format of the flow log record.
     */

    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    /**
     * <p>
     * The format of the flow log record.
     * </p>
     * 
     * @return The format of the flow log record.
     */

    public String getLogFormat() {
        return this.logFormat;
    }

    /**
     * <p>
     * The format of the flow log record.
     * </p>
     * 
     * @param logFormat
     *        The format of the flow log record.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FlowLog withLogFormat(String logFormat) {
        setLogFormat(logFormat);
        return this;
    }

    /**
     * <p>
     * The tags for the flow log.
     * </p>
     * 
     * @return The tags for the flow log.
     */

    public java.util.List<Tag> getTags() {
        if (tags == null) {
            tags = new com.amazonaws.internal.SdkInternalList<Tag>();
        }
        return tags;
    }

    /**
     * <p>
     * The tags for the flow log.
     * </p>
     * 
     * @param tags
     *        The tags for the flow log.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new com.amazonaws.internal.SdkInternalList<Tag>(tags);
    }

    /**
     * <p>
     * The tags for the flow log.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        The tags for the flow log.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FlowLog withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new com.amazonaws.internal.SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The tags for the flow log.
     * </p>
     * 
     * @param tags
     *        The tags for the flow log.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FlowLog withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * <p>
     * The maximum interval of time, in seconds, during which a flow of packets is captured and aggregated into a flow
     * log record.
     * </p>
     * <p>
     * When a network interface is attached to a <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based
     * instance</a>, the aggregation interval is always 60 seconds (1 minute) or less, regardless of the specified
     * value.
     * </p>
     * <p>
     * Valid Values: <code>60</code> | <code>600</code>
     * </p>
     * 
     * @param maxAggregationInterval
     *        The maximum interval of time, in seconds, during which a flow of packets is captured and aggregated into a
     *        flow log record.</p>
     *        <p>
     *        When a network interface is attached to a <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances"
     *        >Nitro-based instance</a>, the aggregation interval is always 60 seconds (1 minute) or less, regardless of
     *        the specified value.
     *        </p>
     *        <p>
     *        Valid Values: <code>60</code> | <code>600</code>
     */

    public void setMaxAggregationInterval(Integer maxAggregationInterval) {
        this.maxAggregationInterval = maxAggregationInterval;
    }

    /**
     * <p>
     * The maximum interval of time, in seconds, during which a flow of packets is captured and aggregated into a flow
     * log record.
     * </p>
     * <p>
     * When a network interface is attached to a <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based
     * instance</a>, the aggregation interval is always 60 seconds (1 minute) or less, regardless of the specified
     * value.
     * </p>
     * <p>
     * Valid Values: <code>60</code> | <code>600</code>
     * </p>
     * 
     * @return The maximum interval of time, in seconds, during which a flow of packets is captured and aggregated into
     *         a flow log record.</p>
     *         <p>
     *         When a network interface is attached to a <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances"
     *         >Nitro-based instance</a>, the aggregation interval is always 60 seconds (1 minute) or less, regardless
     *         of the specified value.
     *         </p>
     *         <p>
     *         Valid Values: <code>60</code> | <code>600</code>
     */

    public Integer getMaxAggregationInterval() {
        return this.maxAggregationInterval;
    }

    /**
     * <p>
     * The maximum interval of time, in seconds, during which a flow of packets is captured and aggregated into a flow
     * log record.
     * </p>
     * <p>
     * When a network interface is attached to a <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Nitro-based
     * instance</a>, the aggregation interval is always 60 seconds (1 minute) or less, regardless of the specified
     * value.
     * </p>
     * <p>
     * Valid Values: <code>60</code> | <code>600</code>
     * </p>
     * 
     * @param maxAggregationInterval
     *        The maximum interval of time, in seconds, during which a flow of packets is captured and aggregated into a
     *        flow log record.</p>
     *        <p>
     *        When a network interface is attached to a <a
     *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances"
     *        >Nitro-based instance</a>, the aggregation interval is always 60 seconds (1 minute) or less, regardless of
     *        the specified value.
     *        </p>
     *        <p>
     *        Valid Values: <code>60</code> | <code>600</code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FlowLog withMaxAggregationInterval(Integer maxAggregationInterval) {
        setMaxAggregationInterval(maxAggregationInterval);
        return this;
    }

    /**
     * <p>
     * The destination options.
     * </p>
     * 
     * @param destinationOptions
     *        The destination options.
     */

    public void setDestinationOptions(DestinationOptionsResponse destinationOptions) {
        this.destinationOptions = destinationOptions;
    }

    /**
     * <p>
     * The destination options.
     * </p>
     * 
     * @return The destination options.
     */

    public DestinationOptionsResponse getDestinationOptions() {
        return this.destinationOptions;
    }

    /**
     * <p>
     * The destination options.
     * </p>
     * 
     * @param destinationOptions
     *        The destination options.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FlowLog withDestinationOptions(DestinationOptionsResponse destinationOptions) {
        setDestinationOptions(destinationOptions);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCreationTime() != null)
            sb.append("CreationTime: ").append(getCreationTime()).append(",");
        if (getDeliverLogsErrorMessage() != null)
            sb.append("DeliverLogsErrorMessage: ").append(getDeliverLogsErrorMessage()).append(",");
        if (getDeliverLogsPermissionArn() != null)
            sb.append("DeliverLogsPermissionArn: ").append(getDeliverLogsPermissionArn()).append(",");
        if (getDeliverCrossAccountRole() != null)
            sb.append("DeliverCrossAccountRole: ").append(getDeliverCrossAccountRole()).append(",");
        if (getDeliverLogsStatus() != null)
            sb.append("DeliverLogsStatus: ").append(getDeliverLogsStatus()).append(",");
        if (getFlowLogId() != null)
            sb.append("FlowLogId: ").append(getFlowLogId()).append(",");
        if (getFlowLogStatus() != null)
            sb.append("FlowLogStatus: ").append(getFlowLogStatus()).append(",");
        if (getLogGroupName() != null)
            sb.append("LogGroupName: ").append(getLogGroupName()).append(",");
        if (getResourceId() != null)
            sb.append("ResourceId: ").append(getResourceId()).append(",");
        if (getTrafficType() != null)
            sb.append("TrafficType: ").append(getTrafficType()).append(",");
        if (getLogDestinationType() != null)
            sb.append("LogDestinationType: ").append(getLogDestinationType()).append(",");
        if (getLogDestination() != null)
            sb.append("LogDestination: ").append(getLogDestination()).append(",");
        if (getLogFormat() != null)
            sb.append("LogFormat: ").append(getLogFormat()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getMaxAggregationInterval() != null)
            sb.append("MaxAggregationInterval: ").append(getMaxAggregationInterval()).append(",");
        if (getDestinationOptions() != null)
            sb.append("DestinationOptions: ").append(getDestinationOptions());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof FlowLog == false)
            return false;
        FlowLog other = (FlowLog) obj;
        if (other.getCreationTime() == null ^ this.getCreationTime() == null)
            return false;
        if (other.getCreationTime() != null && other.getCreationTime().equals(this.getCreationTime()) == false)
            return false;
        if (other.getDeliverLogsErrorMessage() == null ^ this.getDeliverLogsErrorMessage() == null)
            return false;
        if (other.getDeliverLogsErrorMessage() != null && other.getDeliverLogsErrorMessage().equals(this.getDeliverLogsErrorMessage()) == false)
            return false;
        if (other.getDeliverLogsPermissionArn() == null ^ this.getDeliverLogsPermissionArn() == null)
            return false;
        if (other.getDeliverLogsPermissionArn() != null && other.getDeliverLogsPermissionArn().equals(this.getDeliverLogsPermissionArn()) == false)
            return false;
        if (other.getDeliverCrossAccountRole() == null ^ this.getDeliverCrossAccountRole() == null)
            return false;
        if (other.getDeliverCrossAccountRole() != null && other.getDeliverCrossAccountRole().equals(this.getDeliverCrossAccountRole()) == false)
            return false;
        if (other.getDeliverLogsStatus() == null ^ this.getDeliverLogsStatus() == null)
            return false;
        if (other.getDeliverLogsStatus() != null && other.getDeliverLogsStatus().equals(this.getDeliverLogsStatus()) == false)
            return false;
        if (other.getFlowLogId() == null ^ this.getFlowLogId() == null)
            return false;
        if (other.getFlowLogId() != null && other.getFlowLogId().equals(this.getFlowLogId()) == false)
            return false;
        if (other.getFlowLogStatus() == null ^ this.getFlowLogStatus() == null)
            return false;
        if (other.getFlowLogStatus() != null && other.getFlowLogStatus().equals(this.getFlowLogStatus()) == false)
            return false;
        if (other.getLogGroupName() == null ^ this.getLogGroupName() == null)
            return false;
        if (other.getLogGroupName() != null && other.getLogGroupName().equals(this.getLogGroupName()) == false)
            return false;
        if (other.getResourceId() == null ^ this.getResourceId() == null)
            return false;
        if (other.getResourceId() != null && other.getResourceId().equals(this.getResourceId()) == false)
            return false;
        if (other.getTrafficType() == null ^ this.getTrafficType() == null)
            return false;
        if (other.getTrafficType() != null && other.getTrafficType().equals(this.getTrafficType()) == false)
            return false;
        if (other.getLogDestinationType() == null ^ this.getLogDestinationType() == null)
            return false;
        if (other.getLogDestinationType() != null && other.getLogDestinationType().equals(this.getLogDestinationType()) == false)
            return false;
        if (other.getLogDestination() == null ^ this.getLogDestination() == null)
            return false;
        if (other.getLogDestination() != null && other.getLogDestination().equals(this.getLogDestination()) == false)
            return false;
        if (other.getLogFormat() == null ^ this.getLogFormat() == null)
            return false;
        if (other.getLogFormat() != null && other.getLogFormat().equals(this.getLogFormat()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getMaxAggregationInterval() == null ^ this.getMaxAggregationInterval() == null)
            return false;
        if (other.getMaxAggregationInterval() != null && other.getMaxAggregationInterval().equals(this.getMaxAggregationInterval()) == false)
            return false;
        if (other.getDestinationOptions() == null ^ this.getDestinationOptions() == null)
            return false;
        if (other.getDestinationOptions() != null && other.getDestinationOptions().equals(this.getDestinationOptions()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCreationTime() == null) ? 0 : getCreationTime().hashCode());
        hashCode = prime * hashCode + ((getDeliverLogsErrorMessage() == null) ? 0 : getDeliverLogsErrorMessage().hashCode());
        hashCode = prime * hashCode + ((getDeliverLogsPermissionArn() == null) ? 0 : getDeliverLogsPermissionArn().hashCode());
        hashCode = prime * hashCode + ((getDeliverCrossAccountRole() == null) ? 0 : getDeliverCrossAccountRole().hashCode());
        hashCode = prime * hashCode + ((getDeliverLogsStatus() == null) ? 0 : getDeliverLogsStatus().hashCode());
        hashCode = prime * hashCode + ((getFlowLogId() == null) ? 0 : getFlowLogId().hashCode());
        hashCode = prime * hashCode + ((getFlowLogStatus() == null) ? 0 : getFlowLogStatus().hashCode());
        hashCode = prime * hashCode + ((getLogGroupName() == null) ? 0 : getLogGroupName().hashCode());
        hashCode = prime * hashCode + ((getResourceId() == null) ? 0 : getResourceId().hashCode());
        hashCode = prime * hashCode + ((getTrafficType() == null) ? 0 : getTrafficType().hashCode());
        hashCode = prime * hashCode + ((getLogDestinationType() == null) ? 0 : getLogDestinationType().hashCode());
        hashCode = prime * hashCode + ((getLogDestination() == null) ? 0 : getLogDestination().hashCode());
        hashCode = prime * hashCode + ((getLogFormat() == null) ? 0 : getLogFormat().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getMaxAggregationInterval() == null) ? 0 : getMaxAggregationInterval().hashCode());
        hashCode = prime * hashCode + ((getDestinationOptions() == null) ? 0 : getDestinationOptions().hashCode());
        return hashCode;
    }

    @Override
    public FlowLog clone() {
        try {
            return (FlowLog) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
