/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AnalysisAclRule;
import com.amazonaws.services.ec2.model.AnalysisComponent;
import com.amazonaws.services.ec2.model.AnalysisLoadBalancerListener;
import com.amazonaws.services.ec2.model.AnalysisLoadBalancerTarget;
import com.amazonaws.services.ec2.model.AnalysisRouteTableRoute;
import com.amazonaws.services.ec2.model.AnalysisSecurityGroupRule;
import com.amazonaws.services.ec2.model.PortRange;
import com.amazonaws.services.ec2.model.TransitGatewayRouteTableRoute;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Explanation
implements Serializable,
Cloneable {
    private AnalysisComponent acl;
    private AnalysisAclRule aclRule;
    private String address;
    private SdkInternalList<String> addresses;
    private AnalysisComponent attachedTo;
    private SdkInternalList<String> availabilityZones;
    private SdkInternalList<String> cidrs;
    private AnalysisComponent component;
    private AnalysisComponent customerGateway;
    private AnalysisComponent destination;
    private AnalysisComponent destinationVpc;
    private String direction;
    private String explanationCode;
    private AnalysisComponent ingressRouteTable;
    private AnalysisComponent internetGateway;
    private String loadBalancerArn;
    private AnalysisLoadBalancerListener classicLoadBalancerListener;
    private Integer loadBalancerListenerPort;
    private AnalysisLoadBalancerTarget loadBalancerTarget;
    private AnalysisComponent loadBalancerTargetGroup;
    private SdkInternalList<AnalysisComponent> loadBalancerTargetGroups;
    private Integer loadBalancerTargetPort;
    private AnalysisComponent elasticLoadBalancerListener;
    private String missingComponent;
    private AnalysisComponent natGateway;
    private AnalysisComponent networkInterface;
    private String packetField;
    private AnalysisComponent vpcPeeringConnection;
    private Integer port;
    private SdkInternalList<PortRange> portRanges;
    private AnalysisComponent prefixList;
    private SdkInternalList<String> protocols;
    private AnalysisRouteTableRoute routeTableRoute;
    private AnalysisComponent routeTable;
    private AnalysisComponent securityGroup;
    private AnalysisSecurityGroupRule securityGroupRule;
    private SdkInternalList<AnalysisComponent> securityGroups;
    private AnalysisComponent sourceVpc;
    private String state;
    private AnalysisComponent subnet;
    private AnalysisComponent subnetRouteTable;
    private AnalysisComponent vpc;
    private AnalysisComponent vpcEndpoint;
    private AnalysisComponent vpnConnection;
    private AnalysisComponent vpnGateway;
    private AnalysisComponent transitGateway;
    private AnalysisComponent transitGatewayRouteTable;
    private TransitGatewayRouteTableRoute transitGatewayRouteTableRoute;
    private AnalysisComponent transitGatewayAttachment;
    private String componentAccount;
    private String componentRegion;

    public void setAcl(AnalysisComponent acl) {
        this.acl = acl;
    }

    public AnalysisComponent getAcl() {
        return this.acl;
    }

    public Explanation withAcl(AnalysisComponent acl) {
        this.setAcl(acl);
        return this;
    }

    public void setAclRule(AnalysisAclRule aclRule) {
        this.aclRule = aclRule;
    }

    public AnalysisAclRule getAclRule() {
        return this.aclRule;
    }

    public Explanation withAclRule(AnalysisAclRule aclRule) {
        this.setAclRule(aclRule);
        return this;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public Explanation withAddress(String address) {
        this.setAddress(address);
        return this;
    }

    public List<String> getAddresses() {
        if (this.addresses == null) {
            this.addresses = new SdkInternalList();
        }
        return this.addresses;
    }

    public void setAddresses(Collection<String> addresses) {
        if (addresses == null) {
            this.addresses = null;
            return;
        }
        this.addresses = new SdkInternalList(addresses);
    }

    public Explanation withAddresses(String ... addresses) {
        if (this.addresses == null) {
            this.setAddresses((Collection<String>)new SdkInternalList(addresses.length));
        }
        for (String ele : addresses) {
            this.addresses.add((Object)ele);
        }
        return this;
    }

    public Explanation withAddresses(Collection<String> addresses) {
        this.setAddresses(addresses);
        return this;
    }

    public void setAttachedTo(AnalysisComponent attachedTo) {
        this.attachedTo = attachedTo;
    }

    public AnalysisComponent getAttachedTo() {
        return this.attachedTo;
    }

    public Explanation withAttachedTo(AnalysisComponent attachedTo) {
        this.setAttachedTo(attachedTo);
        return this;
    }

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new SdkInternalList();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new SdkInternalList(availabilityZones);
    }

    public Explanation withAvailabilityZones(String ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones((Collection<String>)new SdkInternalList(availabilityZones.length));
        }
        for (String ele : availabilityZones) {
            this.availabilityZones.add((Object)ele);
        }
        return this;
    }

    public Explanation withAvailabilityZones(Collection<String> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public List<String> getCidrs() {
        if (this.cidrs == null) {
            this.cidrs = new SdkInternalList();
        }
        return this.cidrs;
    }

    public void setCidrs(Collection<String> cidrs) {
        if (cidrs == null) {
            this.cidrs = null;
            return;
        }
        this.cidrs = new SdkInternalList(cidrs);
    }

    public Explanation withCidrs(String ... cidrs) {
        if (this.cidrs == null) {
            this.setCidrs((Collection<String>)new SdkInternalList(cidrs.length));
        }
        for (String ele : cidrs) {
            this.cidrs.add((Object)ele);
        }
        return this;
    }

    public Explanation withCidrs(Collection<String> cidrs) {
        this.setCidrs(cidrs);
        return this;
    }

    public void setComponent(AnalysisComponent component) {
        this.component = component;
    }

    public AnalysisComponent getComponent() {
        return this.component;
    }

    public Explanation withComponent(AnalysisComponent component) {
        this.setComponent(component);
        return this;
    }

    public void setCustomerGateway(AnalysisComponent customerGateway) {
        this.customerGateway = customerGateway;
    }

    public AnalysisComponent getCustomerGateway() {
        return this.customerGateway;
    }

    public Explanation withCustomerGateway(AnalysisComponent customerGateway) {
        this.setCustomerGateway(customerGateway);
        return this;
    }

    public void setDestination(AnalysisComponent destination) {
        this.destination = destination;
    }

    public AnalysisComponent getDestination() {
        return this.destination;
    }

    public Explanation withDestination(AnalysisComponent destination) {
        this.setDestination(destination);
        return this;
    }

    public void setDestinationVpc(AnalysisComponent destinationVpc) {
        this.destinationVpc = destinationVpc;
    }

    public AnalysisComponent getDestinationVpc() {
        return this.destinationVpc;
    }

    public Explanation withDestinationVpc(AnalysisComponent destinationVpc) {
        this.setDestinationVpc(destinationVpc);
        return this;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getDirection() {
        return this.direction;
    }

    public Explanation withDirection(String direction) {
        this.setDirection(direction);
        return this;
    }

    public void setExplanationCode(String explanationCode) {
        this.explanationCode = explanationCode;
    }

    public String getExplanationCode() {
        return this.explanationCode;
    }

    public Explanation withExplanationCode(String explanationCode) {
        this.setExplanationCode(explanationCode);
        return this;
    }

    public void setIngressRouteTable(AnalysisComponent ingressRouteTable) {
        this.ingressRouteTable = ingressRouteTable;
    }

    public AnalysisComponent getIngressRouteTable() {
        return this.ingressRouteTable;
    }

    public Explanation withIngressRouteTable(AnalysisComponent ingressRouteTable) {
        this.setIngressRouteTable(ingressRouteTable);
        return this;
    }

    public void setInternetGateway(AnalysisComponent internetGateway) {
        this.internetGateway = internetGateway;
    }

    public AnalysisComponent getInternetGateway() {
        return this.internetGateway;
    }

    public Explanation withInternetGateway(AnalysisComponent internetGateway) {
        this.setInternetGateway(internetGateway);
        return this;
    }

    public void setLoadBalancerArn(String loadBalancerArn) {
        this.loadBalancerArn = loadBalancerArn;
    }

    public String getLoadBalancerArn() {
        return this.loadBalancerArn;
    }

    public Explanation withLoadBalancerArn(String loadBalancerArn) {
        this.setLoadBalancerArn(loadBalancerArn);
        return this;
    }

    public void setClassicLoadBalancerListener(AnalysisLoadBalancerListener classicLoadBalancerListener) {
        this.classicLoadBalancerListener = classicLoadBalancerListener;
    }

    public AnalysisLoadBalancerListener getClassicLoadBalancerListener() {
        return this.classicLoadBalancerListener;
    }

    public Explanation withClassicLoadBalancerListener(AnalysisLoadBalancerListener classicLoadBalancerListener) {
        this.setClassicLoadBalancerListener(classicLoadBalancerListener);
        return this;
    }

    public void setLoadBalancerListenerPort(Integer loadBalancerListenerPort) {
        this.loadBalancerListenerPort = loadBalancerListenerPort;
    }

    public Integer getLoadBalancerListenerPort() {
        return this.loadBalancerListenerPort;
    }

    public Explanation withLoadBalancerListenerPort(Integer loadBalancerListenerPort) {
        this.setLoadBalancerListenerPort(loadBalancerListenerPort);
        return this;
    }

    public void setLoadBalancerTarget(AnalysisLoadBalancerTarget loadBalancerTarget) {
        this.loadBalancerTarget = loadBalancerTarget;
    }

    public AnalysisLoadBalancerTarget getLoadBalancerTarget() {
        return this.loadBalancerTarget;
    }

    public Explanation withLoadBalancerTarget(AnalysisLoadBalancerTarget loadBalancerTarget) {
        this.setLoadBalancerTarget(loadBalancerTarget);
        return this;
    }

    public void setLoadBalancerTargetGroup(AnalysisComponent loadBalancerTargetGroup) {
        this.loadBalancerTargetGroup = loadBalancerTargetGroup;
    }

    public AnalysisComponent getLoadBalancerTargetGroup() {
        return this.loadBalancerTargetGroup;
    }

    public Explanation withLoadBalancerTargetGroup(AnalysisComponent loadBalancerTargetGroup) {
        this.setLoadBalancerTargetGroup(loadBalancerTargetGroup);
        return this;
    }

    public List<AnalysisComponent> getLoadBalancerTargetGroups() {
        if (this.loadBalancerTargetGroups == null) {
            this.loadBalancerTargetGroups = new SdkInternalList();
        }
        return this.loadBalancerTargetGroups;
    }

    public void setLoadBalancerTargetGroups(Collection<AnalysisComponent> loadBalancerTargetGroups) {
        if (loadBalancerTargetGroups == null) {
            this.loadBalancerTargetGroups = null;
            return;
        }
        this.loadBalancerTargetGroups = new SdkInternalList(loadBalancerTargetGroups);
    }

    public Explanation withLoadBalancerTargetGroups(AnalysisComponent ... loadBalancerTargetGroups) {
        if (this.loadBalancerTargetGroups == null) {
            this.setLoadBalancerTargetGroups((Collection<AnalysisComponent>)new SdkInternalList(loadBalancerTargetGroups.length));
        }
        for (AnalysisComponent ele : loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups.add((Object)ele);
        }
        return this;
    }

    public Explanation withLoadBalancerTargetGroups(Collection<AnalysisComponent> loadBalancerTargetGroups) {
        this.setLoadBalancerTargetGroups(loadBalancerTargetGroups);
        return this;
    }

    public void setLoadBalancerTargetPort(Integer loadBalancerTargetPort) {
        this.loadBalancerTargetPort = loadBalancerTargetPort;
    }

    public Integer getLoadBalancerTargetPort() {
        return this.loadBalancerTargetPort;
    }

    public Explanation withLoadBalancerTargetPort(Integer loadBalancerTargetPort) {
        this.setLoadBalancerTargetPort(loadBalancerTargetPort);
        return this;
    }

    public void setElasticLoadBalancerListener(AnalysisComponent elasticLoadBalancerListener) {
        this.elasticLoadBalancerListener = elasticLoadBalancerListener;
    }

    public AnalysisComponent getElasticLoadBalancerListener() {
        return this.elasticLoadBalancerListener;
    }

    public Explanation withElasticLoadBalancerListener(AnalysisComponent elasticLoadBalancerListener) {
        this.setElasticLoadBalancerListener(elasticLoadBalancerListener);
        return this;
    }

    public void setMissingComponent(String missingComponent) {
        this.missingComponent = missingComponent;
    }

    public String getMissingComponent() {
        return this.missingComponent;
    }

    public Explanation withMissingComponent(String missingComponent) {
        this.setMissingComponent(missingComponent);
        return this;
    }

    public void setNatGateway(AnalysisComponent natGateway) {
        this.natGateway = natGateway;
    }

    public AnalysisComponent getNatGateway() {
        return this.natGateway;
    }

    public Explanation withNatGateway(AnalysisComponent natGateway) {
        this.setNatGateway(natGateway);
        return this;
    }

    public void setNetworkInterface(AnalysisComponent networkInterface) {
        this.networkInterface = networkInterface;
    }

    public AnalysisComponent getNetworkInterface() {
        return this.networkInterface;
    }

    public Explanation withNetworkInterface(AnalysisComponent networkInterface) {
        this.setNetworkInterface(networkInterface);
        return this;
    }

    public void setPacketField(String packetField) {
        this.packetField = packetField;
    }

    public String getPacketField() {
        return this.packetField;
    }

    public Explanation withPacketField(String packetField) {
        this.setPacketField(packetField);
        return this;
    }

    public void setVpcPeeringConnection(AnalysisComponent vpcPeeringConnection) {
        this.vpcPeeringConnection = vpcPeeringConnection;
    }

    public AnalysisComponent getVpcPeeringConnection() {
        return this.vpcPeeringConnection;
    }

    public Explanation withVpcPeeringConnection(AnalysisComponent vpcPeeringConnection) {
        this.setVpcPeeringConnection(vpcPeeringConnection);
        return this;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public Explanation withPort(Integer port) {
        this.setPort(port);
        return this;
    }

    public List<PortRange> getPortRanges() {
        if (this.portRanges == null) {
            this.portRanges = new SdkInternalList();
        }
        return this.portRanges;
    }

    public void setPortRanges(Collection<PortRange> portRanges) {
        if (portRanges == null) {
            this.portRanges = null;
            return;
        }
        this.portRanges = new SdkInternalList(portRanges);
    }

    public Explanation withPortRanges(PortRange ... portRanges) {
        if (this.portRanges == null) {
            this.setPortRanges((Collection<PortRange>)new SdkInternalList(portRanges.length));
        }
        for (PortRange ele : portRanges) {
            this.portRanges.add((Object)ele);
        }
        return this;
    }

    public Explanation withPortRanges(Collection<PortRange> portRanges) {
        this.setPortRanges(portRanges);
        return this;
    }

    public void setPrefixList(AnalysisComponent prefixList) {
        this.prefixList = prefixList;
    }

    public AnalysisComponent getPrefixList() {
        return this.prefixList;
    }

    public Explanation withPrefixList(AnalysisComponent prefixList) {
        this.setPrefixList(prefixList);
        return this;
    }

    public List<String> getProtocols() {
        if (this.protocols == null) {
            this.protocols = new SdkInternalList();
        }
        return this.protocols;
    }

    public void setProtocols(Collection<String> protocols) {
        if (protocols == null) {
            this.protocols = null;
            return;
        }
        this.protocols = new SdkInternalList(protocols);
    }

    public Explanation withProtocols(String ... protocols) {
        if (this.protocols == null) {
            this.setProtocols((Collection<String>)new SdkInternalList(protocols.length));
        }
        for (String ele : protocols) {
            this.protocols.add((Object)ele);
        }
        return this;
    }

    public Explanation withProtocols(Collection<String> protocols) {
        this.setProtocols(protocols);
        return this;
    }

    public void setRouteTableRoute(AnalysisRouteTableRoute routeTableRoute) {
        this.routeTableRoute = routeTableRoute;
    }

    public AnalysisRouteTableRoute getRouteTableRoute() {
        return this.routeTableRoute;
    }

    public Explanation withRouteTableRoute(AnalysisRouteTableRoute routeTableRoute) {
        this.setRouteTableRoute(routeTableRoute);
        return this;
    }

    public void setRouteTable(AnalysisComponent routeTable) {
        this.routeTable = routeTable;
    }

    public AnalysisComponent getRouteTable() {
        return this.routeTable;
    }

    public Explanation withRouteTable(AnalysisComponent routeTable) {
        this.setRouteTable(routeTable);
        return this;
    }

    public void setSecurityGroup(AnalysisComponent securityGroup) {
        this.securityGroup = securityGroup;
    }

    public AnalysisComponent getSecurityGroup() {
        return this.securityGroup;
    }

    public Explanation withSecurityGroup(AnalysisComponent securityGroup) {
        this.setSecurityGroup(securityGroup);
        return this;
    }

    public void setSecurityGroupRule(AnalysisSecurityGroupRule securityGroupRule) {
        this.securityGroupRule = securityGroupRule;
    }

    public AnalysisSecurityGroupRule getSecurityGroupRule() {
        return this.securityGroupRule;
    }

    public Explanation withSecurityGroupRule(AnalysisSecurityGroupRule securityGroupRule) {
        this.setSecurityGroupRule(securityGroupRule);
        return this;
    }

    public List<AnalysisComponent> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new SdkInternalList();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<AnalysisComponent> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new SdkInternalList(securityGroups);
    }

    public Explanation withSecurityGroups(AnalysisComponent ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups((Collection<AnalysisComponent>)new SdkInternalList(securityGroups.length));
        }
        for (AnalysisComponent ele : securityGroups) {
            this.securityGroups.add((Object)ele);
        }
        return this;
    }

    public Explanation withSecurityGroups(Collection<AnalysisComponent> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public void setSourceVpc(AnalysisComponent sourceVpc) {
        this.sourceVpc = sourceVpc;
    }

    public AnalysisComponent getSourceVpc() {
        return this.sourceVpc;
    }

    public Explanation withSourceVpc(AnalysisComponent sourceVpc) {
        this.setSourceVpc(sourceVpc);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Explanation withState(String state) {
        this.setState(state);
        return this;
    }

    public void setSubnet(AnalysisComponent subnet) {
        this.subnet = subnet;
    }

    public AnalysisComponent getSubnet() {
        return this.subnet;
    }

    public Explanation withSubnet(AnalysisComponent subnet) {
        this.setSubnet(subnet);
        return this;
    }

    public void setSubnetRouteTable(AnalysisComponent subnetRouteTable) {
        this.subnetRouteTable = subnetRouteTable;
    }

    public AnalysisComponent getSubnetRouteTable() {
        return this.subnetRouteTable;
    }

    public Explanation withSubnetRouteTable(AnalysisComponent subnetRouteTable) {
        this.setSubnetRouteTable(subnetRouteTable);
        return this;
    }

    public void setVpc(AnalysisComponent vpc) {
        this.vpc = vpc;
    }

    public AnalysisComponent getVpc() {
        return this.vpc;
    }

    public Explanation withVpc(AnalysisComponent vpc) {
        this.setVpc(vpc);
        return this;
    }

    public void setVpcEndpoint(AnalysisComponent vpcEndpoint) {
        this.vpcEndpoint = vpcEndpoint;
    }

    public AnalysisComponent getVpcEndpoint() {
        return this.vpcEndpoint;
    }

    public Explanation withVpcEndpoint(AnalysisComponent vpcEndpoint) {
        this.setVpcEndpoint(vpcEndpoint);
        return this;
    }

    public void setVpnConnection(AnalysisComponent vpnConnection) {
        this.vpnConnection = vpnConnection;
    }

    public AnalysisComponent getVpnConnection() {
        return this.vpnConnection;
    }

    public Explanation withVpnConnection(AnalysisComponent vpnConnection) {
        this.setVpnConnection(vpnConnection);
        return this;
    }

    public void setVpnGateway(AnalysisComponent vpnGateway) {
        this.vpnGateway = vpnGateway;
    }

    public AnalysisComponent getVpnGateway() {
        return this.vpnGateway;
    }

    public Explanation withVpnGateway(AnalysisComponent vpnGateway) {
        this.setVpnGateway(vpnGateway);
        return this;
    }

    public void setTransitGateway(AnalysisComponent transitGateway) {
        this.transitGateway = transitGateway;
    }

    public AnalysisComponent getTransitGateway() {
        return this.transitGateway;
    }

    public Explanation withTransitGateway(AnalysisComponent transitGateway) {
        this.setTransitGateway(transitGateway);
        return this;
    }

    public void setTransitGatewayRouteTable(AnalysisComponent transitGatewayRouteTable) {
        this.transitGatewayRouteTable = transitGatewayRouteTable;
    }

    public AnalysisComponent getTransitGatewayRouteTable() {
        return this.transitGatewayRouteTable;
    }

    public Explanation withTransitGatewayRouteTable(AnalysisComponent transitGatewayRouteTable) {
        this.setTransitGatewayRouteTable(transitGatewayRouteTable);
        return this;
    }

    public void setTransitGatewayRouteTableRoute(TransitGatewayRouteTableRoute transitGatewayRouteTableRoute) {
        this.transitGatewayRouteTableRoute = transitGatewayRouteTableRoute;
    }

    public TransitGatewayRouteTableRoute getTransitGatewayRouteTableRoute() {
        return this.transitGatewayRouteTableRoute;
    }

    public Explanation withTransitGatewayRouteTableRoute(TransitGatewayRouteTableRoute transitGatewayRouteTableRoute) {
        this.setTransitGatewayRouteTableRoute(transitGatewayRouteTableRoute);
        return this;
    }

    public void setTransitGatewayAttachment(AnalysisComponent transitGatewayAttachment) {
        this.transitGatewayAttachment = transitGatewayAttachment;
    }

    public AnalysisComponent getTransitGatewayAttachment() {
        return this.transitGatewayAttachment;
    }

    public Explanation withTransitGatewayAttachment(AnalysisComponent transitGatewayAttachment) {
        this.setTransitGatewayAttachment(transitGatewayAttachment);
        return this;
    }

    public void setComponentAccount(String componentAccount) {
        this.componentAccount = componentAccount;
    }

    public String getComponentAccount() {
        return this.componentAccount;
    }

    public Explanation withComponentAccount(String componentAccount) {
        this.setComponentAccount(componentAccount);
        return this;
    }

    public void setComponentRegion(String componentRegion) {
        this.componentRegion = componentRegion;
    }

    public String getComponentRegion() {
        return this.componentRegion;
    }

    public Explanation withComponentRegion(String componentRegion) {
        this.setComponentRegion(componentRegion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAcl() != null) {
            sb.append("Acl: ").append(this.getAcl()).append(",");
        }
        if (this.getAclRule() != null) {
            sb.append("AclRule: ").append(this.getAclRule()).append(",");
        }
        if (this.getAddress() != null) {
            sb.append("Address: ").append(this.getAddress()).append(",");
        }
        if (this.getAddresses() != null) {
            sb.append("Addresses: ").append(this.getAddresses()).append(",");
        }
        if (this.getAttachedTo() != null) {
            sb.append("AttachedTo: ").append(this.getAttachedTo()).append(",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.getAvailabilityZones()).append(",");
        }
        if (this.getCidrs() != null) {
            sb.append("Cidrs: ").append(this.getCidrs()).append(",");
        }
        if (this.getComponent() != null) {
            sb.append("Component: ").append(this.getComponent()).append(",");
        }
        if (this.getCustomerGateway() != null) {
            sb.append("CustomerGateway: ").append(this.getCustomerGateway()).append(",");
        }
        if (this.getDestination() != null) {
            sb.append("Destination: ").append(this.getDestination()).append(",");
        }
        if (this.getDestinationVpc() != null) {
            sb.append("DestinationVpc: ").append(this.getDestinationVpc()).append(",");
        }
        if (this.getDirection() != null) {
            sb.append("Direction: ").append(this.getDirection()).append(",");
        }
        if (this.getExplanationCode() != null) {
            sb.append("ExplanationCode: ").append(this.getExplanationCode()).append(",");
        }
        if (this.getIngressRouteTable() != null) {
            sb.append("IngressRouteTable: ").append(this.getIngressRouteTable()).append(",");
        }
        if (this.getInternetGateway() != null) {
            sb.append("InternetGateway: ").append(this.getInternetGateway()).append(",");
        }
        if (this.getLoadBalancerArn() != null) {
            sb.append("LoadBalancerArn: ").append(this.getLoadBalancerArn()).append(",");
        }
        if (this.getClassicLoadBalancerListener() != null) {
            sb.append("ClassicLoadBalancerListener: ").append(this.getClassicLoadBalancerListener()).append(",");
        }
        if (this.getLoadBalancerListenerPort() != null) {
            sb.append("LoadBalancerListenerPort: ").append(this.getLoadBalancerListenerPort()).append(",");
        }
        if (this.getLoadBalancerTarget() != null) {
            sb.append("LoadBalancerTarget: ").append(this.getLoadBalancerTarget()).append(",");
        }
        if (this.getLoadBalancerTargetGroup() != null) {
            sb.append("LoadBalancerTargetGroup: ").append(this.getLoadBalancerTargetGroup()).append(",");
        }
        if (this.getLoadBalancerTargetGroups() != null) {
            sb.append("LoadBalancerTargetGroups: ").append(this.getLoadBalancerTargetGroups()).append(",");
        }
        if (this.getLoadBalancerTargetPort() != null) {
            sb.append("LoadBalancerTargetPort: ").append(this.getLoadBalancerTargetPort()).append(",");
        }
        if (this.getElasticLoadBalancerListener() != null) {
            sb.append("ElasticLoadBalancerListener: ").append(this.getElasticLoadBalancerListener()).append(",");
        }
        if (this.getMissingComponent() != null) {
            sb.append("MissingComponent: ").append(this.getMissingComponent()).append(",");
        }
        if (this.getNatGateway() != null) {
            sb.append("NatGateway: ").append(this.getNatGateway()).append(",");
        }
        if (this.getNetworkInterface() != null) {
            sb.append("NetworkInterface: ").append(this.getNetworkInterface()).append(",");
        }
        if (this.getPacketField() != null) {
            sb.append("PacketField: ").append(this.getPacketField()).append(",");
        }
        if (this.getVpcPeeringConnection() != null) {
            sb.append("VpcPeeringConnection: ").append(this.getVpcPeeringConnection()).append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort()).append(",");
        }
        if (this.getPortRanges() != null) {
            sb.append("PortRanges: ").append(this.getPortRanges()).append(",");
        }
        if (this.getPrefixList() != null) {
            sb.append("PrefixList: ").append(this.getPrefixList()).append(",");
        }
        if (this.getProtocols() != null) {
            sb.append("Protocols: ").append(this.getProtocols()).append(",");
        }
        if (this.getRouteTableRoute() != null) {
            sb.append("RouteTableRoute: ").append(this.getRouteTableRoute()).append(",");
        }
        if (this.getRouteTable() != null) {
            sb.append("RouteTable: ").append(this.getRouteTable()).append(",");
        }
        if (this.getSecurityGroup() != null) {
            sb.append("SecurityGroup: ").append(this.getSecurityGroup()).append(",");
        }
        if (this.getSecurityGroupRule() != null) {
            sb.append("SecurityGroupRule: ").append(this.getSecurityGroupRule()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getSourceVpc() != null) {
            sb.append("SourceVpc: ").append(this.getSourceVpc()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getSubnet() != null) {
            sb.append("Subnet: ").append(this.getSubnet()).append(",");
        }
        if (this.getSubnetRouteTable() != null) {
            sb.append("SubnetRouteTable: ").append(this.getSubnetRouteTable()).append(",");
        }
        if (this.getVpc() != null) {
            sb.append("Vpc: ").append(this.getVpc()).append(",");
        }
        if (this.getVpcEndpoint() != null) {
            sb.append("VpcEndpoint: ").append(this.getVpcEndpoint()).append(",");
        }
        if (this.getVpnConnection() != null) {
            sb.append("VpnConnection: ").append(this.getVpnConnection()).append(",");
        }
        if (this.getVpnGateway() != null) {
            sb.append("VpnGateway: ").append(this.getVpnGateway()).append(",");
        }
        if (this.getTransitGateway() != null) {
            sb.append("TransitGateway: ").append(this.getTransitGateway()).append(",");
        }
        if (this.getTransitGatewayRouteTable() != null) {
            sb.append("TransitGatewayRouteTable: ").append(this.getTransitGatewayRouteTable()).append(",");
        }
        if (this.getTransitGatewayRouteTableRoute() != null) {
            sb.append("TransitGatewayRouteTableRoute: ").append(this.getTransitGatewayRouteTableRoute()).append(",");
        }
        if (this.getTransitGatewayAttachment() != null) {
            sb.append("TransitGatewayAttachment: ").append(this.getTransitGatewayAttachment()).append(",");
        }
        if (this.getComponentAccount() != null) {
            sb.append("ComponentAccount: ").append(this.getComponentAccount()).append(",");
        }
        if (this.getComponentRegion() != null) {
            sb.append("ComponentRegion: ").append(this.getComponentRegion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Explanation)) {
            return false;
        }
        Explanation other = (Explanation)obj;
        if (other.getAcl() == null ^ this.getAcl() == null) {
            return false;
        }
        if (other.getAcl() != null && !other.getAcl().equals(this.getAcl())) {
            return false;
        }
        if (other.getAclRule() == null ^ this.getAclRule() == null) {
            return false;
        }
        if (other.getAclRule() != null && !other.getAclRule().equals(this.getAclRule())) {
            return false;
        }
        if (other.getAddress() == null ^ this.getAddress() == null) {
            return false;
        }
        if (other.getAddress() != null && !other.getAddress().equals(this.getAddress())) {
            return false;
        }
        if (other.getAddresses() == null ^ this.getAddresses() == null) {
            return false;
        }
        if (other.getAddresses() != null && !other.getAddresses().equals(this.getAddresses())) {
            return false;
        }
        if (other.getAttachedTo() == null ^ this.getAttachedTo() == null) {
            return false;
        }
        if (other.getAttachedTo() != null && !other.getAttachedTo().equals(this.getAttachedTo())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getCidrs() == null ^ this.getCidrs() == null) {
            return false;
        }
        if (other.getCidrs() != null && !other.getCidrs().equals(this.getCidrs())) {
            return false;
        }
        if (other.getComponent() == null ^ this.getComponent() == null) {
            return false;
        }
        if (other.getComponent() != null && !other.getComponent().equals(this.getComponent())) {
            return false;
        }
        if (other.getCustomerGateway() == null ^ this.getCustomerGateway() == null) {
            return false;
        }
        if (other.getCustomerGateway() != null && !other.getCustomerGateway().equals(this.getCustomerGateway())) {
            return false;
        }
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getDestinationVpc() == null ^ this.getDestinationVpc() == null) {
            return false;
        }
        if (other.getDestinationVpc() != null && !other.getDestinationVpc().equals(this.getDestinationVpc())) {
            return false;
        }
        if (other.getDirection() == null ^ this.getDirection() == null) {
            return false;
        }
        if (other.getDirection() != null && !other.getDirection().equals(this.getDirection())) {
            return false;
        }
        if (other.getExplanationCode() == null ^ this.getExplanationCode() == null) {
            return false;
        }
        if (other.getExplanationCode() != null && !other.getExplanationCode().equals(this.getExplanationCode())) {
            return false;
        }
        if (other.getIngressRouteTable() == null ^ this.getIngressRouteTable() == null) {
            return false;
        }
        if (other.getIngressRouteTable() != null && !other.getIngressRouteTable().equals(this.getIngressRouteTable())) {
            return false;
        }
        if (other.getInternetGateway() == null ^ this.getInternetGateway() == null) {
            return false;
        }
        if (other.getInternetGateway() != null && !other.getInternetGateway().equals(this.getInternetGateway())) {
            return false;
        }
        if (other.getLoadBalancerArn() == null ^ this.getLoadBalancerArn() == null) {
            return false;
        }
        if (other.getLoadBalancerArn() != null && !other.getLoadBalancerArn().equals(this.getLoadBalancerArn())) {
            return false;
        }
        if (other.getClassicLoadBalancerListener() == null ^ this.getClassicLoadBalancerListener() == null) {
            return false;
        }
        if (other.getClassicLoadBalancerListener() != null && !other.getClassicLoadBalancerListener().equals(this.getClassicLoadBalancerListener())) {
            return false;
        }
        if (other.getLoadBalancerListenerPort() == null ^ this.getLoadBalancerListenerPort() == null) {
            return false;
        }
        if (other.getLoadBalancerListenerPort() != null && !other.getLoadBalancerListenerPort().equals(this.getLoadBalancerListenerPort())) {
            return false;
        }
        if (other.getLoadBalancerTarget() == null ^ this.getLoadBalancerTarget() == null) {
            return false;
        }
        if (other.getLoadBalancerTarget() != null && !other.getLoadBalancerTarget().equals(this.getLoadBalancerTarget())) {
            return false;
        }
        if (other.getLoadBalancerTargetGroup() == null ^ this.getLoadBalancerTargetGroup() == null) {
            return false;
        }
        if (other.getLoadBalancerTargetGroup() != null && !other.getLoadBalancerTargetGroup().equals(this.getLoadBalancerTargetGroup())) {
            return false;
        }
        if (other.getLoadBalancerTargetGroups() == null ^ this.getLoadBalancerTargetGroups() == null) {
            return false;
        }
        if (other.getLoadBalancerTargetGroups() != null && !other.getLoadBalancerTargetGroups().equals(this.getLoadBalancerTargetGroups())) {
            return false;
        }
        if (other.getLoadBalancerTargetPort() == null ^ this.getLoadBalancerTargetPort() == null) {
            return false;
        }
        if (other.getLoadBalancerTargetPort() != null && !other.getLoadBalancerTargetPort().equals(this.getLoadBalancerTargetPort())) {
            return false;
        }
        if (other.getElasticLoadBalancerListener() == null ^ this.getElasticLoadBalancerListener() == null) {
            return false;
        }
        if (other.getElasticLoadBalancerListener() != null && !other.getElasticLoadBalancerListener().equals(this.getElasticLoadBalancerListener())) {
            return false;
        }
        if (other.getMissingComponent() == null ^ this.getMissingComponent() == null) {
            return false;
        }
        if (other.getMissingComponent() != null && !other.getMissingComponent().equals(this.getMissingComponent())) {
            return false;
        }
        if (other.getNatGateway() == null ^ this.getNatGateway() == null) {
            return false;
        }
        if (other.getNatGateway() != null && !other.getNatGateway().equals(this.getNatGateway())) {
            return false;
        }
        if (other.getNetworkInterface() == null ^ this.getNetworkInterface() == null) {
            return false;
        }
        if (other.getNetworkInterface() != null && !other.getNetworkInterface().equals(this.getNetworkInterface())) {
            return false;
        }
        if (other.getPacketField() == null ^ this.getPacketField() == null) {
            return false;
        }
        if (other.getPacketField() != null && !other.getPacketField().equals(this.getPacketField())) {
            return false;
        }
        if (other.getVpcPeeringConnection() == null ^ this.getVpcPeeringConnection() == null) {
            return false;
        }
        if (other.getVpcPeeringConnection() != null && !other.getVpcPeeringConnection().equals(this.getVpcPeeringConnection())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getPortRanges() == null ^ this.getPortRanges() == null) {
            return false;
        }
        if (other.getPortRanges() != null && !other.getPortRanges().equals(this.getPortRanges())) {
            return false;
        }
        if (other.getPrefixList() == null ^ this.getPrefixList() == null) {
            return false;
        }
        if (other.getPrefixList() != null && !other.getPrefixList().equals(this.getPrefixList())) {
            return false;
        }
        if (other.getProtocols() == null ^ this.getProtocols() == null) {
            return false;
        }
        if (other.getProtocols() != null && !other.getProtocols().equals(this.getProtocols())) {
            return false;
        }
        if (other.getRouteTableRoute() == null ^ this.getRouteTableRoute() == null) {
            return false;
        }
        if (other.getRouteTableRoute() != null && !other.getRouteTableRoute().equals(this.getRouteTableRoute())) {
            return false;
        }
        if (other.getRouteTable() == null ^ this.getRouteTable() == null) {
            return false;
        }
        if (other.getRouteTable() != null && !other.getRouteTable().equals(this.getRouteTable())) {
            return false;
        }
        if (other.getSecurityGroup() == null ^ this.getSecurityGroup() == null) {
            return false;
        }
        if (other.getSecurityGroup() != null && !other.getSecurityGroup().equals(this.getSecurityGroup())) {
            return false;
        }
        if (other.getSecurityGroupRule() == null ^ this.getSecurityGroupRule() == null) {
            return false;
        }
        if (other.getSecurityGroupRule() != null && !other.getSecurityGroupRule().equals(this.getSecurityGroupRule())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getSourceVpc() == null ^ this.getSourceVpc() == null) {
            return false;
        }
        if (other.getSourceVpc() != null && !other.getSourceVpc().equals(this.getSourceVpc())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getSubnet() == null ^ this.getSubnet() == null) {
            return false;
        }
        if (other.getSubnet() != null && !other.getSubnet().equals(this.getSubnet())) {
            return false;
        }
        if (other.getSubnetRouteTable() == null ^ this.getSubnetRouteTable() == null) {
            return false;
        }
        if (other.getSubnetRouteTable() != null && !other.getSubnetRouteTable().equals(this.getSubnetRouteTable())) {
            return false;
        }
        if (other.getVpc() == null ^ this.getVpc() == null) {
            return false;
        }
        if (other.getVpc() != null && !other.getVpc().equals(this.getVpc())) {
            return false;
        }
        if (other.getVpcEndpoint() == null ^ this.getVpcEndpoint() == null) {
            return false;
        }
        if (other.getVpcEndpoint() != null && !other.getVpcEndpoint().equals(this.getVpcEndpoint())) {
            return false;
        }
        if (other.getVpnConnection() == null ^ this.getVpnConnection() == null) {
            return false;
        }
        if (other.getVpnConnection() != null && !other.getVpnConnection().equals(this.getVpnConnection())) {
            return false;
        }
        if (other.getVpnGateway() == null ^ this.getVpnGateway() == null) {
            return false;
        }
        if (other.getVpnGateway() != null && !other.getVpnGateway().equals(this.getVpnGateway())) {
            return false;
        }
        if (other.getTransitGateway() == null ^ this.getTransitGateway() == null) {
            return false;
        }
        if (other.getTransitGateway() != null && !other.getTransitGateway().equals(this.getTransitGateway())) {
            return false;
        }
        if (other.getTransitGatewayRouteTable() == null ^ this.getTransitGatewayRouteTable() == null) {
            return false;
        }
        if (other.getTransitGatewayRouteTable() != null && !other.getTransitGatewayRouteTable().equals(this.getTransitGatewayRouteTable())) {
            return false;
        }
        if (other.getTransitGatewayRouteTableRoute() == null ^ this.getTransitGatewayRouteTableRoute() == null) {
            return false;
        }
        if (other.getTransitGatewayRouteTableRoute() != null && !other.getTransitGatewayRouteTableRoute().equals(this.getTransitGatewayRouteTableRoute())) {
            return false;
        }
        if (other.getTransitGatewayAttachment() == null ^ this.getTransitGatewayAttachment() == null) {
            return false;
        }
        if (other.getTransitGatewayAttachment() != null && !other.getTransitGatewayAttachment().equals(this.getTransitGatewayAttachment())) {
            return false;
        }
        if (other.getComponentAccount() == null ^ this.getComponentAccount() == null) {
            return false;
        }
        if (other.getComponentAccount() != null && !other.getComponentAccount().equals(this.getComponentAccount())) {
            return false;
        }
        if (other.getComponentRegion() == null ^ this.getComponentRegion() == null) {
            return false;
        }
        return other.getComponentRegion() == null || other.getComponentRegion().equals(this.getComponentRegion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAcl() == null ? 0 : this.getAcl().hashCode());
        hashCode = 31 * hashCode + (this.getAclRule() == null ? 0 : this.getAclRule().hashCode());
        hashCode = 31 * hashCode + (this.getAddress() == null ? 0 : this.getAddress().hashCode());
        hashCode = 31 * hashCode + (this.getAddresses() == null ? 0 : this.getAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getAttachedTo() == null ? 0 : this.getAttachedTo().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getCidrs() == null ? 0 : this.getCidrs().hashCode());
        hashCode = 31 * hashCode + (this.getComponent() == null ? 0 : this.getComponent().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerGateway() == null ? 0 : this.getCustomerGateway().hashCode());
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationVpc() == null ? 0 : this.getDestinationVpc().hashCode());
        hashCode = 31 * hashCode + (this.getDirection() == null ? 0 : this.getDirection().hashCode());
        hashCode = 31 * hashCode + (this.getExplanationCode() == null ? 0 : this.getExplanationCode().hashCode());
        hashCode = 31 * hashCode + (this.getIngressRouteTable() == null ? 0 : this.getIngressRouteTable().hashCode());
        hashCode = 31 * hashCode + (this.getInternetGateway() == null ? 0 : this.getInternetGateway().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancerArn() == null ? 0 : this.getLoadBalancerArn().hashCode());
        hashCode = 31 * hashCode + (this.getClassicLoadBalancerListener() == null ? 0 : this.getClassicLoadBalancerListener().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancerListenerPort() == null ? 0 : this.getLoadBalancerListenerPort().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancerTarget() == null ? 0 : this.getLoadBalancerTarget().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancerTargetGroup() == null ? 0 : this.getLoadBalancerTargetGroup().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancerTargetGroups() == null ? 0 : this.getLoadBalancerTargetGroups().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancerTargetPort() == null ? 0 : this.getLoadBalancerTargetPort().hashCode());
        hashCode = 31 * hashCode + (this.getElasticLoadBalancerListener() == null ? 0 : this.getElasticLoadBalancerListener().hashCode());
        hashCode = 31 * hashCode + (this.getMissingComponent() == null ? 0 : this.getMissingComponent().hashCode());
        hashCode = 31 * hashCode + (this.getNatGateway() == null ? 0 : this.getNatGateway().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterface() == null ? 0 : this.getNetworkInterface().hashCode());
        hashCode = 31 * hashCode + (this.getPacketField() == null ? 0 : this.getPacketField().hashCode());
        hashCode = 31 * hashCode + (this.getVpcPeeringConnection() == null ? 0 : this.getVpcPeeringConnection().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getPortRanges() == null ? 0 : this.getPortRanges().hashCode());
        hashCode = 31 * hashCode + (this.getPrefixList() == null ? 0 : this.getPrefixList().hashCode());
        hashCode = 31 * hashCode + (this.getProtocols() == null ? 0 : this.getProtocols().hashCode());
        hashCode = 31 * hashCode + (this.getRouteTableRoute() == null ? 0 : this.getRouteTableRoute().hashCode());
        hashCode = 31 * hashCode + (this.getRouteTable() == null ? 0 : this.getRouteTable().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroup() == null ? 0 : this.getSecurityGroup().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupRule() == null ? 0 : this.getSecurityGroupRule().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getSourceVpc() == null ? 0 : this.getSourceVpc().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getSubnet() == null ? 0 : this.getSubnet().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetRouteTable() == null ? 0 : this.getSubnetRouteTable().hashCode());
        hashCode = 31 * hashCode + (this.getVpc() == null ? 0 : this.getVpc().hashCode());
        hashCode = 31 * hashCode + (this.getVpcEndpoint() == null ? 0 : this.getVpcEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getVpnConnection() == null ? 0 : this.getVpnConnection().hashCode());
        hashCode = 31 * hashCode + (this.getVpnGateway() == null ? 0 : this.getVpnGateway().hashCode());
        hashCode = 31 * hashCode + (this.getTransitGateway() == null ? 0 : this.getTransitGateway().hashCode());
        hashCode = 31 * hashCode + (this.getTransitGatewayRouteTable() == null ? 0 : this.getTransitGatewayRouteTable().hashCode());
        hashCode = 31 * hashCode + (this.getTransitGatewayRouteTableRoute() == null ? 0 : this.getTransitGatewayRouteTableRoute().hashCode());
        hashCode = 31 * hashCode + (this.getTransitGatewayAttachment() == null ? 0 : this.getTransitGatewayAttachment().hashCode());
        hashCode = 31 * hashCode + (this.getComponentAccount() == null ? 0 : this.getComponentAccount().hashCode());
        hashCode = 31 * hashCode + (this.getComponentRegion() == null ? 0 : this.getComponentRegion().hashCode());
        return hashCode;
    }

    public Explanation clone() {
        try {
            return (Explanation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

